/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.buffer;

import crazydev.common.system.CdRamUsageEstimator;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.offline.common.OlapBuilderOfflineSerializer;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class OlapBuilderBufferDataTableRow
implements IOlapBuilderTableRow {
    private static long SHALLOW_SIZE_OF = -1L;
    private final Comparable[] values;

    public OlapBuilderBufferDataTableRow(int size) {
        this(new Comparable[size]);
    }

    public OlapBuilderBufferDataTableRow(int maxSize, List<IOlapBuilderDataColumnDef> columns, IOlapBuilderTableRow data) {
        this.values = new Comparable[maxSize];
        for (IOlapBuilderDataColumnDef columnDef : columns) {
            this.put(columnDef, data.getJavaNativeDataValue(columnDef));
        }
    }

    public OlapBuilderBufferDataTableRow(Comparable[] values) {
        this.values = values;
    }

    public Comparable[] getValues() {
        return this.values;
    }

    public long sizeOf() {
        long size = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
        size += CdRamUsageEstimator.shallowSizeOf((Object[])this.values);
        for (Comparable value : this.values) {
            try {
                OlapBuilderOfflineSerializer.Serializer serializer = OlapBuilderOfflineSerializer.getSerializerForNativeValue(value);
                size += serializer.sizeOf(value);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return size;
    }

    @Override
    public Comparable getJavaNativeDataValue(IOlapBuilderDataColumnDef columnDef) {
        return this.values[columnDef.getIndex()];
    }

    public void put(IOlapBuilderDataColumnDef column, @Nullable Comparable value) {
        this.values[column.getIndex()] = value;
    }
}

