/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.buffer;

import crazydev.common.system.CdRamUsageEstimator;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.buffer.OlapBuilderBufferConnection;
import crazydev.iccube.builder.datasource.buffer.OlapBuilderBufferDataTableRow;
import crazydev.iccube.builder.datasource.buffer.OlapBuilderBufferDataTableRowReader;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.enums.OlapIncrementalLoadStrategy;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderBufferDataTable
extends OlapBuilderBaseDataTable<OlapBuilderBufferConnection> {
    private static long SHALLOW_SIZE_OF = -1L;
    private final ArrayList<OlapBuilderBufferDataTableRow> buffer = new ArrayList();

    public OlapBuilderBufferDataTable(String id, String tableName, List<IOlapBuilderDataColumnDef> columns) {
        this(id, tableName, columns, null);
    }

    public OlapBuilderBufferDataTable(String id, String tableName, List<IOlapBuilderDataColumnDef> columns, @Nullable OlapIncrementalLoadStrategy strategy) {
        super(tableName, columns);
        this.setIncrementalLoadStrategy(strategy);
        this.setId(id);
    }

    @Override
    protected IOlapBuilderTableRowReader<OlapBuilderBufferConnection> doCreateFullTableRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount) {
        return new OlapBuilderBufferDataTableRowReader(context, connectionPool, maxRowCount, this, this.buffer);
    }

    @Override
    public String getInternalFriendlyTypeName() {
        return "Buffer Table";
    }

    public int size() {
        return this.buffer.size();
    }

    public long sizeOf() {
        long size = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
        size += CdRamUsageEstimator.shallowSizeOfEx(this.buffer);
        for (OlapBuilderBufferDataTableRow row : this.buffer) {
            size += row.sizeOf();
        }
        return size;
    }

    public void addRow(IOlapBuilderTableRow data) {
        List<IOlapBuilderDataColumnDef> cols = this.getSelectedColumns();
        int colsSize = cols.size();
        int maxIndex = -1;
        for (IOlapBuilderDataColumnDef col : cols) {
            int colIndex = col.getIndex();
            if (colIndex <= maxIndex) continue;
            maxIndex = colIndex;
        }
        int rowSize = maxIndex + 1;
        OlapBuilderBufferDataTableRow row = new OlapBuilderBufferDataTableRow(rowSize);
        this.buffer.add(row);
        for (int ii = 0; ii < colsSize; ++ii) {
            IOlapBuilderDataColumnDef column = cols.get(ii);
            Comparable cell = data.getJavaNativeDataValue(column);
            row.put(column, cell);
        }
    }

    public boolean hasData() {
        return !this.buffer.isEmpty();
    }

    public void clearData() {
        this.buffer.clear();
    }

    public List<OlapBuilderBufferDataTableRow> getData() {
        return this.buffer;
    }

    @Override
    @Nullable
    protected IOlapBuilderTableRowReader createRowReaderForTableCacheRead(OlapBuilderContext context) {
        return null;
    }

    @Override
    protected IOlapBuilderTableRowReader decorateRowReaderForTableCache(OlapBuilderContext context, IOlapBuilderTableRowReader reader) {
        return reader;
    }
}

