/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.common;

import com.google.gson.stream.JsonReader;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.utils.CdLineReader;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.common.OlapAbstractFileSystem;
import crazydev.iccube.builder.datasource.http.OlapBuilderHttpBaseAuthenticationConnection;
import crazydev.iccube.builder.datasource.http.OlapBuilderHttpConnection;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.fs.OlapFileNameFilter;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import java.io.BufferedReader;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class OlapHttpFileSystem
extends OlapAbstractFileSystem {
    private OlapBuilderHttpConnection connection;

    public OlapHttpFileSystem(String baseUrl, String user, String pwd, String httpHeader) {
        this.connection = CdStringUtils.isNullOrBlank((String)user) && CdStringUtils.isNullOrBlank((String)pwd) ? new OlapBuilderHttpConnection(baseUrl, httpHeader) : new OlapBuilderHttpBaseAuthenticationConnection(baseUrl, user, pwd, httpHeader);
    }

    @Override
    public void onOpen(OlapRuntimeContext context) throws OlapBuilderErrorException {
        this.connection.open(context);
    }

    @Override
    public void onClose() {
        this.connection.close();
        this.connection = null;
    }

    @Override
    public InputStream getInputStream(OlapRuntimeContext context, String untrustedFileName, String fileEncoding) {
        return this.connection.getInputStream(context, untrustedFileName, fileEncoding);
    }

    @Override
    public BufferedReader getReader(OlapRuntimeContext context, String untrustedFileName, String fileEncoding) {
        return this.connection.executeToReader(context, untrustedFileName, fileEncoding);
    }

    @Override
    public JsonReader createMultiFileJsonReader(OlapRuntimeContext context, boolean sorted, @Nullable Predicate<String> fileFilter, String fileEncoding) {
        throw new CdShouldNotBeHereProgrammingException("Not yet supported");
    }

    @Override
    public List<Supplier<BufferedReader>> getMultiFileBufferedReaders(OlapRuntimeContext context, @Nullable Predicate<String> fileFilter, boolean sorted, String fileEncoding) {
        throw new CdShouldNotBeHereProgrammingException("Not yet supported");
    }

    @Override
    public CdLineReader createMultiFileReader(OlapRuntimeContext context, boolean sorted, @Nullable Predicate<String> fileFilter, String fileEncoding) {
        throw new CdShouldNotBeHereProgrammingException("Not yet supported");
    }

    @Override
    public List<String> listLocalFileNames(OlapFileNameFilter filter) {
        return Collections.emptyList();
    }

    @Override
    public boolean fileExists(OlapRuntimeContext context, String untrustedFileName) {
        return untrustedFileName.equals(untrustedFileName);
    }

    @Override
    public String getUnderlyingAbsolutePathForUserError(OlapRuntimeContext context, String untrustedFileName) {
        return untrustedFileName;
    }
}

