/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder;

import crazydev.common.collection.CdCollections;
import crazydev.common.collection.CdTracingMap;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderCubeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderReferenceContainer;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumnRef;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderReferenceSolver {
    private final CdTracingMap<String, IOlapBuilderTabularDataDef> allTabularData = new CdTracingMap();
    private final CdTracingMap<String, IOlapBuilderCubeDef> cubeMap = new CdTracingMap();
    private final CdTracingMap<IOlapBuilderTabularDataDef, CdTracingMap<String, IOlapBuilderDataColumnDef>> columnMap = new CdTracingMap();
    private final CdTracingMap<String, IOlapBuilderDimensionDef<?>> dimensionMap = new CdTracingMap();
    private final OlapBuilderErrorManager errorManager;

    public OlapBuilderReferenceSolver(OlapBuilderErrorManager errorManager) {
        this.errorManager = errorManager;
    }

    public OlapBuilderErrorManager getErrorManager() {
        return this.errorManager;
    }

    public void add(IOlapBuilderTabularDataDef tabularData) {
        this.allTabularData.put((Object)tabularData.getId(), (Object)tabularData);
        this.addColumns(tabularData);
    }

    public void addForColumnsSetup(IOlapBuilderDataViewDef view) {
        this.allTabularData.put((Object)view.getId(), (Object)view);
    }

    public void addWithColumnsSetup(IOlapBuilderDataViewDef view) {
        this.allTabularData.put((Object)view.getId(), (Object)view);
        this.addColumns(view);
    }

    private void addColumns(IOlapBuilderTabularDataDef tabularData) {
        CdTracingMap columns = new CdTracingMap();
        List<IOlapBuilderDataColumnDef> selectedColumns = tabularData.getSelectedColumns();
        int size = selectedColumns.size();
        for (int ii = 0; ii < size; ++ii) {
            IOlapBuilderDataColumnDef columnDef = selectedColumns.get(ii);
            columns.put((Object)columnDef.getName(), (Object)columnDef);
        }
        this.columnMap.put((Object)tabularData, (Object)columns);
    }

    public void add(IOlapBuilderCubeDef cube) {
        this.cubeMap.put((Object)cube.getId(), (Object)cube);
    }

    public void add(IOlapBuilderDimensionDef<?> dimension) {
        IOlapBuilderDataTableDef internalTable = dimension.getInternalCreatedDataTable();
        if (internalTable != null) {
            this.add(internalTable);
        }
        this.dimensionMap.put((Object)dimension.getId(), dimension);
    }

    @Nullable
    public IOlapBuilderTabularDataDef getTabularData(@Nullable String tableId) {
        if (CdStringUtils.isNullOrBlank((String)tableId)) {
            return null;
        }
        IOlapBuilderTabularDataDef table = (IOlapBuilderTabularDataDef)this.allTabularData.get((Object)tableId);
        if (table == null) {
            this.errorManager.addError(OlapBuilderErrorCode.DATATABLE_FOR_ID_NOT_FOUND_IN_DATASOURCE, new Serializable[]{tableId});
        }
        return table;
    }

    @Nullable
    public IOlapBuilderCubeDef getCube(String cubeId) {
        if (cubeId == null) {
            return null;
        }
        IOlapBuilderCubeDef cube = (IOlapBuilderCubeDef)this.cubeMap.get((Object)cubeId);
        if (cube == null) {
            this.errorManager.addError(OlapBuilderErrorCode.CUBE_FOR_ID_NOT_FOUND_IN_DATASOURCE, new Serializable[]{cubeId});
        }
        return cube;
    }

    @Nullable
    public IOlapBuilderDimensionDef<?> getDimension(String dimensionId) {
        IOlapBuilderDimensionDef dimension = (IOlapBuilderDimensionDef)this.dimensionMap.get((Object)dimensionId);
        if (dimension == null) {
            this.errorManager.addError(OlapBuilderErrorCode.DIMENSION_FOR_ID_NOT_FOUND_IN_SCHEMA, new Serializable[]{dimensionId});
        }
        return dimension;
    }

    public void touchColumn(IOlapBuilderTabularDataDef table, IOlapBuilderDataColumnDef column) {
        CdTracingMap<String, IOlapBuilderDataColumnDef> columns = (CdTracingMap<String, IOlapBuilderDataColumnDef>)this.columnMap.get((Object)table);
        if (columns == null && (columns = this.getColumnsByTableId(table.getId())) == null) {
            throw new RuntimeException("internal error : missed table [" + table.getId() + "] in reference solver");
        }
        if (columns.get((Object)column.getName()) == null) {
            throw new RuntimeException("internal error : missed column [" + column.getName() + "] in table [" + table.getId() + "] in reference solver");
        }
    }

    private CdTracingMap<String, IOlapBuilderDataColumnDef> getColumnsByTableId(String id) {
        for (Map.Entry entry : this.columnMap.entrySet()) {
            if (!id.equals(((IOlapBuilderTabularDataDef)entry.getKey()).getId())) continue;
            return (CdTracingMap)entry.getValue();
        }
        return null;
    }

    @Nullable
    public IOlapBuilderDataColumnDef getColumn(IOlapBuilderTabularDataDef table, OlapBuilderDataColumnRef columnRef) {
        if (columnRef == null || CdStringUtils.isNullOrBlank((String)columnRef.getName())) {
            return null;
        }
        CdTracingMap columns = (CdTracingMap)this.columnMap.get((Object)table);
        if (columns == null) {
            throw new RuntimeException("internal error : missed table [" + table.getId() + "] in reference solver");
        }
        IOlapBuilderDataColumnDef columnDef = (IOlapBuilderDataColumnDef)columns.get((Object)columnRef.getName());
        if (columnDef != null) {
            return columnDef;
        }
        this.errorManager.addError(OlapBuilderErrorCode.MISSED_COLUMN_IN_DATASOURCE, new Serializable[]{columnRef.getName(), table.getName()});
        return null;
    }

    @Nullable
    public List<IOlapBuilderDataColumnDef> getColumns(IOlapBuilderTabularDataDef table, List<OlapBuilderDataColumnRef> columnRefs) {
        if (table == null || columnRefs == null) {
            return Collections.emptyList();
        }
        CdTracingMap columnsDefs = (CdTracingMap)this.columnMap.get((Object)table);
        if (columnsDefs == null) {
            throw new CdProgrammingException("internal error : missed table [" + table.getId() + "] in reference solver");
        }
        int size = columnRefs.size();
        ArrayList<IOlapBuilderDataColumnDef> columns = new ArrayList<IOlapBuilderDataColumnDef>(size);
        for (int ii = 0; ii < size; ++ii) {
            OlapBuilderDataColumnRef dataColumnRef = columnRefs.get(ii);
            IOlapBuilderDataColumnDef columnDef = (IOlapBuilderDataColumnDef)columnsDefs.get((Object)dataColumnRef.getName());
            if (columnDef == null) {
                this.errorManager.addError(OlapBuilderErrorCode.MISSED_COLUMN_IN_DATASOURCE, new Serializable[]{dataColumnRef.getName(), table.getName()});
            }
            columns.add(columnDef);
        }
        return columns;
    }

    public void solveReference(IOlapBuilderReferenceContainer container, @Nullable IOlapBuilderTabularDataDef dataTable) {
        this.errorManager.pushContext(container);
        try {
            container.solveReference(this, dataTable);
        }
        finally {
            this.errorManager.popContext();
        }
    }

    public void cleanupNotUsedColumns(Logger logger, boolean cleanupTableColumns) {
        for (Map.Entry entry : this.columnMap.entrySet()) {
            IOlapBuilderTabularDataDef table = (IOlapBuilderTabularDataDef)entry.getKey();
            boolean doCleanup = cleanupTableColumns && table.canCleanupNotUsedColumns();
            String tableName = table.getName();
            String friendlyTypeName = table.getInternalFriendlyTypeName();
            if (this.allTabularData.wasHit((Object)table.getId())) {
                List<String> missedColumns = this.missedColumns(table, (CdTracingMap<String, IOlapBuilderDataColumnDef>)((CdTracingMap)entry.getValue()));
                String mess = "Ref. Solver : " + friendlyTypeName + " [" + tableName + "] ";
                Level prio = Level.DEBUG;
                if (!missedColumns.isEmpty()) {
                    if (cleanupTableColumns) {
                        if (doCleanup) {
                            mess = mess + "cleaned ";
                        } else {
                            prio = Level.WARN;
                            mess = mess + "needs manual removal of ";
                        }
                    }
                    logger.log((Priority)prio, (Object)(mess + "not used columns {" + CdCollections.toString(missedColumns, (String)"") + "}"));
                } else {
                    logger.debug((Object)(mess + "ok"));
                }
                if (!doCleanup) continue;
                for (String missedColumn : missedColumns) {
                    IOlapBuilderDataColumnDef columnDef = (IOlapBuilderDataColumnDef)((CdTracingMap)entry.getValue()).get((Object)missedColumn);
                    columnDef.setCleanUpBySolver(true);
                }
                continue;
            }
            logger.debug((Object)("Ref. Solver : " + friendlyTypeName + " [" + tableName + "] not used"));
        }
    }

    private List<String> missedColumns(IOlapBuilderTabularDataDef table, CdTracingMap<String, IOlapBuilderDataColumnDef> tracedColumns) {
        List missedKeys = tracedColumns.getMissedKeys();
        if (missedKeys.isEmpty()) {
            return missedKeys;
        }
        ArrayList<String> missed = new ArrayList<String>();
        for (String missedKey : missedKeys) {
            IOlapBuilderDataColumnDef columnDef = (IOlapBuilderDataColumnDef)tracedColumns.get((Object)missedKey);
            if (!table.canCleanupNotUsedColumn(columnDef)) continue;
            missed.add(missedKey);
        }
        return missed;
    }
}

