/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder;

import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.model.builders.IOlapBuilderTableListener;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderCubeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cluster.master.local.facts.M_FactsLocalMeasureGroupManager;
import crazydev.iccube.olap.cube.OlapRegularCube;
import crazydev.iccube.olap.goodies.unresolverows.OlapUnresolvedRowsManager;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaLoadPartitionsInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBuilderLoadEntityContext {
    protected final Logger schemaLogger;
    private final OlapFileCleaner fileCleaner;
    private final Map<IOlapBuilderCubeDef, RequestedCube> requestedCubes = new HashMap<IOlapBuilderCubeDef, RequestedCube>();
    private final Map<IOlapBuilderTabularDataDef, List<IOlapBuilderTableListener>> factBuilders = new HashMap<IOlapBuilderTabularDataDef, List<IOlapBuilderTableListener>>();
    private final List<String> newPartitions = new ArrayList<String>();
    private final List<String> reLoadedPartitions = new ArrayList<String>();
    @Nullable
    protected OlapUnresolvedRowsManager loadedUnresolvedRows;
    @Nullable
    protected OlapUnresolvedRowsManager existingUnresolvedRows;
    protected List<URowsCommand> uRowsCommands = new ArrayList<URowsCommand>();
    private int currentTask;

    public OlapBuilderLoadEntityContext(Logger schemaLogger, OlapFileCleaner fileCleaner) {
        this.schemaLogger = schemaLogger;
        this.fileCleaner = fileCleaner;
    }

    public abstract boolean isLoadMeasureGroup();

    public abstract String commandForLogsAndErrors();

    public Logger getSchemaLogger() {
        return this.schemaLogger;
    }

    public OlapFileCleaner getFileCleaner() {
        return this.fileCleaner;
    }

    public int getCurrentTask() {
        return this.currentTask;
    }

    public void setCurrentTask(int currentTask) {
        this.currentTask = currentTask;
    }

    public void registerRequestedCube(IOlapBuilderCubeDef cubeDef, OlapRegularCube cube) {
        if (this.requestedCubes.put(cubeDef, new RequestedCube(cubeDef, cube)) != null) {
            throw new RuntimeException("internal error: multiple cube registration [" + cubeDef.getName() + "]");
        }
    }

    public void registerRequestedFacts(IOlapBuilderCubeDef cubeDef, IOlapBuilderBaseFactsDef factsDef) {
        RequestedCube cube = this.requestedCubes.get(cubeDef);
        if (cube == null) {
            throw new RuntimeException("internal error: missing cube [" + cubeDef.getName() + "] registration for facts [" + factsDef.getName() + "]");
        }
        cube.factsDefs.add(factsDef);
    }

    public void registerFactBuilder(IOlapBuilderTableListener factBuilder, IOlapBuilderTabularDataDef table) {
        List builders = this.factBuilders.computeIfAbsent(table, key -> new ArrayList());
        builders.add(factBuilder);
    }

    public List<IOlapBuilderTableListener> getFactBuilders(IOlapBuilderTabularDataDef table) {
        List<IOlapBuilderTableListener> builders = this.factBuilders.get(table);
        return builders != null ? builders : Collections.emptyList();
    }

    @Nullable
    public OlapRegularCube getRequestedCube(IOlapBuilderCubeDef cubeDef) {
        RequestedCube cube = this.requestedCubes.get(cubeDef);
        if (cube != null) {
            return cube.cube;
        }
        return null;
    }

    public List<RequestedCube> getRequestedCubes() {
        ArrayList<RequestedCube> cubes = new ArrayList<RequestedCube>();
        for (RequestedCube requestedCube : this.requestedCubes.values()) {
            cubes.add(requestedCube);
        }
        return cubes;
    }

    public List<OlapRegularCube> getRequestedCubesX() {
        ArrayList<OlapRegularCube> cubes = new ArrayList<OlapRegularCube>();
        for (RequestedCube requestedCube : this.requestedCubes.values()) {
            cubes.add(requestedCube.cube);
        }
        return cubes;
    }

    public Set<IOlapBuilderBaseFactsDef> getRequestedFacts(OlapRegularCube cube) {
        HashSet<IOlapBuilderBaseFactsDef> defs = new HashSet<IOlapBuilderBaseFactsDef>();
        for (RequestedCube requestedCube : this.requestedCubes.values()) {
            if (!requestedCube.cube.equals(cube)) continue;
            defs.addAll(requestedCube.factsDefs);
        }
        return defs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAsNewPartition(String partition) {
        List<String> list = this.newPartitions;
        synchronized (list) {
            this.newPartitions.add(partition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAsReLoadedPartition(String partition) {
        List<String> list = this.reLoadedPartitions;
        synchronized (list) {
            this.reLoadedPartitions.add(partition);
        }
    }

    public OlapSchemaLoadPartitionsInfo getLoadPartitionsInfo(OlapSchema loadedSchema) {
        return new OlapSchemaLoadPartitionsInfo(loadedSchema, this.newPartitions, this.reLoadedPartitions);
    }

    public void setUnresolvedRows(OlapUnresolvedRowsManager loadedUnresolvedRows, OlapUnresolvedRowsManager existingUnresolvedRows) {
        this.loadedUnresolvedRows = loadedUnresolvedRows;
        this.existingUnresolvedRows = existingUnresolvedRows;
        this.uRowsCommands.clear();
    }

    public void adoptUnresolvedRowsRemoveMeasureGroup(OlapBuilderContext bContext, M_FactsLocalMeasureGroupManager measureGroup) {
        this.existingUnresolvedRows.adoptRemoveMeasureGroup(this, bContext, this.schemaLogger, this.loadedUnresolvedRows, measureGroup);
    }

    public void adoptUnresolvedRows1(OlapBuilderContext bContext, M_FactsLocalMeasureGroupManager measureGroup, @Nullable IOlapBuilderTablePartitionKey tablePartitionKey) {
        this.existingUnresolvedRows.adopt1(this, bContext, this.schemaLogger, this.loadedUnresolvedRows, measureGroup, tablePartitionKey);
    }

    public void adoptUnresolvedRows2(OlapBuilderContext bContext) {
        this.existingUnresolvedRows.adopt2(this, bContext, this.schemaLogger, this.loadedUnresolvedRows, this.uRowsCommands);
    }

    public void registerUnresolvedRowsCommand(OlapRegularCube cube, M_FactsLocalMeasureGroupManager measureGroup, @Nullable IOlapBuilderTablePartitionKey partitionKey) {
        this.uRowsCommands.add(new URowsCommand(cube, measureGroup, partitionKey));
    }

    public static class RequestedCube {
        final IOlapBuilderCubeDef def;
        final Set<IOlapBuilderBaseFactsDef> factsDefs = new HashSet<IOlapBuilderBaseFactsDef>();
        final OlapRegularCube cube;

        public RequestedCube(IOlapBuilderCubeDef def, OlapRegularCube cube) {
            this.def = def;
            this.cube = cube;
        }

        public String getNameX() {
            Object measureGroupNames = " :";
            int ii = 0;
            for (IOlapBuilderBaseFactsDef measureGroup : this.factsDefs) {
                measureGroupNames = (String)measureGroupNames + (ii++ > 0 ? ", " : " ") + measureGroup.getMeasureGroupName();
            }
            return this.cube.getNameX() + (String)measureGroupNames;
        }
    }

    public static class URowsCommand {
        public final OlapRegularCube cube;
        public final M_FactsLocalMeasureGroupManager measureGroup;
        @Nullable
        public final IOlapBuilderTablePartitionKey tablePartitionKey;

        public URowsCommand(OlapRegularCube cube, M_FactsLocalMeasureGroupManager measureGroup, @Nullable IOlapBuilderTablePartitionKey tablePartitionKey) {
            this.cube = cube;
            this.measureGroup = measureGroup;
            this.tablePartitionKey = tablePartitionKey;
        }
    }
}

