/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.member.OlapMember;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderBaseMemberToMemberMap {
    private final Map<OlapDimension, LinkHolder> map = new HashMap<OlapDimension, LinkHolder>();

    public void addLink(OlapMember baseMember, OlapMember noBaseMember) {
        LinkHolder linkHolder = this.map.get(baseMember.getDimension());
        if (linkHolder == null) {
            linkHolder = new LinkHolder();
            this.map.put(baseMember.getDimension(), linkHolder);
        }
        linkHolder.addLink(baseMember, noBaseMember);
    }

    @Nullable
    public OlapMember[] lookupNoBaseMembers(OlapMember baseMember) {
        LinkHolder linkHolder = this.map.get(baseMember.getDimension());
        return linkHolder == null ? null : linkHolder.get(baseMember);
    }

    public void trimToSize() {
        for (LinkHolder linkHolder : this.map.values()) {
            linkHolder.onFinishAdding();
        }
    }

    public void clear() {
        this.map.clear();
    }

    private static class LinkHolder {
        private Map<OlapMember, ArrayList<OlapMember>> baseMemberToMemberMap = new HashMap<OlapMember, ArrayList<OlapMember>>();
        private OlapMember[][] memberAsArray;

        private LinkHolder() {
        }

        public void addLink(OlapMember baseMember, OlapMember noBaseMember) {
            ArrayList<OlapMember> noBaseMembers = this.baseMemberToMemberMap.get(baseMember);
            if (noBaseMembers == null) {
                noBaseMembers = new ArrayList();
                this.baseMemberToMemberMap.put(baseMember, noBaseMembers);
            }
            noBaseMembers.add(noBaseMember);
        }

        @Nullable
        public OlapMember[] get(OlapMember baseMember) {
            if (this.baseMemberToMemberMap != null) {
                throw new CdShouldNotBeHereProgrammingException();
            }
            if (this.memberAsArray == null) {
                return null;
            }
            OlapMember[] noBaseMembers = this.memberAsArray[baseMember.getUniqueHierarchyMemberIndex()];
            return noBaseMembers;
        }

        public void onFinishAdding() {
            if (this.baseMemberToMemberMap != null && !this.baseMemberToMemberMap.isEmpty()) {
                OlapMember aBaseMember = this.baseMemberToMemberMap.keySet().iterator().next();
                this.memberAsArray = new OlapMember[aBaseMember.getHierarchy().getCurrentMemberIndex() + 1][];
                for (Map.Entry<OlapMember, ArrayList<OlapMember>> entry : this.baseMemberToMemberMap.entrySet()) {
                    ArrayList<OlapMember> memberArrayList = entry.getValue();
                    this.memberAsArray[entry.getKey().getUniqueHierarchyMemberIndex()] = memberArrayList.toArray(new OlapMember[memberArrayList.size()]);
                    entry.setValue(null);
                }
            }
            this.baseMemberToMemberMap = null;
        }
    }
}

