/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.babylon;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.babylon.CdBabylonUtils;
import crazydev.common.utils.CdClassUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class OlapBabylonService
extends CdBabylonService {
    public static final OlapBabylonService ENGLISH = new OlapBabylonService(Locale.ENGLISH);
    private static List<Class> alternateLocalizations = new ArrayList<Class>();
    protected final Locale locale;

    public OlapBabylonService(@Nullable Locale locale) {
        this.locale = locale == null ? Locale.ENGLISH : locale;
    }

    public static void registerAlternateLocalization(@Nullable Class localization) {
        if (localization != null && !alternateLocalizations.contains(localization)) {
            alternateLocalizations.add(localization);
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String translate(String tag, Serializable ... params) {
        return CdBabylonUtils.translate((Set)this.missings, (Locale)this.locale, ((Object)((Object)this)).getClass(), alternateLocalizations, (String)tag, (Serializable[])params);
    }

    public String translateApplicationProperty(String name) {
        return this.translate(name, new Serializable[0]);
    }

    public String translatePropertyLabel(String prefix, String uiPropertyName) {
        Object tag = prefix + "." + uiPropertyName;
        String label = this.translate((String)tag, new Serializable[0]);
        if (label != tag) {
            return label;
        }
        tag = uiPropertyName;
        label = this.translate((String)tag, new Serializable[0]);
        return label;
    }

    @Nullable
    public String translatePropertyDescription(String prefix, String uiPropertyName) {
        String tag = prefix + "." + uiPropertyName + ".description";
        String label = this.translate(tag, new Serializable[0]);
        if (label != tag) {
            return label;
        }
        tag = uiPropertyName + ".description";
        label = this.translate(tag, new Serializable[0]);
        if (label != tag) {
            return label;
        }
        return null;
    }

    @Nullable
    public String translatePropertyHRef(String prefix, String uiPropertyName) {
        String tag = prefix + "." + uiPropertyName + ".href";
        String label = this.translate(tag, new Serializable[0]);
        if (label != tag) {
            return label;
        }
        tag = uiPropertyName + ".href";
        label = this.translate(tag, new Serializable[0]);
        if (label != tag) {
            return label;
        }
        return null;
    }

    @Nullable
    public String translatePropertiesGroup(String prefix, String group) {
        Object tag = "PropertyGroups." + group + "." + prefix;
        String label = this.translate((String)tag, new Serializable[0]);
        if (label != tag) {
            return label;
        }
        tag = "PropertyGroups." + group;
        label = this.translate((String)tag, new Serializable[0]);
        if (label != tag) {
            return label;
        }
        tag = group + "." + prefix;
        label = this.translate((String)tag, new Serializable[0]);
        if (label != tag) {
            return label;
        }
        tag = group;
        label = this.translate((String)tag, new Serializable[0]);
        if (label != tag) {
            return label;
        }
        return null;
    }

    public String translateUiModelTypeLabel(String uiModelType) {
        String tag = CdClassUtils.getSimpleName((String)uiModelType);
        String label = this.translate(tag, new Serializable[0]);
        return label;
    }

    @Nullable
    public String translateUiModelTypeDescription(String uiModelType) {
        String tag = CdClassUtils.getSimpleName((String)uiModelType) + ".description";
        String label = this.translate(tag, new Serializable[0]);
        if (label != tag) {
            return label;
        }
        return null;
    }
}

