/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorizationx.permissions.schemas;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.babylon.CdLoggingBabylonService;
import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.authorization.definition.role.OlapRoleDefinition;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionError;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorCode;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorException;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorManager;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationRuntimeException;
import crazydev.iccube.authorization.permissions.role.OlapRolePermissions;
import crazydev.iccube.authorization.validation.common.OlapRoleDefinitionApplyValidationContext;
import crazydev.iccube.authorization.validation.common.OlapRoleDefinitionValidationHelper;
import crazydev.iccube.authorizationx.definition.schemas.IOlapRoleSchemasDefinition;
import crazydev.iccube.authorizationx.permissions.schema.OlapRoleSchemaFullControlPermissions;
import crazydev.iccube.authorizationx.permissions.schema.OlapRoleSchemaNotCreatedIncrLoadPermissions;
import crazydev.iccube.authorizationx.permissions.schema.OlapRoleSchemaNotCreatedLoadPartitionsPermissions;
import crazydev.iccube.authorizationx.permissions.schema.OlapRoleSchemaNotCreatedPermissions;
import crazydev.iccube.authorizationx.permissions.schema.OlapRoleSchemaNotCreatedUnloadPartitionsPermissions;
import crazydev.iccube.authorizationx.permissions.schema.OlapRoleSchemaOnErrorPermissions;
import crazydev.iccube.authorizationx.permissions.schemas.OlapRoleSchemasPermissions;
import crazydev.iccube.authorizationx.permissions.schemas.OlapRoleSchemasPermissionsTimings;
import crazydev.iccube.contextual.OlapContextualBigException;
import crazydev.iccube.contextual.OlapContextualError;
import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.schemas.OlapEngineInMemorySchemaDefFactoryHelper;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.eval.cache.OlapCacheManager;
import crazydev.iccube.olap.eval.script.OlapScriptInformation;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaIncrLoadInfo;
import crazydev.iccube.olap.schema.OlapSchemaLoadPartitionsInfo;
import crazydev.iccube.olap.schema.OlapSchemaUnloadPartitionsInfo;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public abstract class OlapRoleSchemasRegularPermissions
extends OlapRoleSchemasPermissions {
    private final OlapEngineApplicationContext olapEngineApplicationContext;
    private final OlapRolePermissions administratorPermissions;
    private final OlapRoleDefinition roleDefinition;
    protected final OlapRoleSchemasPermissionsTimings timings;
    private final Object lock = new Object();

    public OlapRoleSchemasRegularPermissions(OlapEngineApplicationContext olapEngineApplicationContext, OlapRolePermissions administratorPermissions, OlapRoleDefinition roleDefinition) {
        this.olapEngineApplicationContext = olapEngineApplicationContext;
        this.administratorPermissions = administratorPermissions;
        this.roleDefinition = roleDefinition;
        this.timings = new OlapRoleSchemasPermissionsTimings(this);
    }

    @Override
    public long getTotalElapsedMS() {
        return this.timings.getTotalElapsedMS();
    }

    @Override
    public String getDetailedTotalElapsedMS() {
        return this.timings.getDetailedTotalElapsedMS();
    }

    @Override
    public String getDefinitionForUX() {
        return this.roleDefinition.getSchemaPermsDefinitionForUX();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSchemaLoaded(OlapEngineRequestContext requestContext, OlapSchema schema) {
        Logger logger = requestContext.getLoggers().authorization();
        Object object = this.lock;
        synchronized (object) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("authorization : schema [" + schema.getName() + "] (loaded) on-demand permissions setup (role:" + this.roleDefinition.getName() + ")"));
            }
            schema.setPermissions(this, new OlapRoleSchemaNotCreatedPermissions(schema));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSchemaIncrLoaded(OlapEngineRequestContext requestContext, OlapSchema schema, OlapSchemaIncrLoadInfo incrLoadInfo) {
        Logger logger = requestContext.getLoggers().authorization();
        Object object = this.lock;
        synchronized (object) {
            if (incrLoadInfo.hasNewMembers()) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("authorization : schema [" + schema.getName() + "] (incr-load) on-demand permissions setup (role:" + this.roleDefinition.getName() + ") SCRATCH (new-members)"));
                }
                this.switchPermissions(requestContext, schema, new OlapRoleSchemaNotCreatedPermissions(schema));
            } else {
                IOlapSchemaPermission existing = schema.getPermissions(this);
                if (existing != null && !existing.isError() && existing.isCreated()) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("authorization : schema [" + schema.getName() + "] (incr-load) on-demand permissions setup (role:" + this.roleDefinition.getName() + ") INCR"));
                    }
                    this.switchPermissions(requestContext, schema, new OlapRoleSchemaNotCreatedIncrLoadPermissions(existing, incrLoadInfo));
                } else {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("authorization : schema [" + schema.getName() + "] (incr-load) on-demand permissions setup (role:" + this.roleDefinition.getName() + ") SCRATCH"));
                    }
                    this.switchPermissions(requestContext, schema, new OlapRoleSchemaNotCreatedPermissions(schema));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSchemaIncrLoadedOnError(OlapEngineRequestContext requestContext, OlapSchema schema) {
        Logger logger = requestContext.getLoggers().authorization();
        Object object = this.lock;
        synchronized (object) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("authorization : schema [" + schema.getName() + "] (incr-load on-error) on-demand permissions setup (role:" + this.roleDefinition.getName() + ")"));
            }
            this.switchPermissions(requestContext, schema, new OlapRoleSchemaNotCreatedPermissions(schema));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSchemaScriptStatementApplied(OlapEngineRequestContext requestContext, OlapSchema schema, OlapScriptInformation information) {
        Logger logger = requestContext.getLoggers().authorization();
        Object object = this.lock;
        synchronized (object) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("authorization : schema [" + schema.getName() + "] (script statement applied) on-demand permissions setup (role:" + this.roleDefinition.getName() + ")"));
            }
            this.switchPermissions(requestContext, schema, new OlapRoleSchemaNotCreatedPermissions(schema));
        }
    }

    @Override
    public void onSchemaUnloaded(OlapEngineRequestContext requestContext, OlapSchema schema) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSchemaPartitionsUnloaded(OlapEngineRequestContext requestContext, OlapSchema schema, OlapSchemaUnloadPartitionsInfo unloadPartitionsInfo) {
        Logger logger = requestContext.getLoggers().authorization();
        Object object = this.lock;
        synchronized (object) {
            IOlapSchemaPermission existing = schema.getPermissions(this);
            if (existing != null && !existing.isError() && existing.isCreated()) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("authorization : schema [" + schema.getName() + "] (partitions unloaded) on-demand permissions setup (role:" + this.roleDefinition.getName() + ") INCR"));
                }
                this.switchPermissions(requestContext, schema, new OlapRoleSchemaNotCreatedUnloadPartitionsPermissions(existing, unloadPartitionsInfo));
            } else {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("authorization : schema [" + schema.getName() + "] (partitions unloaded) on-demand permissions setup (role:" + this.roleDefinition.getName() + ") SCRATCH"));
                }
                this.switchPermissions(requestContext, schema, new OlapRoleSchemaNotCreatedPermissions(schema));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSchemaPartitionsLoaded(OlapEngineRequestContext requestContext, OlapSchema schema, OlapSchemaLoadPartitionsInfo loadPartitionsInfo) {
        Logger logger = requestContext.getLoggers().authorization();
        Object object = this.lock;
        synchronized (object) {
            IOlapSchemaPermission existing = schema.getPermissions(this);
            if (existing != null && !existing.isError() && existing.isCreated()) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("authorization : schema [" + schema.getName() + "] (partitions loaded) on-demand permissions setup (role:" + this.roleDefinition.getName() + ") INCR"));
                }
                this.switchPermissions(requestContext, schema, new OlapRoleSchemaNotCreatedLoadPartitionsPermissions(existing, loadPartitionsInfo));
            } else {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("authorization : schema [" + schema.getName() + "] (partitions loaded) on-demand permissions setup (role:" + this.roleDefinition.getName() + ") SCRATCH"));
                }
                this.switchPermissions(requestContext, schema, new OlapRoleSchemaNotCreatedPermissions(schema));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSchemaPartitionsLoadError(OlapEngineRequestContext requestContext, OlapSchema schema) {
        Logger logger = requestContext.getLoggers().authorization();
        Object object = this.lock;
        synchronized (object) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("authorization : schema [" + schema.getName() + "] (partitions error) on-demand permissions setup (role:" + this.roleDefinition.getName() + ")"));
            }
            schema.setPermissions(this, new OlapRoleSchemaNotCreatedPermissions(schema));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean isSchemaAuthorized(OlapSchema schema) {
        Object object = this.lock;
        synchronized (object) {
            if (schema.getPermissions(this) != null) {
                return true;
            }
            try {
                IOlapRoleSchemasDefinition schemas = this.roleDefinition.getValidatedSchemasPermissions();
                return schemas.isSchemaAuthorized(schema.getName());
            }
            catch (RuntimeException ex) {
                OlapLoggers.AUTHORIZATION.error((Object)("[auth] schema [" + schema.getName() + "] access is disabled for role [" + this.roleDefinition.getName() + "] due to invalid schemas definition."), (Throwable)ex);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IOlapSchemaPermission getSchemaPermissions(OlapEngineRequestContext context, OlapSchema schema, boolean withPerspective) {
        OlapRequestId requestId = context.getRequestId();
        Object object = this.lock;
        synchronized (object) {
            IOlapSchemaPermission permissions = schema.getPermissions(this);
            if (permissions == null) {
                if (!this.isSchemaAuthorized(schema)) {
                    throw new OlapRoleAuthorizationRuntimeException("The schema [" + schema.getName() + "] is not available (permissions inconsistency)");
                }
                permissions = new OlapRoleSchemaNotCreatedPermissions(schema);
            }
            if (!permissions.isCreated()) {
                long startMS = System.currentTimeMillis();
                permissions = !permissions.isIncremental() ? this.onDemandSchemaPermissions(context, requestId, schema) : permissions.increment(this.roleDefinition.getName());
                this.reportPermissionsOnError(requestId.getClientUUID(), permissions);
                this.switchPermissions(context, schema, permissions);
                long elapsedMS = System.currentTimeMillis() - startMS;
                if (!permissions.isIncremental()) {
                    if (OlapLoggers.AUTHORIZATION.isDebugEnabled()) {
                        OlapLoggers.AUTHORIZATION.debug((Object)("[auth] schema [" + String.valueOf(schema) + "] perms. elapsed (full load) : " + CdTimeUtils.formatMillis((long)elapsedMS)));
                    }
                    this.timings.setElapsedMS(schema.getName(), elapsedMS);
                } else {
                    if (OlapLoggers.AUTHORIZATION.isDebugEnabled()) {
                        OlapLoggers.AUTHORIZATION.debug((Object)("[auth] schema [" + String.valueOf(schema) + "] perms. elapsed (incr. load) : " + CdTimeUtils.formatMillis((long)elapsedMS)));
                    }
                    this.timings.addElapsedMS(schema.getName(), elapsedMS);
                }
            }
            return withPerspective ? schema.decorateWithPerspective(permissions) : permissions;
        }
    }

    private void reportPermissionsOnError(String requestUuid, IOlapSchemaPermission permissions) {
        if (permissions.isError()) {
            OlapLoggers.AUTHORIZATION.error((Object)("[auth] schema access is disabled for role [" + this.roleDefinition.getName() + "] due to the following errors."));
            for (OlapContextualError olapContextualError : permissions.getErrors()) {
                OlapLoggers.AUTHORIZATION.error((Object)("[auth] " + olapContextualError.asFullMessage((CdBabylonService)CdLoggingBabylonService.INSTANCE)));
            }
            IcCubeRequestStatusManager statusManager = this.olapEngineApplicationContext.getRequestStatusManager();
            statusManager.onRequestError(requestUuid, new OlapRoleDefinitionError(OlapRoleDefinitionErrorCode.UNEXPECTED_ERROR, new Serializable[]{"authorization : schema access is disabled for role [" + this.roleDefinition.getName() + "] due to permissions definitions errors."}));
            statusManager.onRequestErrors(requestUuid, permissions.getErrors());
        }
    }

    private void switchPermissions(OlapEngineRequestContext context, OlapSchema schema, IOlapSchemaPermission permissions) {
        IOlapSchemaPermission prev = schema.switchPermissions(this, permissions);
        OlapCacheManager cacheManager = this.olapEngineApplicationContext.getCacheManager();
        cacheManager.onSchemaSecurityPermissionsSwitched(context, schema, this.roleDefinition.getName(), permissions, prev);
    }

    private IOlapSchemaPermission onDemandSchemaPermissions(OlapEngineRequestContext context, OlapRequestId requestId, OlapSchema schema) {
        try {
            return this.unsafeOnDemandSchemaPermissions(context, requestId, schema);
        }
        catch (OlapContextualBigException ex) {
            return new OlapRoleSchemaOnErrorPermissions(this.roleDefinition.getName(), schema, ex.getErrors());
        }
        catch (RuntimeException ex) {
            ArrayList<OlapRoleDefinitionError> errors = new ArrayList<OlapRoleDefinitionError>();
            errors.add(new OlapRoleDefinitionError(OlapRoleDefinitionErrorCode.UNEXPECTED_ERROR, new Serializable[]{ex.getMessage()}));
            return new OlapRoleSchemaOnErrorPermissions(this.roleDefinition.getName(), schema, errors);
        }
    }

    private IOlapSchemaPermission unsafeOnDemandSchemaPermissions(OlapEngineRequestContext context, OlapRequestId requestId, OlapSchema schema) throws OlapContextualBigException {
        long startMS = System.currentTimeMillis();
        String roleName = this.roleDefinition.getName();
        if (OlapLoggers.AUTHORIZATION.isInfoEnabled()) {
            OlapLoggers.AUTHORIZATION.info((Object)("[auth] create (from-scratch) permissions for role [" + roleName + "] schema [" + schema.getName() + "]"));
        }
        Object object = this.lock;
        synchronized (object) {
            OlapRoleDefinitionErrorManager errorManager = new OlapRoleDefinitionErrorManager(false);
            try {
                OlapRoleDefinitionApplyValidationContext validationContext = new OlapRoleDefinitionApplyValidationContext(this.olapEngineApplicationContext, context.isSessionLess(), this.administratorPermissions, requestId, errorManager, new OlapEngineInMemorySchemaDefFactoryHelper(schema.getDefinitionFactory()), schema);
                OlapRoleDefinitionValidationHelper.validateDefinition(validationContext, null, this.roleDefinition);
                if (errorManager.hasErrors()) {
                    throw errorManager.asException();
                }
                IOlapRoleSchemasDefinition schemasPermissions = this.roleDefinition.getValidatedSchemasPermissions();
                if (!schemasPermissions.isSchemaAuthorized(schema.getName())) {
                    return new OlapRoleSchemaOnErrorPermissions(this.roleDefinition.getName(), schema, "schema [" + schema.getName() + " is not authorized in role [" + roleName + "]");
                }
                IOlapSchemaPermission schemaPermissions = this.doCreateSchemaPermissions(validationContext, this.roleDefinition, schema);
                if (errorManager.hasErrors()) {
                    throw errorManager.asException();
                }
                if (OlapLoggers.AUTHORIZATION.isInfoEnabled()) {
                    OlapLoggers.AUTHORIZATION.info((Object)("[auth] create (from-scratch) permissions for role [" + roleName + "] schema [" + schema.getName() + "] done successfully"));
                }
                OlapLoggers.CHECKPOINTS.info((Object)"[ic3] created (from-scratch) permissions for role [%s] and schema [%s] in [%s]".formatted(roleName, schema.getName(), CdTimeUtils.formatMillisEx((long)startMS)));
                return schemaPermissions;
            }
            catch (OlapRoleDefinitionErrorException ex) {
                errorManager.addError(ex.getError());
                throw errorManager.asException();
            }
            catch (RuntimeException ex) {
                errorManager.addException(ex);
                throw errorManager.asException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IOlapSchemaPermission doCreateSchemaPermissions(OlapRoleDefinitionApplyValidationContext validationContext, OlapRoleDefinition validRoleDefinition, OlapSchema schema) {
        OlapRoleDefinitionErrorManager errorManager = (OlapRoleDefinitionErrorManager)validationContext.getErrorManager();
        errorManager.pushContext(validRoleDefinition);
        try {
            IOlapSchemaPermission schemaPermissions = validRoleDefinition.isFullControl() ? new OlapRoleSchemaFullControlPermissions(schema) : this.doCreateSchemaPermissionsX(validationContext, validRoleDefinition, schema);
            IOlapSchemaPermission iOlapSchemaPermission = schemaPermissions;
            return iOlapSchemaPermission;
        }
        finally {
            errorManager.popContext();
        }
    }

    protected abstract IOlapSchemaPermission doCreateSchemaPermissionsX(OlapRoleDefinitionApplyValidationContext var1, OlapRoleDefinition var2, OlapSchema var3);

    public String toString() {
        return this.roleDefinition.getName();
    }
}

