/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorizationx.permissions.schemas;

import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.authorizationx.permissions.schemas.OlapRoleSchemasRegularPermissions;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class OlapRoleSchemasPermissionsTimings {
    private final ConcurrentHashMap<String, AtomicLong> schemaElapsedMS = new ConcurrentHashMap();
    private final OlapRoleSchemasRegularPermissions perms;

    public OlapRoleSchemasPermissionsTimings(OlapRoleSchemasRegularPermissions perms) {
        this.perms = perms;
    }

    public long getTotalElapsedMS() {
        long ms = 0L;
        for (AtomicLong value : this.schemaElapsedMS.values()) {
            ms += value.get();
        }
        return ms;
    }

    public String getDetailedTotalElapsedMS() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, AtomicLong> entry : this.schemaElapsedMS.entrySet()) {
            sb.append(entry.getKey()).append(":").append(CdTimeUtils.formatMillis((long)entry.getValue().get())).append("\n");
        }
        return sb.toString();
    }

    public void setElapsedMS(String schema, long elapsedMS) {
        this.schemaElapsedMS.put(schema, new AtomicLong(elapsedMS));
        if (OlapLoggers.AUTHORIZATION.isDebugEnabled()) {
            OlapLoggers.AUTHORIZATION.debug((Object)("[auth] schema [" + schema + "] perms. elapsed (set) : " + CdTimeUtils.formatMillis((long)elapsedMS)));
        }
    }

    public void addElapsedMS(String schema, long elapsedMS) {
        AtomicLong ms = this.schemaElapsedMS.get(schema);
        long totalMS = -1L;
        if (ms != null) {
            totalMS = ms.addAndGet(elapsedMS);
        }
        if (OlapLoggers.AUTHORIZATION.isDebugEnabled()) {
            OlapLoggers.AUTHORIZATION.debug((Object)("[auth] schema [" + schema + "] perms. elapsed (add) : " + CdTimeUtils.formatMillis((long)elapsedMS) + " [ " + (totalMS != -1L ? CdTimeUtils.formatMillis((long)totalMS) : "-") + " ]"));
        }
    }
}

