/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorizationx.permissions.schema;

import crazydev.iccube.authorization.permissions.common.OlapRoleAccess;
import crazydev.iccube.authorizationx.permissions.schema.OlapRoleSchemaPermissions;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.eval.filter.dimension.OlapEmptyMemberFilter;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaIncrLoadInfo;
import crazydev.iccube.olap.schema.OlapSchemaLoadPartitionsInfo;
import crazydev.iccube.olap.schema.OlapSchemaUnloadPartitionsInfo;

public abstract class OlapRoleSchemaRegularPermissions
extends OlapRoleSchemaPermissions {
    protected final String roleName;
    protected final OlapRoleAccess access;
    private final OlapEmptyMemberFilter invisibleDimensionFilter = new OlapEmptyMemberFilter();

    public OlapRoleSchemaRegularPermissions(String roleName, OlapRoleAccess access, OlapSchema schema) {
        super(schema);
        this.roleName = roleName;
        this.access = access;
    }

    @Override
    public boolean isReadOnly() {
        return this.access.isReadOnly();
    }

    @Override
    public boolean isDrillthroughDenied() {
        return false;
    }

    @Override
    public final IOlapSchemaPermission increment(String roleName, OlapSchemaIncrLoadInfo incrLoadInfo) {
        if (!this.schema.equals(incrLoadInfo.getSchema())) {
            throw new RuntimeException("internal error: incremental permissions schema inconsistency");
        }
        if (OlapLoggers.AUTHORIZATION.isInfoEnabled()) {
            OlapLoggers.AUTHORIZATION.info((Object)("[auth] create incremental (incr-load) permissions for role [" + roleName + "] schema [" + this.schema.getName() + "] REGULAR"));
        }
        return this.doIncrement(roleName, incrLoadInfo);
    }

    protected abstract IOlapSchemaPermission doIncrement(String var1, OlapSchemaIncrLoadInfo var2);

    @Override
    public final IOlapSchemaPermission increment(String roleName, OlapSchemaLoadPartitionsInfo loadPartitionsInfo) {
        if (!this.schema.equals(loadPartitionsInfo.getSchema())) {
            throw new RuntimeException("internal error: incremental permissions schema inconsistency");
        }
        if (OlapLoggers.AUTHORIZATION.isInfoEnabled()) {
            OlapLoggers.AUTHORIZATION.info((Object)("[auth] create incremental (load-partitions) permissions for role [" + roleName + "] schema [" + this.schema.getName() + "] REGULAR"));
        }
        return this.doIncrement(roleName, loadPartitionsInfo);
    }

    protected abstract IOlapSchemaPermission doIncrement(String var1, OlapSchemaLoadPartitionsInfo var2);

    @Override
    public final IOlapSchemaPermission increment(String roleName, OlapSchemaUnloadPartitionsInfo unloadPartitionsInfo) {
        if (!this.schema.equals(unloadPartitionsInfo.getSchema())) {
            throw new RuntimeException("internal error: incremental permissions schema inconsistency");
        }
        if (OlapLoggers.AUTHORIZATION.isInfoEnabled()) {
            OlapLoggers.AUTHORIZATION.info((Object)("[auth] create incremental (unload-partitions) permissions for role [" + roleName + "] schema [" + this.schema.getName() + "] REGULAR"));
        }
        return this.doIncrement(roleName, unloadPartitionsInfo);
    }

    protected abstract IOlapSchemaPermission doIncrement(String var1, OlapSchemaUnloadPartitionsInfo var2);

    @Override
    public OlapMemberFilter getInvisibleMemberFilter() {
        return this.invisibleDimensionFilter;
    }
}

