/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorizationx.flat.permissions.schema;

import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorCode;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorManager;
import crazydev.iccube.authorizationx.flat.permissions.schema.OlapRoleFlatSchemaAuthorizedMemberTuples;
import crazydev.iccube.authorizationx.flat.permissions.schema.OlapRoleFlatSchemaDeniedMemberTuples;
import crazydev.iccube.authorizationx.flat.permissions.schema.OlapRoleFlatSchemaMemberTuples;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.tuple.IOlapTuple;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.filter.dimension.OlapAbstractTupleFilter;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class OlapRoleFlatSchemaMemberTupleFilter
extends OlapAbstractTupleFilter {
    private final AtomicReference<OlapRoleFlatSchemaMemberTuples> tuples = new AtomicReference();
    private final AtomicReference<OlapTupleDimensionality> dimensionality = new AtomicReference();

    OlapRoleFlatSchemaMemberTupleFilter() {
    }

    public boolean isEmpty() {
        OlapRoleFlatSchemaMemberTuples thisTuples = this.tuples.get();
        return thisTuples == null;
    }

    public void authorizeTuple(OlapRoleDefinitionErrorManager errorManager, boolean plus, OlapTuple tuple) {
        OlapRoleFlatSchemaMemberTuples thisTuples = this.tuples.get();
        if (thisTuples == null) {
            thisTuples = plus ? new OlapRoleFlatSchemaAuthorizedMemberTuples() : new OlapRoleFlatSchemaDeniedMemberTuples();
            this.tuples.set(thisTuples);
        }
        if (plus != thisTuples.isPlus()) {
            errorManager.addError(OlapRoleDefinitionErrorCode.FLAT_AUTH_INVALID, new Serializable[]{"[-|+]tuples D tuple-set does not support mixing - and + modifiers"});
        } else {
            thisTuples.authorizeTuple(tuple);
        }
    }

    @Override
    public String getName() {
        return "permissions";
    }

    @Override
    public boolean canFastCrossjoinForNonEmptyProcessing() {
        return true;
    }

    @Override
    public boolean isFilteringHierarchy(OlapHierarchy hierarchy) {
        OlapRoleFlatSchemaMemberTuples thisTuples = this.tuples.get();
        if (thisTuples == null) {
            return false;
        }
        OlapTupleDimensionality thisDimensionality = this.dimensionality.get();
        if (thisDimensionality == null) {
            thisDimensionality = OlapRoleFlatSchemaMemberTupleFilter.setupTupleDimensionality(thisTuples.getTuples());
            this.dimensionality.set(thisDimensionality);
        }
        return thisDimensionality.isIn(hierarchy);
    }

    private static OlapTupleDimensionality setupTupleDimensionality(List<OlapTuple> deniedTuples) {
        OlapTupleDimensionality dim = null;
        for (OlapTuple deniedTuple : deniedTuples) {
            dim = deniedTuple.getTupleDimensionality().or(dim);
        }
        return dim;
    }

    @Override
    public boolean isAccepting(OlapMember member) {
        return this.accept(member);
    }

    @Override
    public boolean isAccepting(IOlapTuple tuple) {
        return this.accept(tuple);
    }

    private boolean accept(IOlapTuple tuple) {
        OlapRoleFlatSchemaMemberTuples thisTuples = this.tuples.get();
        if (thisTuples == null) {
            return true;
        }
        return thisTuples.isAccepting(tuple);
    }
}

