/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorizationx.flat.permissions.schema;

import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationRuntimeException;
import crazydev.iccube.authorizationx.flat.permissions.schema.OlapRoleFlatQualifiedMeasureGroupName;
import crazydev.iccube.cluster.node.facts.N_FactBitmapContainer;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationTuplesStatement;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarAbstractEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.dimensionality.IOlapWithTupleDimensionality;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.index.bitmap.OlapBitSet;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class OlapRoleFlatSchemaFactFilterLine {
    private final MdxAuthorizationTuplesStatement statement;
    public final boolean plus;
    public final OlapNonScalarAbstractEntity entity;
    public final boolean measureGroupNamesPlus;
    public final Set<String> qualifiedMeasureGroupNamesU;

    public OlapRoleFlatSchemaFactFilterLine(MdxAuthorizationTuplesStatement statement, OlapNonScalarAbstractEntity entity, boolean measureGroupNamesMinus, List<OlapRoleFlatQualifiedMeasureGroupName> measureGroupNames) {
        this.statement = statement;
        this.plus = statement.isPlus();
        this.entity = entity;
        boolean bl = this.measureGroupNamesPlus = !measureGroupNamesMinus;
        if (measureGroupNames != null) {
            this.qualifiedMeasureGroupNamesU = new HashSet<String>();
            for (OlapRoleFlatQualifiedMeasureGroupName measureGroupName : measureGroupNames) {
                String name = measureGroupName.cube + "." + measureGroupName.measureGroup;
                this.qualifiedMeasureGroupNamesU.add(name.toUpperCase());
            }
        } else {
            this.qualifiedMeasureGroupNamesU = null;
        }
    }

    public boolean isForGroup(String cubeName, String measureGroupName) {
        if (this.qualifiedMeasureGroupNamesU.isEmpty()) {
            return true;
        }
        String name = cubeName + "." + measureGroupName;
        boolean found = this.qualifiedMeasureGroupNamesU.contains(name.toUpperCase());
        if (found) {
            return this.measureGroupNamesPlus;
        }
        return !this.measureGroupNamesPlus;
    }

    public static List<OlapRoleFlatSchemaFactFilterLine> filter(List<OlapRoleFlatSchemaFactFilterLine> lines, String cube, String measureGroup) {
        return lines.stream().filter(line -> line.isForGroup(cube, measureGroup)).collect(Collectors.toList());
    }

    public boolean isIndexingOrEmpty(N_FactBitmapContainer bitmapContainer) {
        Object dim;
        OlapNonScalarAbstractEntity olapNonScalarAbstractEntity = this.entity;
        if (olapNonScalarAbstractEntity instanceof IOlapWithTupleDimensionality) {
            IOlapWithTupleDimensionality entityWD = (IOlapWithTupleDimensionality)((Object)olapNonScalarAbstractEntity);
            dim = entityWD.getTupleDimensionality();
            return OlapRoleFlatSchemaFactFilterLine.isIndexing(bitmapContainer, (OlapTupleDimensionality)dim);
        }
        dim = this.entity;
        if (dim instanceof OlapTupleSet) {
            OlapTupleSet entityTS = (OlapTupleSet)dim;
            if ((dim = entityTS.getTupleDimensionality()) != null) {
                return OlapRoleFlatSchemaFactFilterLine.isIndexing(bitmapContainer, (OlapTupleDimensionality)dim);
            }
            return true;
        }
        OlapLoggers.AUTHORIZATION.error((Object)("permissions : dimensionality error for class : " + String.valueOf(this.entity.getClass())));
        OlapLoggers.AUTHORIZATION.error((Object)("permissions : dimensionality error for statement : " + this.statement.asMdx()));
        throw new OlapRoleAuthorizationRuntimeException("permissions : dimensionality error for class : " + String.valueOf(this.entity.getClass()));
    }

    public String asMdx() {
        return this.statement.asMdx();
    }

    private static boolean isIndexing(N_FactBitmapContainer bitmapContainer, OlapTupleDimensionality dim) {
        OlapBitSet bs = dim.asBitSet();
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            if (bitmapContainer.isIndexingHierarchy(i)) {
                return true;
            }
            i = bs.nextSetBit(i + 1);
        }
        return false;
    }
}

