/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorizationx.flat.permissions.schema;

import crazydev.iccube.authorizationx.flat.permissions.schema.OlapRoleFlatSchemaMemberTuples;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.tuple.IOlapTuple;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import java.util.ArrayList;
import java.util.List;

class OlapRoleFlatSchemaAuthorizedMemberTuples
extends OlapRoleFlatSchemaMemberTuples {
    private final List<OlapTuple> authorizedTuples = new ArrayList<OlapTuple>();

    OlapRoleFlatSchemaAuthorizedMemberTuples() {
    }

    @Override
    boolean isPlus() {
        return true;
    }

    @Override
    void authorizeTuple(OlapTuple tuple) {
        this.authorizedTuples.add(tuple);
    }

    @Override
    List<OlapTuple> getTuples() {
        return this.authorizedTuples;
    }

    @Override
    boolean isAccepting(IOlapTuple tuple) {
        if (tuple.isKO()) {
            return true;
        }
        for (OlapTuple authorizedTuple : this.authorizedTuples) {
            if (!OlapRoleFlatSchemaAuthorizedMemberTuples.isAuthorized(authorizedTuple, tuple)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAuthorized(OlapTuple authorizedTuple, IOlapTuple tuple) {
        int authorizedTupleMC = authorizedTuple.getMemberCount();
        int tupleMC = tuple.getMemberCount();
        if (tupleMC < authorizedTupleMC) {
            return true;
        }
        boolean authorized = true;
        for (int ii = 0; ii < authorizedTupleMC; ++ii) {
            OlapMember authorizedTupleMember = authorizedTuple.getMember(ii);
            OlapMember tupleMember = tuple.getMember(authorizedTupleMember.getHierarchy());
            if (tupleMember == null) {
                return true;
            }
            if (authorizedTupleMember.isAncestorOrSame(tupleMember)) continue;
            authorized = false;
        }
        return authorized;
    }
}

