/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorizationx.flat.permissions.dimension;

import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationRuntimeException;
import crazydev.iccube.authorizationx.flat.permissions.hierarchy.OlapRoleFlatHierarchyRegularPermissions;
import crazydev.iccube.authorizationx.flat.permissions.schema.OlapRoleFlatSchemaMemberFilter;
import crazydev.iccube.authorizationx.permissions.hierarchy.OlapRoleHierarchyAllPermissions;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchyScope;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionPermission;
import crazydev.iccube.olap.entity.permissions.IOlapHierarchyPermission;
import java.util.HashMap;
import java.util.Map;

public class OlapRoleFlatDimensionRegularPermissions
implements IOlapDimensionPermission {
    private OlapDimension dimension;
    private final Map<OlapHierarchy, IOlapHierarchyPermission> authorizedHierarchiesPermissions = new HashMap<OlapHierarchy, IOlapHierarchyPermission>();

    public OlapRoleFlatDimensionRegularPermissions(OlapDimension dimension, OlapRoleFlatSchemaMemberFilter memberFilter) {
        this.dimension = dimension;
        for (OlapHierarchy hierarchy : dimension.getHierarchies()) {
            if (!memberFilter.isAccepting(hierarchy)) continue;
            this.authorizedHierarchiesPermissions.put(hierarchy, new OlapRoleFlatHierarchyRegularPermissions(hierarchy, memberFilter));
        }
    }

    @Override
    public OlapDimension getDimension() {
        return this.dimension;
    }

    @Override
    public boolean isHierarchyInvisible(OlapHierarchy hierarchy) {
        return false;
    }

    @Override
    public boolean isHierarchyAuthorized(OlapHierarchy hierarchy) {
        return this.authorizedHierarchiesPermissions.containsKey(hierarchy);
    }

    @Override
    public IOlapHierarchyPermission getHierarchyPermission(OlapHierarchy hierarchy) {
        IOlapHierarchyPermission perms = this.authorizedHierarchiesPermissions.get(hierarchy);
        if (perms == null) {
            OlapHierarchyScope scope = hierarchy.getScope();
            if (scope == OlapHierarchyScope.REQUEST) {
                return new OlapRoleHierarchyAllPermissions(hierarchy);
            }
            throw new OlapRoleAuthorizationRuntimeException("The hierarchy [" + ONames.name4Log(hierarchy) + "] in dimension [" + ONames.name4Log(this.dimension) + "] is not authorized");
        }
        return perms;
    }
}

