/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorizationx.flat.permissions.cube;

import crazydev.iccube.authorization.permissions.common.OlapRoleAccess;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.OlapMeasureGroup;
import crazydev.iccube.olap.entity.permissions.IOlapCubePermission;
import java.util.HashSet;
import java.util.Set;

public class OlapRoleFlatCubeRegularPermissions
implements IOlapCubePermission {
    private OlapCube cube;
    private OlapRoleAccess access;
    private Set<String> authorizedMeasureGroupNames;

    public OlapRoleFlatCubeRegularPermissions(OlapCube cube, OlapRoleAccess access, Set<OlapMeasureGroup> authorizedMeasureGroups) {
        this.cube = cube;
        this.access = access;
        this.authorizedMeasureGroupNames = new HashSet<String>();
        for (OlapMeasureGroup authorizedMeasureGroup : authorizedMeasureGroups) {
            this.authorizedMeasureGroupNames.add(authorizedMeasureGroup.getName().toLowerCase());
        }
    }

    @Override
    public OlapCube getCube() {
        return this.cube;
    }

    @Override
    public boolean isReadOnly() {
        return this.access.isReadOnly();
    }

    @Override
    public boolean isReadWrite() {
        return this.access.isReadWrite();
    }

    @Override
    public boolean isMeasureGroupAuthorized(String measureGroupName) {
        return this.authorizedMeasureGroupNames.contains(measureGroupName.toLowerCase());
    }
}

