/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorizationx.flat.definition.schemas;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.iccube.authorization.definition.common.IOlapRoleConstraintDefaultValueDefinition;
import crazydev.iccube.authorization.definition.common.IOlapRoleNamedDefinition;
import crazydev.iccube.authorization.definition.role.OlapRoleDefinition;
import crazydev.iccube.authorization.validation.common.OlapRoleDefinitionValidationContext;
import crazydev.iccube.authorizationx.definition.schemas.IOlapRoleSchemasDefinition;
import crazydev.iccube.authorizationx.flat.definition.schemas.OlapRoleFlatSchemasDefinitionValidator;
import crazydev.iccube.authorizationx.flat.definition.schemas.OlapRoleFlatSchemasProfile;
import crazydev.iccube.validation.OlapValidator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="schemasNG")
public class OlapRoleFlatSchemasDefinition
implements IOlapRoleSchemasDefinition<OlapRoleFlatSchemasDefinition>,
IOlapRoleConstraintDefaultValueDefinition,
IOlapRoleNamedDefinition {
    public static final CdProperty DEFINITION = new CdReadWriteProperty(OlapRoleFlatSchemasDefinition.class, "definition");
    @XmlElement(name="definition", required=true)
    private String definition;
    @XmlTransient
    @Nullable
    private OlapRoleFlatSchemasProfile validatedDefinition;

    public OlapRoleFlatSchemasDefinition() {
    }

    public OlapRoleFlatSchemasDefinition(String definition) {
        this.definition = definition;
    }

    @Override
    public IOlapRoleSchemasDefinition<OlapRoleFlatSchemasDefinition> copy() {
        return new OlapRoleFlatSchemasDefinition(this.definition);
    }

    @Override
    public String getName() {
        return "Schemas";
    }

    public String getDefinitionForUX() {
        if (this.definition == null) {
            return "n/a (schemas perms.)";
        }
        return this.definition;
    }

    @Override
    public void setupConstrainedDefaultValues(@Nullable Object owner) {
        OlapRoleDefinition role;
        StringBuilder flatDefinition = new StringBuilder("-- --------------------------------------------------------------------------------------------- \n-- Please refer to the following page for more details: \n--   https://doc.iccube.com/?ic3topic=server.user_guide.security.schema_permissions \n-- --------------------------------------------------------------------------------------------- \n \n");
        if (owner instanceof OlapRoleDefinition && (role = (OlapRoleDefinition)owner).isFullControl()) {
            this.definition = String.valueOf(flatDefinition) + "+schemaAccess W\n";
            return;
        }
        this.definition = String.valueOf(flatDefinition) + "+schemaAccess W\n";
    }

    @Override
    public String getContextVisualId() {
        return "Schemas";
    }

    @Override
    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    @Override
    public OlapValidator<OlapRoleDefinitionValidationContext, OlapRoleDefinition, OlapRoleFlatSchemasDefinition> getValidator() {
        return new OlapRoleFlatSchemasDefinitionValidator();
    }

    public boolean hasValidatedDefinition() {
        return this.validatedDefinition != null;
    }

    public OlapRoleFlatSchemasProfile getValidatedDefinition() {
        if (this.validatedDefinition == null) {
            throw new RuntimeException("internal error: invalid (or missing validated) authorization definition");
        }
        return this.validatedDefinition;
    }

    public void setValidatedDefinition(@Nullable OlapRoleFlatSchemasProfile validatedDefinition) {
        this.validatedDefinition = validatedDefinition;
    }

    @Override
    public boolean isSchemaAuthorized(String schema) {
        if (this.validatedDefinition == null) {
            throw new RuntimeException("internal error: invalid (or missing validated) authorization definition");
        }
        return this.validatedDefinition.isSchemaAuthorized(schema);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlapRoleFlatSchemasDefinition that = (OlapRoleFlatSchemasDefinition)o;
        return !(this.definition != null ? !this.definition.equals(that.definition) : that.definition != null);
    }

    @Override
    public int hashCode() {
        return this.definition != null ? this.definition.hashCode() : 0;
    }
}

