/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.validation.schema;

import crazydev.common.property.CdProperty;
import crazydev.iccube.authorization.definition.role.OlapRoleDefinition;
import crazydev.iccube.authorization.definition.schema.OlapRoleSchemaDefinition;
import crazydev.iccube.authorization.definition.schema.OlapRoleSchemaEntityListDefinition;
import crazydev.iccube.authorization.definition.schema.OlapRoleSchemasDefinition;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorCode;
import crazydev.iccube.authorization.validation.common.OlapRoleAbstractDefinitionValidator;
import crazydev.iccube.authorization.validation.common.OlapRoleDefinitionValidationContext;
import crazydev.iccube.contextual.IOlapContextual;
import crazydev.iccube.olap.component.schemas.OlapEngineSchemaDefFactoryHelper;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import crazydev.iccube.olap.util.OlapCaseInsensitiveNames;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapRoleSchemasDefinitionValidator
extends OlapRoleAbstractDefinitionValidator<OlapRoleDefinition, OlapRoleSchemasDefinition> {
    @Override
    protected void doValidate(OlapRoleDefinitionValidationContext context, OlapRoleDefinition owner, OlapRoleSchemasDefinition me) {
        this.validateSchemas(context, owner, me);
        this.validateNotNullField(context, OlapRoleSchemasDefinition.ACCESS, (Object)me.getDefaultAccess());
    }

    private void validateSchemas(OlapRoleDefinitionValidationContext context, OlapRoleDefinition owner, OlapRoleSchemasDefinition me) {
        CdProperty SCHEMA_NAMES = OlapRoleSchemasDefinition.AUTHORIZED_SCHEMA_NAMES;
        OlapRoleSchemaEntityListDefinition authorizedSchemaNames = me.getAuthorizedSchemaNames();
        this.validateNotNullField(context, SCHEMA_NAMES, authorizedSchemaNames);
        if (authorizedSchemaNames.getType() == null) {
            context.addError(SCHEMA_NAMES, OlapRoleDefinitionErrorCode.AUTHORIZED_SCHEMA_NAMES_TYPE_IS_NULL, new Serializable[0]);
        }
        if (context.isValidateForOnTheFlyRoleSetup()) {
            return;
        }
        if (!context.isApplyingPermissionsToLoadedSchema()) {
            this.validateAuthorizedSchemaNames(context, SCHEMA_NAMES, authorizedSchemaNames);
            this.validateDefinedSchemaPermissionsNames(context, me, authorizedSchemaNames);
            List<OlapRoleSchemaDefinition> schemaPermissions = me.getSchemaPermissions();
            if (schemaPermissions != null) {
                this.validateUniqueOlapNames(context, me, schemaPermissions);
                this.validateChildren(context, me, schemaPermissions);
            }
        } else {
            OlapCaseInsensitiveNames resolvedAuthorizedSchemaNames;
            OlapRoleSchemaDefinition schemaPermission;
            OlapSchema loadedSchema = context.getLoadedSchema();
            if (loadedSchema != null && (schemaPermission = this.resolveAuthorizedDefinedSchemaPermission(context, me, resolvedAuthorizedSchemaNames = this.resolveAuthorizedSchemaNames(context, me), loadedSchema)) != null) {
                this.validateChild(context, me, schemaPermission);
            }
        }
    }

    private void validateAuthorizedSchemaNames(OlapRoleDefinitionValidationContext context, CdProperty SCHEMA_NAMES, OlapRoleSchemaEntityListDefinition authorizedSchemaNames) {
        switch (authorizedSchemaNames.getType()) {
            case SELECTION: 
            case ALL_MINUS_SELECTION: {
                List<String> selection = authorizedSchemaNames.getNames();
                if (selection == null) break;
                OlapEngineSchemaDefFactoryHelper helper = context.getSchemaDefFactoryHelper();
                List<String> nonExistings = helper.getNonExistingSchemaFactories(selection);
                for (String nonExisting : nonExistings) {
                    context.addError(SCHEMA_NAMES, OlapRoleDefinitionErrorCode.AUTHORIZED_SCHEMA_NAME_UNKNOWN, new Serializable[]{nonExisting});
                }
                break;
            }
        }
    }

    private void validateDefinedSchemaPermissionsNames(OlapRoleDefinitionValidationContext context, OlapRoleSchemasDefinition me, OlapRoleSchemaEntityListDefinition authorizedSchemaNames) {
        List<OlapRoleSchemaDefinition> schemaPermissions = me.getSchemaPermissions();
        if (schemaPermissions != null) {
            HashMap<String, OlapRoleSchemaDefinition> permissions = new HashMap<String, OlapRoleSchemaDefinition>();
            ArrayList<String> schemas = new ArrayList<String>();
            for (OlapRoleSchemaDefinition schemaPermission : schemaPermissions) {
                String schema = schemaPermission.getName();
                if (schema == null) continue;
                permissions.put(schema, schemaPermission);
                schemas.add(schema);
            }
            OlapEngineSchemaDefFactoryHelper helper = context.getSchemaDefFactoryHelper();
            List<String> nonExistings = helper.getNonExistingSchemaFactories(schemas);
            for (String nonExisting : nonExistings) {
                OlapRoleSchemaDefinition schemaPermission = (OlapRoleSchemaDefinition)permissions.get(nonExisting);
                context.addErrorWithContextual((IOlapContextual)schemaPermission, OlapRoleDefinitionErrorCode.SCHEMA_PERMISSION_NAME_UNKNOWN, new Serializable[]{nonExisting});
            }
            for (OlapRoleSchemaDefinition schemaPermission : schemaPermissions) {
                String schemaPermissionName = schemaPermission.getName();
                if (schemaPermissionName == null || me.isSchemaAuthorized(schemaPermissionName)) continue;
                context.addErrorWithContextual((IOlapContextual)schemaPermission, OlapRoleDefinitionErrorCode.SCHEMA_PERMISSION_NOT_AUTHORIZED, new Serializable[]{schemaPermissionName});
            }
        }
    }

    private OlapCaseInsensitiveNames resolveAuthorizedSchemaNames(OlapRoleDefinitionValidationContext context, OlapRoleSchemasDefinition me) {
        OlapRoleSchemaEntityListDefinition definedAuthorizedNames = me.getAuthorizedSchemaNames();
        OlapEngineSchemaDefFactoryHelper helper = context.getSchemaDefFactoryHelper();
        OlapCaseInsensitiveNames existingSchemaNames = helper.getAllSchemaNames(512);
        return definedAuthorizedNames.resolveAuthorizedNames(existingSchemaNames);
    }

    @Nullable
    private OlapRoleSchemaDefinition resolveAuthorizedDefinedSchemaPermission(OlapRoleDefinitionValidationContext context, OlapRoleSchemasDefinition me, OlapCaseInsensitiveNames resolvedAuthorizedSchemaNames, OlapSchema loadedSchema) {
        if (resolvedAuthorizedSchemaNames.contains(loadedSchema.getName())) {
            OlapRoleSchemaDefinition resolveAuthorizedDefinedSchemaPermission = null;
            List<OlapRoleSchemaDefinition> definedSchemaPermissions = me.getSchemaPermissions();
            if (definedSchemaPermissions != null) {
                for (OlapRoleSchemaDefinition definedSchemaPermission : definedSchemaPermissions) {
                    if (definedSchemaPermission.getName() == null || !OlapCaseInsensitiveName.equals(definedSchemaPermission.getName(), loadedSchema.getName())) continue;
                    if (resolveAuthorizedDefinedSchemaPermission != null) {
                        context.addError(OlapRoleDefinitionErrorCode.SCHEMA_PERMISSION_DUPLICATED_NAME, new Serializable[]{resolveAuthorizedDefinedSchemaPermission.getName()});
                        return null;
                    }
                    resolveAuthorizedDefinedSchemaPermission = definedSchemaPermission;
                }
                return resolveAuthorizedDefinedSchemaPermission;
            }
        }
        return null;
    }
}

