/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.validation.dimension;

import crazydev.common.property.CdProperty;
import crazydev.iccube.authorization.definition.dimension.OlapRoleDimensionDefinition;
import crazydev.iccube.authorization.definition.hierarchy.OlapRoleHierarchyDefinition;
import crazydev.iccube.authorization.definition.hierarchy.OlapRoleHierarchyEntityListDefinition;
import crazydev.iccube.authorization.definition.schema.OlapRoleSchemaDefinition;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorCode;
import crazydev.iccube.authorization.validation.common.OlapRoleAbstractDefinitionValidator;
import crazydev.iccube.authorization.validation.common.OlapRoleDefinitionValidationContext;
import crazydev.iccube.contextual.IOlapContextual;
import crazydev.iccube.olap.component.schemas.OlapEngineSchemaDefFactoryHelper;
import crazydev.iccube.olap.util.OlapCaseInsensitiveNames;
import java.io.Serializable;
import java.util.List;

public class OlapRoleDimensionDefinitionValidator
extends OlapRoleAbstractDefinitionValidator<OlapRoleSchemaDefinition, OlapRoleDimensionDefinition> {
    @Override
    protected void doValidate(OlapRoleDefinitionValidationContext context, OlapRoleSchemaDefinition owner, OlapRoleDimensionDefinition me) {
        this.validateNotBlankField(context, OlapRoleDimensionDefinition.NAME, me.getName());
        this.validateHierarchies(context, owner, me);
    }

    private void validateHierarchies(OlapRoleDefinitionValidationContext context, OlapRoleSchemaDefinition owner, OlapRoleDimensionDefinition me) {
        OlapCaseInsensitiveNames resolvedAuthorizedHierarchyNames;
        OlapEngineSchemaDefFactoryHelper helper;
        CdProperty HIERARCHY_NAMES = OlapRoleDimensionDefinition.AUTHORIZED_HIERARCHY_NAMES;
        OlapRoleHierarchyEntityListDefinition authorizedHierarchyNames = me.getAuthorizedHierarchyNames();
        this.validateNotNullField(context, HIERARCHY_NAMES, authorizedHierarchyNames);
        if (authorizedHierarchyNames.getType() == null) {
            context.addError(HIERARCHY_NAMES, OlapRoleDefinitionErrorCode.AUTHORIZED_HIERARCHY_NAMES_TYPE_IS_NULL, new Serializable[0]);
        }
        switch (authorizedHierarchyNames.getType()) {
            case SELECTION: 
            case ALL_MINUS_SELECTION: {
                List<String> selection = authorizedHierarchyNames.getNames();
                if (selection == null) break;
                helper = context.getSchemaDefFactoryHelper();
                OlapCaseInsensitiveNames allNames = helper.getAllHierarchyNames(owner.getName(), me.getName());
                for (String name : selection) {
                    if (allNames.contains(name)) continue;
                    context.addError(HIERARCHY_NAMES, OlapRoleDefinitionErrorCode.AUTHORIZED_HIERARCHY_NAME_UNKNOWN, new Serializable[]{name});
                }
                break;
            }
        }
        List<OlapRoleHierarchyDefinition> hierarchyPermissions = me.getHierarchyPermissions();
        if (hierarchyPermissions != null) {
            helper = context.getSchemaDefFactoryHelper();
            OlapCaseInsensitiveNames allHierarchyNames = helper.getAllHierarchyNames(owner.getName(), me.getName());
            resolvedAuthorizedHierarchyNames = authorizedHierarchyNames.resolveAuthorizedNames(helper.getAllHierarchyNames(owner.getName(), me.getName()));
            for (OlapRoleHierarchyDefinition hierarchyPermission : hierarchyPermissions) {
                String hierarchyPermissionName = hierarchyPermission.getName();
                if (hierarchyPermissionName == null) continue;
                if (!allHierarchyNames.contains(hierarchyPermissionName)) {
                    context.addErrorWithContextual((IOlapContextual)hierarchyPermission, OlapRoleDefinitionErrorCode.HIERARCHY_PERMISSION_NAME_UNKNOWN, new Serializable[]{hierarchyPermissionName});
                    continue;
                }
                if (resolvedAuthorizedHierarchyNames.contains(hierarchyPermissionName)) continue;
                context.addErrorWithContextual((IOlapContextual)hierarchyPermission, OlapRoleDefinitionErrorCode.HIERARCHY_PERMISSION_NOT_AUTHORIZED, new Serializable[]{hierarchyPermissionName});
            }
            this.validateUniqueOlapNames(context, me, hierarchyPermissions);
            this.validateChildren(context, me, hierarchyPermissions);
        }
        helper = context.getSchemaDefFactoryHelper();
        OlapCaseInsensitiveNames availableHierarchyNames = helper.getAllHierarchyNames(owner.getName(), me.getName());
        resolvedAuthorizedHierarchyNames = authorizedHierarchyNames.resolveAuthorizedNames(helper.getAllHierarchyNames(owner.getName(), me.getName()));
        if (!availableHierarchyNames.isEmpty() && resolvedAuthorizedHierarchyNames.isEmpty()) {
            context.addError(OlapRoleDefinitionErrorCode.EMPTY_RESOLVED_AUTHORIZED_HIERARCHIES, new Serializable[]{owner.getName(), me.getName()});
        }
    }
}

