/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.validation.common;

import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorException;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorManager;
import crazydev.iccube.authorization.validation.common.IOlapRoleDefinitionValidationEnabled;
import crazydev.iccube.authorization.validation.common.OlapRoleDefinitionValidationContext;
import crazydev.iccube.contextual.OlapContextualBigException;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.validation.OlapValidator;
import org.jetbrains.annotations.Nullable;

public abstract class OlapRoleDefinitionValidationHelper {
    public static void validateDefinition(OlapRoleDefinitionValidationContext validationContext, @Nullable IOlapRoleDefinitionValidationEnabled owner, IOlapRoleDefinitionValidationEnabled definition) throws OlapContextualBigException {
        OlapRoleDefinitionErrorManager errorManager = (OlapRoleDefinitionErrorManager)validationContext.getErrorManager();
        try {
            OlapValidator<OlapRoleDefinitionValidationContext, IOlapRoleDefinitionValidationEnabled, IOlapRoleDefinitionValidationEnabled> validator = definition.getValidator();
            validator.validate(validationContext, owner, definition);
            if (errorManager.hasErrors()) {
                throw errorManager.asException();
            }
        }
        catch (OlapRoleDefinitionErrorException ex) {
            OlapLoggers.AUTHORIZATION.error((Object)"[auth] role validation error-exception", (Throwable)((Object)ex));
            errorManager.addError(ex.getError());
            throw errorManager.asException();
        }
        catch (RuntimeException ex) {
            errorManager.addException(ex);
            throw errorManager.asException();
        }
    }
}

