/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.validation.common;

import crazydev.common.mdx.scanner.exception.CdMdxScannerException;
import crazydev.common.property.CdProperty;
import crazydev.iccube.authorization.definition.common.IOlapRoleNamedDefinition;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorCode;
import crazydev.iccube.authorization.validation.common.IOlapRoleDefinitionValidationEnabled;
import crazydev.iccube.authorization.validation.common.OlapRoleDefinitionValidationContext;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.mdx.parser.MdxParser;
import crazydev.iccube.mdx.parser.MdxParsingContext;
import crazydev.iccube.mdx.parser.ast.expression.MdxExpression;
import crazydev.iccube.mdx.parser.exception.MdxParserException;
import crazydev.iccube.olap.entity.properties.member.OlapIntrinsicMemberPropertyManager;
import crazydev.iccube.olap.eval.function.OlapFunctionRepository;
import crazydev.iccube.olap.schema.OlapSchemaFunctionRepository;
import crazydev.iccube.olap.util.OlapCaseInsensitiveNames;
import crazydev.iccube.validation.OlapValidator;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public abstract class OlapRoleAbstractDefinitionValidator<PARENT extends IOlapRoleDefinitionValidationEnabled, CHILD extends IOlapRoleDefinitionValidationEnabled>
extends OlapValidator<OlapRoleDefinitionValidationContext, PARENT, CHILD> {
    @Override
    protected abstract void doValidate(OlapRoleDefinitionValidationContext var1, PARENT var2, CHILD var3);

    protected void validateUniqueOlapNames(OlapRoleDefinitionValidationContext context, @Nullable IOlapRoleDefinitionValidationEnabled parent, @Nullable List<? extends IOlapRoleNamedDefinition> children) {
        if (children != null) {
            OlapCaseInsensitiveNames existingChildNames = new OlapCaseInsensitiveNames();
            for (IOlapRoleNamedDefinition iOlapRoleNamedDefinition : children) {
                String childName = iOlapRoleNamedDefinition.getName();
                if (childName == null) continue;
                if (existingChildNames.contains(childName)) {
                    context.addError(OlapRoleDefinitionErrorCode.ROLE_DUPLICATED_NAME, new Serializable[]{childName});
                    continue;
                }
                existingChildNames.add(childName);
            }
        }
    }

    protected void validateUniqueNames(OlapRoleDefinitionValidationContext context, @Nullable IOlapRoleDefinitionValidationEnabled parent, @Nullable List<? extends IOlapRoleNamedDefinition> children) {
        if (children != null) {
            HashSet<String> existingChildNames = new HashSet<String>();
            for (IOlapRoleNamedDefinition iOlapRoleNamedDefinition : children) {
                String childName = iOlapRoleNamedDefinition.getName();
                if (childName == null) continue;
                if (existingChildNames.contains(childName)) {
                    context.addError(OlapRoleDefinitionErrorCode.ROLE_DUPLICATED_NAME, new Serializable[]{childName});
                    continue;
                }
                existingChildNames.add(childName);
            }
        }
    }

    public void validateNotNullField(OlapRoleDefinitionValidationContext context, CdProperty property, @Nullable Object value) {
        if (value == null) {
            context.addError(property, OlapRoleDefinitionErrorCode.FIELD_IS_NULL, new Serializable[]{property.getName()});
        }
    }

    public void validateNotBlankField(OlapRoleDefinitionValidationContext context, CdProperty property, @Nullable String value) {
        if (value == null) {
            context.addError(property, OlapRoleDefinitionErrorCode.FIELD_IS_NULL, new Serializable[]{property.getName()});
        } else if (StringUtils.isBlank((CharSequence)value)) {
            context.addError(property, OlapRoleDefinitionErrorCode.FIELD_IS_EMPTY, new Serializable[]{property.getName()});
        }
    }

    protected void validateChildren(OlapRoleDefinitionValidationContext context, IOlapRoleDefinitionValidationEnabled parent, @Nullable List<? extends IOlapRoleDefinitionValidationEnabled> children) {
        if (children != null) {
            for (IOlapRoleDefinitionValidationEnabled iOlapRoleDefinitionValidationEnabled : children) {
                OlapRoleAbstractDefinitionValidator validator = (OlapRoleAbstractDefinitionValidator)iOlapRoleDefinitionValidationEnabled.getValidator();
                validator.validate(context, parent, iOlapRoleDefinitionValidationEnabled);
            }
        }
    }

    protected void validateChild(OlapRoleDefinitionValidationContext context, IOlapRoleDefinitionValidationEnabled parent, @Nullable IOlapRoleDefinitionValidationEnabled child) {
        if (child != null) {
            OlapRoleAbstractDefinitionValidator validator = (OlapRoleAbstractDefinitionValidator)child.getValidator();
            validator.validate(context, parent, child);
        }
    }

    @Nullable
    protected MdxExpression parseValueExpression(OlapRoleDefinitionValidationContext validationContext, String mdx, String mdxHash) throws CdMdxScannerException, MdxParserException {
        OlapProperties properties = validationContext.getEngineProperties();
        OlapFunctionRepository functionRepository = validationContext.getEngineFunctionRepository();
        OlapSchemaFunctionRepository schemaFunctionRepository = new OlapSchemaFunctionRepository(functionRepository);
        OlapIntrinsicMemberPropertyManager memberPropertyManager = new OlapIntrinsicMemberPropertyManager(true);
        MdxParsingContext context = new MdxParsingContext(properties, functionRepository, schemaFunctionRepository.createSnapshot(), memberPropertyManager, true);
        MdxExpression expr = MdxParser.parseValueExpression(context, mdx, mdxHash);
        return expr;
    }
}

