/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.permissions.service;

import crazydev.iccube.authorization.definition.role.OlapRoleDefinition;
import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.authorization.permissions.role.OlapRolePermissions;
import crazydev.iccube.authorization.permissions.service.OlapDefaultRolePermissionsService;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.authentication.OlapAuthenticationServiceException;
import crazydev.iccube.pub.authorization.OlapMissingRoleException;
import crazydev.iccube.pub.common.IOlapServiceConfiguration;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.pub.role.IOlapOnTheFlyRoleDefinitionBuilder;
import crazydev.iccube.pub.role.IOlapOnTheFlyRoleDescription;
import crazydev.iccube.request.log.OlapRequestId;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class OlapOnTheFlyRolePermissionsService
extends OlapDefaultRolePermissionsService {
    private static final String ON_THE_FLY_PERMS_EVICTION = "onTheFlyPerms.eviction";
    private static final String ON_THE_FLY_PERMS_EVICTION_HOUSEKEEPING_PERIOD = "onTheFlyPerms.evictionHousekeepingPeriod";
    private static final String ON_THE_FLY_PERMS_EVICTION_IDLE_PERIOD = "onTheFlyPerms.evictionIdlePeriod";
    private final ScheduledExecutorService houseKeeping = Executors.newScheduledThreadPool(1);

    @Override
    public void configureEx(IOlapServiceConfiguration configuration) throws OlapAuthenticationServiceException {
        super.configureEx(configuration);
        OlapLoggers.AUTHENTICATION.info((Object)"[auth] configure On-The-Fly Permissions Service");
        try {
            boolean onTheFlyPermsEviction = configuration.getConfigurationBooleanProperty(ON_THE_FLY_PERMS_EVICTION, false);
            int onTheFlyPermsHousekeepingPeriod = configuration.getConfigurationIntProperty(ON_THE_FLY_PERMS_EVICTION_HOUSEKEEPING_PERIOD, 10);
            int onTheFlyPermsEvictionIdlePeriod = configuration.getConfigurationIntProperty(ON_THE_FLY_PERMS_EVICTION_IDLE_PERIOD, 30);
            OlapLoggers.AUTHENTICATION.info((Object)("[auth]                        onTheFlyPerms.eviction : " + onTheFlyPermsEviction));
            OlapLoggers.AUTHENTICATION.info((Object)("[auth] onTheFlyPerms.onTheFlyPermsHousekeepingPeriod : " + onTheFlyPermsHousekeepingPeriod));
            OlapLoggers.AUTHENTICATION.info((Object)("[auth] onTheFlyPerms.onTheFlyPermsEvictionIdlePeriod : " + onTheFlyPermsEvictionIdlePeriod));
            if (onTheFlyPermsEviction) {
                this.houseKeeping.scheduleAtFixedRate(() -> this.cleanupOnTheFlyIdlePermissions(onTheFlyPermsEvictionIdlePeriod), 0L, onTheFlyPermsHousekeepingPeriod, TimeUnit.MINUTES);
            }
        }
        catch (OlapConfigurationException | RuntimeException ex) {
            throw new OlapAuthenticationServiceException(true, ((Throwable)ex).getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void checkUserRole(OlapPrincipal user) throws OlapMissingRoleException {
        if (!user.isOnTheFly()) {
            super.checkUserRole(user);
            return;
        }
        OlapRolePermissions permissions = this.getExistingRolePermissions(user.getName(), user.getTemplateRoleName());
        if (permissions.isOnTheFly()) {
            permissions.resetOnTheFlyLastUsed();
        }
    }

    @Override
    public OlapRolePermissions authorizeUser(OlapRequestId requestId, OlapPrincipal user) throws OlapMissingRoleException {
        if (!user.isOnTheFly()) {
            OlapRolePermissions perms = super.authorizeUser(requestId, user);
            return perms;
        }
        IOlapOnTheFlyRoleDescription<?> onTheFlyRoleDescription = user.getOnTheFlyRoleDescription();
        if (onTheFlyRoleDescription == null) {
            throw new RuntimeException("internal error : missing on-the-fly description");
        }
        OlapRolePermissions permissions = this.getOrCreateOnTheFlyRolePermissions(requestId, user, onTheFlyRoleDescription);
        permissions.resetOnTheFlyLastUsed();
        return permissions;
    }

    private OlapRolePermissions getOrCreateOnTheFlyRolePermissions(OlapRequestId requestId, OlapPrincipal user, IOlapOnTheFlyRoleDescription<?> onTheFlyRoleDescription) throws OlapMissingRoleException {
        OlapRolePermissions[] myPermissions = new OlapRolePermissions[1];
        this.processAllRolePermissions(allRolePermissions -> {
            String onTheFlyRoleName = user.getRoleName();
            OlapRolePermissions permissions = (OlapRolePermissions)allRolePermissions.get(onTheFlyRoleName);
            if (permissions == null) {
                permissions = this.createOnTheFlyRolePermissions(requestId, user, onTheFlyRoleDescription);
                if (allRolePermissions.get(onTheFlyRoleName) == null) {
                    throw new RuntimeException("internal error : inconsistent on-the-fly permissions [" + onTheFlyRoleName + "] setup");
                }
            }
            myPermissions[0] = permissions;
        });
        return myPermissions[0];
    }

    private OlapRolePermissions createOnTheFlyRolePermissions(OlapRequestId requestId, OlapPrincipal user, IOlapOnTheFlyRoleDescription<?> onTheFlyRoleDescription) throws OlapMissingRoleException {
        String onTheFlyRoleName;
        if (OlapLoggers.AUTHORIZATION.isInfoEnabled()) {
            OlapLoggers.AUTHORIZATION.info((Object)("[auth] creating on-the-fly-role permissions for user [" + user.getName() + "] [" + onTheFlyRoleDescription.getRoleName() + "]"));
        }
        OlapRolePermissions existingRolePermissions = this.getExistingRolePermissions(user.getName(), onTheFlyRoleDescription.getTemplateRoleName());
        OlapRoleDefinition existingRoleDefinition = existingRolePermissions.getDefinition();
        IOlapOnTheFlyRoleDefinitionBuilder<?> builder = onTheFlyRoleDescription.createBuilder();
        OlapRoleDefinition onTheFlyRoleDefinition = builder.createRoleDefinition(onTheFlyRoleDescription, user, existingRoleDefinition);
        String userRoleName = user.getRoleName();
        if (!userRoleName.equals(onTheFlyRoleName = onTheFlyRoleDefinition.getName())) {
            throw new RuntimeException("internal error : inconsistent on-the-fly permissions [" + userRoleName + " / " + onTheFlyRoleName + "] setup");
        }
        OlapRolePermissions permissions = this.createOnTheFlyPermissions(requestId, onTheFlyRoleDefinition);
        if (permissions == null) {
            throw new OlapMissingRoleException(user.getName(), onTheFlyRoleName);
        }
        permissions.setAsOnTheFly(existingRolePermissions);
        return permissions;
    }

    @Override
    public OlapRoleApplicationPermissions authorizeUserForApplications(OlapPrincipal user) throws OlapMissingRoleException {
        if (!user.isOnTheFly()) {
            OlapRoleApplicationPermissions perms = super.authorizeUserForApplications(user);
            return perms;
        }
        OlapRolePermissions permissions = this.getExistingRolePermissions(user.getName(), user.getTemplateRoleName());
        permissions.resetOnTheFlyLastUsed();
        return permissions.getApplicationPermissions();
    }

    @Override
    public void shutdownNow() {
        super.shutdownNow();
        this.houseKeeping.shutdownNow();
    }
}

