/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.permissions.schema;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.authorization.permissions.common.OlapRoleAccess;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationRuntimeException;
import crazydev.iccube.authorization.permissions.filter.dimension.OlapRoleHierarchyFilter;
import crazydev.iccube.authorization.permissions.filter.dimension.OlapRoleSchemaMemberFilter;
import crazydev.iccube.authorization.permissions.filter.fact.OlapRoleFactFilter;
import crazydev.iccube.authorization.permissions.filter.fact.OlapRoleSchemaFactFilter;
import crazydev.iccube.authorization.permissions.hierarchy.OlapRoleHierarchicalHierarchyRegularPermissions;
import crazydev.iccube.authorization.permissions.measuregroup.OlapRoleHierarchicalMeasureGroupRegularPermissions;
import crazydev.iccube.authorizationx.permissions.cube.OlapRoleCubePermissions;
import crazydev.iccube.authorizationx.permissions.dimension.OlapRoleDimensionPermissions;
import crazydev.iccube.authorizationx.permissions.hierarchy.OlapRoleHierarchyPermissions;
import crazydev.iccube.authorizationx.permissions.measuregroup.OlapRoleMeasureGroupPermissions;
import crazydev.iccube.authorizationx.permissions.schema.OlapRoleSchemaRegularPermissions;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.cube.OlapPerspectiveCube;
import crazydev.iccube.olap.entity.IOlapHierarchyFilter;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.permissions.IOlapCubePermission;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionPermission;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaIncrLoadInfo;
import crazydev.iccube.olap.schema.OlapSchemaLoadPartitionsInfo;
import crazydev.iccube.olap.schema.OlapSchemaUnloadPartitionsInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class OlapRoleHierarchicalSchemaRegularPermissions
extends OlapRoleSchemaRegularPermissions {
    private final boolean authorizedReportingDatasources;
    private final Map<OlapDimension, OlapRoleDimensionPermissions> authorizedDimensions;
    private final Map<OlapCube, OlapRoleCubePermissions> authorizedCubes;
    private final Set<OlapPerspectiveCube> authorizedPerspectives;
    private final Object memberFilterLOCK = new Object();
    private final Object factFilterLOCK = new Object();
    @Nullable
    private OlapRoleSchemaMemberFilter memberFilter;
    @Nullable
    private OlapRoleSchemaFactFilter factFilter;

    public OlapRoleHierarchicalSchemaRegularPermissions(String roleName, OlapRoleAccess access, boolean authorizedReportingDatasources, List<OlapRoleDimensionPermissions> authorizedDimensions, List<OlapRoleCubePermissions> authorizedCubes, List<OlapPerspectiveCube> authorizedPerspectives, OlapSchema schema) {
        super(roleName, access, schema);
        this.authorizedReportingDatasources = authorizedReportingDatasources;
        this.authorizedDimensions = new HashMap<OlapDimension, OlapRoleDimensionPermissions>();
        this.authorizedCubes = new HashMap<OlapCube, OlapRoleCubePermissions>();
        this.authorizedPerspectives = new HashSet<OlapPerspectiveCube>();
        for (OlapRoleDimensionPermissions authorizedDimension : authorizedDimensions) {
            this.authorizedDimensions.put(authorizedDimension.getDimension(), authorizedDimension);
        }
        for (OlapRoleCubePermissions authorizedCube : authorizedCubes) {
            OlapRoleDimensionPermissions measures = authorizedCube.getMeasuresPermissions();
            this.authorizedDimensions.put(measures.getDimension(), measures);
            this.authorizedCubes.put(authorizedCube.getCube(), authorizedCube);
        }
        this.authorizedPerspectives.addAll(authorizedPerspectives);
        this.memberFilter = null;
        this.factFilter = null;
    }

    private OlapRoleHierarchicalSchemaRegularPermissions(String roleName, OlapRoleAccess access, boolean authorizedReportingDatasources, Map<OlapDimension, OlapRoleDimensionPermissions> authorizedDimensions, Map<OlapCube, OlapRoleCubePermissions> authorizedCubes, Set<OlapPerspectiveCube> authorizedPerspectives, @Nullable OlapRoleSchemaMemberFilter dimensionFilter, @Nullable OlapRoleSchemaFactFilter factFilter, OlapSchema schema, OlapSchemaIncrLoadInfo incrLoadInfo) {
        super(roleName, access, schema);
        if (incrLoadInfo.hasNewMembers()) {
            throw new RuntimeException("internal error: incr. load permissions inconsistent usage (members update)");
        }
        this.authorizedReportingDatasources = authorizedReportingDatasources;
        this.authorizedDimensions = authorizedDimensions;
        this.authorizedCubes = authorizedCubes;
        this.authorizedPerspectives = authorizedPerspectives;
        this.memberFilter = dimensionFilter != null ? dimensionFilter.copyForIncrementalLoad(incrLoadInfo) : null;
        this.factFilter = factFilter != null ? factFilter.copyForIncrementalLoad(incrLoadInfo) : null;
    }

    private OlapRoleHierarchicalSchemaRegularPermissions(String roleName, OlapRoleAccess access, boolean authorizedReportingDatasources, Map<OlapDimension, OlapRoleDimensionPermissions> authorizedDimensions, Map<OlapCube, OlapRoleCubePermissions> authorizedCubes, Set<OlapPerspectiveCube> authorizedPerspectives, @Nullable OlapRoleSchemaMemberFilter dimensionFilter, @Nullable OlapRoleSchemaFactFilter factFilter, OlapSchema schema, OlapSchemaLoadPartitionsInfo loadPartitionsInfo) {
        super(roleName, access, schema);
        this.authorizedReportingDatasources = authorizedReportingDatasources;
        this.authorizedDimensions = authorizedDimensions;
        this.authorizedCubes = authorizedCubes;
        this.authorizedPerspectives = authorizedPerspectives;
        this.memberFilter = dimensionFilter != null ? dimensionFilter.copyForLoadPartitions(loadPartitionsInfo) : null;
        this.factFilter = factFilter != null ? factFilter.copyForLoadPartitions(loadPartitionsInfo) : null;
    }

    private OlapRoleHierarchicalSchemaRegularPermissions(String roleName, OlapRoleAccess access, boolean authorizedReportingDatasources, Map<OlapDimension, OlapRoleDimensionPermissions> authorizedDimensions, Map<OlapCube, OlapRoleCubePermissions> authorizedCubes, Set<OlapPerspectiveCube> authorizedPerspectives, @Nullable OlapRoleSchemaMemberFilter dimensionFilter, @Nullable OlapRoleSchemaFactFilter factFilter, OlapSchema schema, OlapSchemaUnloadPartitionsInfo unloadPartitionsInfo) {
        super(roleName, access, schema);
        this.authorizedReportingDatasources = authorizedReportingDatasources;
        this.authorizedDimensions = authorizedDimensions;
        this.authorizedCubes = authorizedCubes;
        this.authorizedPerspectives = authorizedPerspectives;
        this.memberFilter = dimensionFilter != null ? dimensionFilter.copyForUnloadPartitions(unloadPartitionsInfo) : null;
        this.factFilter = factFilter != null ? factFilter.copyForUnloadPartitions(unloadPartitionsInfo) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IOlapSchemaPermission doIncrement(String roleName, OlapSchemaIncrLoadInfo incrLoadInfo) {
        OlapRoleSchemaFactFilter existingFactFilter;
        OlapRoleSchemaMemberFilter existingDimensionFilter;
        Object object = this.memberFilterLOCK;
        synchronized (object) {
            existingDimensionFilter = this.memberFilter;
        }
        Object object2 = this.factFilterLOCK;
        synchronized (object2) {
            existingFactFilter = this.factFilter;
        }
        return new OlapRoleHierarchicalSchemaRegularPermissions(roleName, this.access, this.authorizedReportingDatasources, this.authorizedDimensions, this.authorizedCubes, this.authorizedPerspectives, existingDimensionFilter, existingFactFilter, this.schema, incrLoadInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IOlapSchemaPermission doIncrement(String roleName, OlapSchemaLoadPartitionsInfo loadPartitionsInfo) {
        OlapRoleSchemaFactFilter existingFactFilter;
        OlapRoleSchemaMemberFilter existingDimensionFilter;
        Object object = this.memberFilterLOCK;
        synchronized (object) {
            existingDimensionFilter = this.memberFilter;
        }
        Object object2 = this.factFilterLOCK;
        synchronized (object2) {
            existingFactFilter = this.factFilter;
        }
        return new OlapRoleHierarchicalSchemaRegularPermissions(roleName, this.access, this.authorizedReportingDatasources, this.authorizedDimensions, this.authorizedCubes, this.authorizedPerspectives, existingDimensionFilter, existingFactFilter, this.schema, loadPartitionsInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IOlapSchemaPermission doIncrement(String roleName, OlapSchemaUnloadPartitionsInfo unloadPartitionsInfo) {
        OlapRoleSchemaFactFilter existingFactFilter;
        OlapRoleSchemaMemberFilter existingDimensionFilter;
        Object object = this.memberFilterLOCK;
        synchronized (object) {
            existingDimensionFilter = this.memberFilter;
        }
        Object object2 = this.factFilterLOCK;
        synchronized (object2) {
            existingFactFilter = this.factFilter;
        }
        return new OlapRoleHierarchicalSchemaRegularPermissions(roleName, this.access, this.authorizedReportingDatasources, this.authorizedDimensions, this.authorizedCubes, this.authorizedPerspectives, existingDimensionFilter, existingFactFilter, this.schema, unloadPartitionsInfo);
    }

    @Override
    public boolean isDimensionAuthorized(OlapDimension dimension) {
        return this.authorizedDimensions.containsKey(dimension);
    }

    @Override
    public IOlapDimensionPermission getDimensionPermissions(OlapDimension dimension) {
        IOlapDimensionPermission permissions = this.authorizedDimensions.get(dimension);
        if (permissions != null) {
            return permissions;
        }
        throw new OlapRoleAuthorizationRuntimeException("The dimension [" + ONames.name4Log(dimension) + "] in schema [" + this.schema.getName() + "] is not authorized");
    }

    @Override
    public boolean isReportingDataSourceAuthorized(OlapBuilderBaseDataSource dataSource) {
        return this.authorizedReportingDatasources;
    }

    @Override
    public boolean isCubeAuthorized(OlapCube cube) {
        return this.authorizedCubes.containsKey(cube);
    }

    @Override
    public boolean isPerspectiveAuthorized(OlapPerspectiveCube perspective) {
        return this.authorizedPerspectives.contains(perspective);
    }

    @Override
    public IOlapCubePermission getCubePermissions(OlapCube cube) {
        OlapRoleCubePermissions permissions = this.authorizedCubes.get(cube);
        if (permissions != null) {
            return permissions;
        }
        throw new OlapRoleAuthorizationRuntimeException("The cube [" + ONames.name4Log(cube) + "] in schema [" + this.schema.getName() + "] is not authorized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public OlapMemberFilter getMemberFilter() {
        Object object = this.memberFilterLOCK;
        synchronized (object) {
            if (this.memberFilter == null) {
                this.memberFilter = this.setupMemberFilter();
            }
            return this.memberFilter;
        }
    }

    private OlapRoleSchemaMemberFilter setupMemberFilter() {
        ArrayList<IOlapHierarchyFilter> hierarchyFilters = new ArrayList<IOlapHierarchyFilter>();
        for (OlapRoleDimensionPermissions dimensions : this.authorizedDimensions.values()) {
            for (OlapRoleHierarchyPermissions hierarchies : dimensions.getHierarchyPermissions()) {
                OlapRoleHierarchyFilter filter = hierarchies.getHierarchyFilter();
                hierarchyFilters.add(filter);
            }
        }
        return new OlapRoleSchemaMemberFilter(hierarchyFilters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OlapRoleFactFilter getFactFilter() {
        Object object = this.factFilterLOCK;
        synchronized (object) {
            if (this.factFilter == null) {
                this.factFilter = this.setupFactFilter();
            }
            return this.factFilter;
        }
    }

    private OlapRoleSchemaFactFilter setupFactFilter() {
        HashSet<OlapRoleSchemaFactFilter.MeasureGroupInfo> infos = new HashSet<OlapRoleSchemaFactFilter.MeasureGroupInfo>();
        for (OlapRoleCubePermissions cubePermissions : this.authorizedCubes.values()) {
            for (OlapRoleMeasureGroupPermissions measureGroupPermissions : cubePermissions.getAuthorizedMeasureGroups()) {
                infos.add(this.setupMeasureGroupInfo(measureGroupPermissions));
            }
        }
        return new OlapRoleSchemaFactFilter(this.schema, this.roleName, infos);
    }

    private OlapRoleSchemaFactFilter.MeasureGroupInfo setupMeasureGroupInfo(OlapRoleMeasureGroupPermissions measureGroupPermissions) {
        List<OlapIterator<? extends OlapTuple>> allowed = this.setupApplyToCells_allowed();
        List<OlapIterator<? extends OlapTuple>> denied = this.setupApplyToCells_denied();
        if (measureGroupPermissions.isFullyAuthorized() && allowed == null && denied == null) {
            return OlapRoleSchemaFactFilter.MeasureGroupInfo.fullyAuthorized(measureGroupPermissions.getMeasureGroup());
        }
        if (measureGroupPermissions instanceof OlapRoleHierarchicalMeasureGroupRegularPermissions) {
            OlapRoleHierarchicalMeasureGroupRegularPermissions measureGroupPermissions_ = (OlapRoleHierarchicalMeasureGroupRegularPermissions)measureGroupPermissions;
            allowed = this.addTo(allowed, measureGroupPermissions_.getAllowedCells());
            denied = this.addTo(denied, measureGroupPermissions_.getDeniedCells());
        }
        if (allowed == null && denied == null) {
            throw new CdShouldNotBeHereProgrammingException();
        }
        return new OlapRoleSchemaFactFilter.MeasureGroupInfo(measureGroupPermissions.getMeasureGroup(), allowed, denied);
    }

    @Nullable
    private List<OlapIterator<? extends OlapTuple>> setupApplyToCells_allowed() {
        List<OlapIterator<? extends OlapTuple>> allAllowedCells = null;
        for (OlapRoleDimensionPermissions dimensionPermissions : this.authorizedDimensions.values()) {
            for (OlapRoleHierarchyPermissions hierarchyPermissions : dimensionPermissions.getHierarchyPermissions()) {
                OlapRoleHierarchicalHierarchyRegularPermissions hierarchyPermissions_;
                if (!(hierarchyPermissions instanceof OlapRoleHierarchicalHierarchyRegularPermissions) || !(hierarchyPermissions_ = (OlapRoleHierarchicalHierarchyRegularPermissions)hierarchyPermissions).isApplyToCells()) continue;
                allAllowedCells = this.addTo(allAllowedCells, hierarchyPermissions_.getAllowedCells());
            }
        }
        return allAllowedCells;
    }

    @Nullable
    private List<OlapIterator<? extends OlapTuple>> setupApplyToCells_denied() {
        List<OlapIterator<? extends OlapTuple>> allDeniedCells = null;
        for (OlapRoleDimensionPermissions dimensionPermissions : this.authorizedDimensions.values()) {
            for (OlapRoleHierarchyPermissions hierarchyPermissions : dimensionPermissions.getHierarchyPermissions()) {
                OlapRoleHierarchicalHierarchyRegularPermissions hierarchyPermissions_;
                if (!(hierarchyPermissions instanceof OlapRoleHierarchicalHierarchyRegularPermissions) || !(hierarchyPermissions_ = (OlapRoleHierarchicalHierarchyRegularPermissions)hierarchyPermissions).isApplyToCells()) continue;
                allDeniedCells = this.addTo(allDeniedCells, hierarchyPermissions_.getDeniedCells());
            }
        }
        return allDeniedCells;
    }

    @Nullable
    private List<OlapIterator<? extends OlapTuple>> addTo(@Nullable List<OlapIterator<? extends OlapTuple>> to, @Nullable OlapIterator<? extends OlapTuple> cells) {
        if (cells == null) {
            return to;
        }
        if (to == null) {
            to = new ArrayList<OlapIterator<? extends OlapTuple>>();
        }
        to.add(cells.newInstance());
        return to;
    }
}

