/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.permissions.role;

import crazydev.iccube.authorization.definition.role.OlapRoleDefinition;
import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.authorization.permissions.role.OlapRoleBuilderFullControlPermissions;
import crazydev.iccube.authorization.permissions.role.OlapRoleFullControlPermissions;
import crazydev.iccube.authorizationx.flat.definition.dashboards.OlapRoleFlatDashboardsDefinition;
import crazydev.iccube.authorizationx.flat.definition.dashboards.OlapRoleFlatDashboardsProfile;
import crazydev.iccube.authorizationx.flat.definition.docs.OlapRoleFlatDocsProfile;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.entity.permissions.IOlapSchemasPermission;
import crazydev.iccube.olap.eval.script.OlapScriptInformation;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaIncrLoadInfo;
import crazydev.iccube.olap.schema.OlapSchemaLoadPartitionsInfo;
import crazydev.iccube.olap.schema.OlapSchemaUnloadPartitionsInfo;
import java.util.Date;
import org.jetbrains.annotations.Nullable;

public abstract class OlapRolePermissions {
    private final String roleName;
    private volatile boolean onTheFly;
    private volatile long onTheFlyLastUsedMS = -1L;
    private volatile OlapRolePermissions onTheFlyTemplate;

    public OlapRolePermissions(String name) {
        this.roleName = name;
    }

    public long getTotalElapsedMS() {
        return 0L;
    }

    public String getDetailedTotalElapsedMS() {
        return "-";
    }

    public void setAsOnTheFly(OlapRolePermissions template) {
        this.onTheFly = true;
        this.onTheFlyLastUsedMS = System.currentTimeMillis();
        this.onTheFlyTemplate = template;
        IOlapSchemasPermission schemasPerms = this.getSchemasPermissions();
        IOlapSchemasPermission templateSchemasPerms = this.onTheFlyTemplate.getSchemasPermissions();
        schemasPerms.setAsOnTheFly(templateSchemasPerms);
    }

    public boolean isOnTheFly() {
        return this.onTheFly;
    }

    public long getOnTheFlyUsed() {
        return this.onTheFlyLastUsedMS;
    }

    public void resetOnTheFlyLastUsed() {
        this.onTheFlyLastUsedMS = System.currentTimeMillis();
    }

    public boolean isOnTheFlyIdlePeriodExpired(int idlePeriodMin) {
        long expiryMS;
        if (this.onTheFlyLastUsedMS == -1L) {
            return false;
        }
        long nowMS = new Date().getTime();
        return nowMS >= this.onTheFlyLastUsedMS + (expiryMS = (long)(idlePeriodMin * 60) * 1000L);
    }

    public static OlapRolePermissions createElevatedPermissionsForBuilder() {
        return new OlapRoleBuilderFullControlPermissions("builder-elevated");
    }

    public static OlapRolePermissions createElevatedPermissionsForApplyPermissions() {
        return new OlapRoleFullControlPermissions("apply-permissions-elevated");
    }

    public String getRoleName() {
        return this.roleName;
    }

    public abstract OlapRoleDefinition getDefinition();

    public abstract String getSchemaPermsDefinitionForUX();

    public abstract String getDashboardsPermsDefinitionForUX();

    public abstract String getDocsPermsDefinitionForUX();

    public abstract void onSchemaLoaded(OlapEngineRequestContext var1, OlapSchema var2);

    public abstract void onSchemaIncrLoaded(OlapEngineRequestContext var1, OlapSchema var2, OlapSchemaIncrLoadInfo var3);

    public abstract void onSchemaIncrLoadedOnError(OlapEngineRequestContext var1, OlapSchema var2);

    public abstract void onSchemaScriptStatementApplied(OlapEngineRequestContext var1, OlapSchema var2, OlapScriptInformation var3);

    public abstract void onSchemaUnloaded(OlapEngineRequestContext var1, OlapSchema var2);

    public abstract void onSchemaPartitionsUnloaded(OlapEngineRequestContext var1, OlapSchema var2, OlapSchemaUnloadPartitionsInfo var3);

    public abstract void onSchemaPartitionsLoaded(OlapEngineRequestContext var1, OlapSchema var2, OlapSchemaLoadPartitionsInfo var3);

    public abstract void onSchemaPartitionsLoadError(OlapEngineRequestContext var1, OlapSchema var2);

    public abstract boolean isFullControl();

    public abstract OlapRoleApplicationPermissions getApplicationPermissions();

    public abstract IOlapSchemasPermission getSchemasPermissions();

    public OlapRoleFlatDashboardsProfile getDashboardsPermissions() {
        return new OlapRoleFlatDashboardsProfile(new OlapRoleFlatDashboardsDefinition(""));
    }

    @Nullable
    public OlapRoleFlatDocsProfile getDocsPermissions() {
        return null;
    }

    public String toString() {
        return this.roleName + " (isFullControl:" + this.isFullControl() + ")";
    }
}

