/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.permissions.hierarchy.builder;

import crazydev.common.exception.CdRuntimeException;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.mdx.error.CdMdxException;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.authorization.definition.common.OlapRoleEntityListTypeDefinition;
import crazydev.iccube.authorization.definition.dimension.OlapRoleDimensionDefinition;
import crazydev.iccube.authorization.definition.hierarchy.OlapRoleHierarchyDefinition;
import crazydev.iccube.authorization.definition.hierarchy.OlapRoleHierarchyEntityListDefinition;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionError;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorCode;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorManager;
import crazydev.iccube.authorization.permissions.common.builder.OlapRoleAbstractPermissionsBuilder;
import crazydev.iccube.authorization.permissions.filter.dimension.OlapRoleHierarchyFilter;
import crazydev.iccube.authorization.permissions.hierarchy.OlapRoleHierarchicalHierarchyRegularPermissions;
import crazydev.iccube.authorization.validation.common.OlapRoleDefinitionApplyValidationContext;
import crazydev.iccube.authorizationx.permissions.common.OlapRolePermissionsBuilderHelper;
import crazydev.iccube.authorizationx.permissions.hierarchy.OlapRoleHierarchyAllDefaultPermissions;
import crazydev.iccube.authorizationx.permissions.hierarchy.OlapRoleHierarchyPermissions;
import crazydev.iccube.authorizationx.permissions.hierarchy.OlapRoleHierarchyRegularPermissions;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.component.schemas.OlapEngineSchemaDefFactoryHelper;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.OlapNullEntity;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.util.OlapCaseInsensitiveNames;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapRoleHierarchicalHierarchyPermissionsBuilder
extends OlapRoleAbstractPermissionsBuilder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OlapRoleHierarchyPermissions> createAuthorizedHierarchies(OlapRoleDefinitionApplyValidationContext validationContext, OlapRoleDimensionDefinition validDefinition, OlapSchema schema, OlapDimension dimension) {
        OlapRoleDefinitionErrorManager errorManager = (OlapRoleDefinitionErrorManager)validationContext.getErrorManager();
        OlapNameContext nameContext = validationContext.getNameContext();
        errorManager.pushContext(validDefinition);
        try {
            OlapEngineSchemaDefFactoryHelper helper = validationContext.getSchemaDefFactoryHelper();
            OlapRoleHierarchyEntityListDefinition authorizedHierarchyNamesDefinition = validDefinition.getValidatedAuthorizedHierarchyNames();
            OlapCaseInsensitiveNames authorizedHierarchyNames = authorizedHierarchyNamesDefinition.resolveAuthorizedNames(helper.getAllHierarchyNames(schema.getName(), dimension.getName(nameContext)));
            ArrayList<OlapRoleHierarchyPermissions> allHierarchies = new ArrayList<OlapRoleHierarchyPermissions>();
            for (String authorizedHierarchyName : authorizedHierarchyNames) {
                OlapHierarchy hierarchy = this.resolveHierarchy(nameContext, dimension, authorizedHierarchyName);
                if (hierarchy == null) {
                    errorManager.addError(OlapRoleDefinitionErrorCode.HIERARCHY_UNKNOWN, new Serializable[]{dimension.getUniqueName(nameContext), authorizedHierarchyName});
                    continue;
                }
                OlapRoleHierarchyDefinition hierarchyDefinition = validDefinition.getHierarchyPermission(authorizedHierarchyName);
                if (hierarchyDefinition != null) {
                    OlapRoleEntityListTypeDefinition type = hierarchyDefinition.getAuthorizedMemberNamesType();
                    OlapMember defaultMember = this.resolveDefaultMember(validationContext, hierarchyDefinition, schema, hierarchy);
                    if (type == OlapRoleEntityListTypeDefinition.ALL) {
                        allHierarchies.add(new OlapRoleHierarchyAllDefaultPermissions(hierarchy, defaultMember));
                        continue;
                    }
                    OlapIterator<? extends OlapMember> authorizedMembers = this.resolveMemberSelection(validationContext, hierarchyDefinition, schema, hierarchy);
                    boolean applyToCells = hierarchyDefinition.isApplyToCells();
                    OlapRoleHierarchicalHierarchyRegularPermissions permissions = new OlapRoleHierarchicalHierarchyRegularPermissions(schema.getCalcMemberManager(), hierarchy, type, authorizedMembers, defaultMember, applyToCells);
                    this.validateDefaultMemberIsAuthorized(validationContext, permissions);
                    allHierarchies.add(permissions);
                    continue;
                }
                allHierarchies.add(hierarchy.getAllPermissions());
            }
            ArrayList<OlapRoleHierarchyPermissions> arrayList = allHierarchies;
            return arrayList;
        }
        finally {
            errorManager.popContext();
        }
    }

    private OlapIterator<? extends OlapMember> resolveMemberSelection(OlapRoleDefinitionApplyValidationContext validationContext, OlapRoleHierarchyDefinition hierarchyDefinition, OlapSchema schema, OlapHierarchy hierarchy) {
        OlapRoleDefinitionErrorManager errorManager = (OlapRoleDefinitionErrorManager)validationContext.getErrorManager();
        OlapNameContext nameContext = validationContext.getNameContext();
        OlapRoleEntityListTypeDefinition type = hierarchyDefinition.getAuthorizedMemberNamesType();
        if (type == OlapRoleEntityListTypeDefinition.SELECTION || type == OlapRoleEntityListTypeDefinition.ALL_MINUS_SELECTION) {
            String mdx = hierarchyDefinition.getAuthorizedMemberNames();
            if (CdStringUtils.isNullOrBlank((String)mdx)) {
                return OlapIteratorFactory.empty();
            }
            OlapEntity result = this.executeAuthorizedMembersMdxExpression(validationContext, schema, hierarchy, mdx);
            if (result instanceof OlapMember) {
                OlapMember member = (OlapMember)result;
                if (!member.getHierarchy().equals(hierarchy)) {
                    errorManager.addError(OlapRoleDefinitionErrorCode.MDX_EVAL_HIERARCHY_MEMBERS_UNEXPECTED_HIERARCHY, new Serializable[]{hierarchy.getUniqueName(nameContext), member.getHierarchy().getUniqueName(nameContext)});
                    return OlapIteratorFactory.empty();
                }
                return OlapIteratorFactory.singleton(member);
            }
            if (result instanceof OlapTupleSet) {
                OlapTuple tuple;
                OlapIterator tuples = ((OlapTupleSet)result).getIterator(false);
                tuples.reset();
                while ((tuple = (OlapTuple)tuples.next()) != null) {
                    if (tuple.getMemberCount() != 1) {
                        errorManager.addError(OlapRoleDefinitionErrorCode.MDX_EVAL_HIERARCHY_MEMBERS_TYPE_MISMATCH, new Serializable[]{hierarchy.getUniqueName(nameContext), tuple.getFriendlyTypeName()});
                        return OlapIteratorFactory.empty();
                    }
                    OlapMember member = tuple.getMember(0);
                    if (member.getHierarchy().equals(hierarchy)) continue;
                    errorManager.addError(OlapRoleDefinitionErrorCode.MDX_EVAL_HIERARCHY_MEMBERS_UNEXPECTED_HIERARCHY, new Serializable[]{hierarchy.getUniqueName(nameContext), member.getHierarchy().getUniqueName(nameContext)});
                    return OlapIteratorFactory.empty();
                }
                return tuples;
            }
            errorManager.addError(OlapRoleDefinitionErrorCode.MDX_EVAL_HIERARCHY_MEMBERS_TYPE_MISMATCH, new Serializable[]{hierarchy.getUniqueName(nameContext), result.getFriendlyTypeName()});
            return OlapIteratorFactory.empty();
        }
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Nullable
    private OlapMember resolveDefaultMember(OlapRoleDefinitionApplyValidationContext validationContext, OlapRoleHierarchyDefinition hierarchyDefinition, OlapSchema schema, OlapHierarchy hierarchy) {
        OlapRoleDefinitionErrorManager errorManager = (OlapRoleDefinitionErrorManager)validationContext.getErrorManager();
        OlapNameContext nameContext = validationContext.getNameContext();
        String mdx = hierarchyDefinition.getDefaultMember();
        if (mdx == null) {
            return null;
        }
        OlapEntity result = this.executeDefaultMemberMdxExpression(validationContext, schema, hierarchy, mdx);
        if (result instanceof OlapMember) {
            OlapMember member = (OlapMember)result;
            if (!member.getHierarchy().equals(hierarchy)) {
                errorManager.addError(OlapRoleDefinitionErrorCode.MDX_EVAL_HIERARCHY_DEFAULT_MEMBER_UNEXPECTED_HIERARCHY, new Serializable[]{hierarchy.getUniqueName(nameContext), member.getHierarchy().getUniqueName(nameContext)});
                return null;
            }
            return member;
        }
        errorManager.addError(OlapRoleDefinitionErrorCode.MDX_EVAL_HIERARCHY_DEFAULT_MEMBER_TYPE_MISMATCH, new Serializable[]{hierarchy.getUniqueName(nameContext), result.getFriendlyTypeName()});
        return null;
    }

    private OlapEntity executeDefaultMemberMdxExpression(OlapRoleDefinitionApplyValidationContext validationContext, OlapSchema schema, OlapHierarchy hierarchy, String mdx) {
        OlapRoleDefinitionErrorManager errorManager = (OlapRoleDefinitionErrorManager)validationContext.getErrorManager();
        OlapNameContext nameContext = validationContext.getNameContext();
        try {
            return OlapRolePermissionsBuilderHelper.executeMdxExpressionWithNoEval(validationContext, schema, null, mdx);
        }
        catch (CdMdxException ex) {
            LOGGER.error((Object)"Role hierarchy permissions setup : reporting an MDX (default member) evaluation error", (Throwable)ex);
            errorManager.addError(new OlapRoleDefinitionError(ex.getError(), OlapRoleDefinitionErrorCode.MDX_EVAL_HIERARCHY_DEFAULT_MEMBER_ERROR, new Serializable[]{hierarchy.getUniqueName(nameContext), ex.getError()}));
            return OlapNullEntity.INSTANCE;
        }
        catch (CdRuntimeException ex) {
            LOGGER.error((Object)"Role hierarchy permissions setup : reporting an MDX (default member) evaluation error", (Throwable)ex);
            errorManager.addError(new OlapRoleDefinitionError(ex.getError(), OlapRoleDefinitionErrorCode.MDX_EVAL_HIERARCHY_DEFAULT_MEMBER_ERROR, new Serializable[]{hierarchy.getUniqueName(nameContext), ex.getError()}));
            return OlapNullEntity.INSTANCE;
        }
    }

    private OlapEntity executeAuthorizedMembersMdxExpression(OlapRoleDefinitionApplyValidationContext validationContext, OlapSchema schema, OlapHierarchy hierarchy, String mdx) {
        OlapRoleDefinitionErrorManager errorManager = (OlapRoleDefinitionErrorManager)validationContext.getErrorManager();
        OlapNameContext nameContext = validationContext.getNameContext();
        try {
            return OlapRolePermissionsBuilderHelper.executeMdxExpressionWithNoEval(validationContext, schema, null, mdx);
        }
        catch (CdMdxException ex) {
            LOGGER.error((Object)"Role hierarchy permissions setup : reporting an MDX (members) evaluation error", (Throwable)ex);
            errorManager.addError(new OlapRoleDefinitionError(ex.getError(), OlapRoleDefinitionErrorCode.MDX_EVAL_HIERARCHY_MEMBERS_ERROR, new Serializable[]{hierarchy.getUniqueName(nameContext), ex.getError()}));
            return OlapNullEntity.INSTANCE;
        }
        catch (CdRuntimeException ex) {
            LOGGER.error((Object)"Role hierarchy permissions setup : reporting an MDX (members) evaluation error", (Throwable)ex);
            errorManager.addError(new OlapRoleDefinitionError(ex.getError(), OlapRoleDefinitionErrorCode.MDX_EVAL_HIERARCHY_MEMBERS_ERROR, new Serializable[]{hierarchy.getUniqueName(nameContext), ex.getError()}));
            return OlapNullEntity.INSTANCE;
        }
    }

    private void validateDefaultMemberIsAuthorized(OlapRoleDefinitionApplyValidationContext validationContext, OlapRoleHierarchyRegularPermissions permissions) {
        OlapMember defaultMember = permissions.getDefaultMember();
        if (defaultMember == null) {
            return;
        }
        OlapHierarchy hierarchy = permissions.getHierarchy();
        OlapRoleHierarchyFilter filter = permissions.getHierarchyFilter();
        if (filter != null && !filter.isAcceptingMember(defaultMember)) {
            OlapNameContext nameContext = validationContext.getNameContext();
            validationContext.addError(OlapRoleDefinitionErrorCode.MDX_EVAL_HIERARCHY_DEFAULT_MEMBER_NOT_AUTHORIZED, new Serializable[]{hierarchy.getUniqueName(nameContext), defaultMember.getUniqueName(nameContext)});
        }
    }

    @Nullable
    private OlapHierarchy resolveHierarchy(OlapNameContext nameContext, OlapDimension dimension, String hierarchyName) {
        for (OlapHierarchy hierarchy : dimension.getHierarchies()) {
            if (!hierarchy.getName(nameContext).equals(hierarchyName)) continue;
            return hierarchy;
        }
        return null;
    }
}

