/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.permissions.hierarchy;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.authorization.definition.common.OlapRoleEntityListTypeDefinition;
import crazydev.iccube.authorization.permissions.filter.dimension.OlapRoleHierarchyFilter;
import crazydev.iccube.authorization.permissions.filter.dimension.OlapRoleNegativeHierarchyFilter;
import crazydev.iccube.authorization.permissions.filter.dimension.OlapRolePositiveHierarchyFilter;
import crazydev.iccube.authorizationx.permissions.hierarchy.OlapRoleHierarchyRegularPermissions;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.olap.entity.cmember.OlapCalculatedMemberManager;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapMember;
import org.jetbrains.annotations.Nullable;

public class OlapRoleHierarchicalHierarchyRegularPermissions
extends OlapRoleHierarchyRegularPermissions {
    private final boolean applyToCells;
    @Nullable
    private final OlapIterator<? extends OlapMember> allowedCells;
    @Nullable
    private final OlapIterator<? extends OlapMember> deniedCells;
    private final OlapRoleHierarchyFilter hierarchyFilter;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OlapRoleHierarchicalHierarchyRegularPermissions(OlapCalculatedMemberManager calcMembers, OlapHierarchy hierarchy, OlapRoleEntityListTypeDefinition type, OlapIterator<? extends OlapMember> memberSelection, @Nullable OlapMember defaultMember, boolean applyToCells) {
        super(hierarchy);
        this.hierarchyFilter = OlapRoleHierarchicalHierarchyRegularPermissions.setupHierarchyFilter(calcMembers, hierarchy, type, memberSelection, defaultMember);
        this.applyToCells = applyToCells;
        if (this.applyToCells) {
            if (type == OlapRoleEntityListTypeDefinition.SELECTION) {
                this.allowedCells = memberSelection;
                this.deniedCells = null;
                return;
            } else {
                if (type != OlapRoleEntityListTypeDefinition.ALL_MINUS_SELECTION) throw new CdShouldNotBeHereProgrammingException();
                this.allowedCells = null;
                this.deniedCells = memberSelection;
            }
            return;
        } else {
            this.allowedCells = null;
            this.deniedCells = null;
        }
    }

    private static OlapRoleHierarchyFilter setupHierarchyFilter(OlapCalculatedMemberManager calcMembers, OlapHierarchy hierarchy, OlapRoleEntityListTypeDefinition type, OlapIterator<? extends OlapMember> memberSelection, @Nullable OlapMember defaultMember) {
        if (type == OlapRoleEntityListTypeDefinition.SELECTION) {
            return new OlapRolePositiveHierarchyFilter(calcMembers, hierarchy, defaultMember, memberSelection);
        }
        if (type == OlapRoleEntityListTypeDefinition.ALL_MINUS_SELECTION) {
            return new OlapRoleNegativeHierarchyFilter(calcMembers, hierarchy, defaultMember, memberSelection);
        }
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    public OlapRoleHierarchyFilter getHierarchyFilter() {
        return this.hierarchyFilter;
    }

    public boolean isApplyToCells() {
        return this.applyToCells;
    }

    @Nullable
    public OlapIterator<? extends OlapMember> getAllowedCells() {
        return this.allowedCells != null ? this.allowedCells.newInstance() : null;
    }

    @Nullable
    public OlapIterator<? extends OlapMember> getDeniedCells() {
        return this.deniedCells != null ? this.deniedCells.newInstance() : null;
    }
}

