/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.permissions.filter.fact;

import crazydev.iccube.authorization.permissions.filter.fact.OlapRoleFactFilter;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.cluster.master.schema.M_SchemaSubCubeFactory;
import crazydev.iccube.cluster.shared.perms.S_FactFullControlPermsDef;
import crazydev.iccube.cluster.shared.perms.S_FactMeasureGroupsPermsDef;
import crazydev.iccube.cluster.shared.perms.S_FactPermsDef;
import crazydev.iccube.cluster.shared.schema.S_FactSubCube;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaIncrLoadInfo;
import crazydev.iccube.olap.schema.OlapSchemaLoadPartitionsInfo;
import crazydev.iccube.olap.schema.OlapSchemaUnloadPartitionsInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class OlapRoleSchemaFactFilter
extends OlapRoleFactFilter {
    private final OlapSchema schema;
    private final String roleName;
    private final IdentityHashMap<IOlapBuilderBaseFactsDef, MeasureGroupInfo> measureGroupInfos;

    public OlapRoleSchemaFactFilter(OlapSchema schema, String roleName, Set<MeasureGroupInfo> infos) {
        this.schema = schema;
        this.roleName = roleName;
        this.measureGroupInfos = new IdentityHashMap();
        for (MeasureGroupInfo info : infos) {
            this.measureGroupInfos.put(info.factsDefinition, info);
        }
    }

    private OlapRoleSchemaFactFilter(OlapSchema schema, String roleName, IdentityHashMap measureGroupInfos) {
        this.schema = schema;
        this.roleName = roleName;
        this.measureGroupInfos = measureGroupInfos;
    }

    public OlapRoleSchemaFactFilter copyForIncrementalLoad(OlapSchemaIncrLoadInfo incrLoadInfo) {
        return new OlapRoleSchemaFactFilter(this.schema, this.roleName, this.measureGroupInfos);
    }

    public OlapRoleSchemaFactFilter copyForLoadPartitions(OlapSchemaLoadPartitionsInfo loadPartitionsInfo) {
        return new OlapRoleSchemaFactFilter(this.schema, this.roleName, this.measureGroupInfos);
    }

    public OlapRoleSchemaFactFilter copyForUnloadPartitions(OlapSchemaUnloadPartitionsInfo unloadPartitionsInfo) {
        return new OlapRoleSchemaFactFilter(this.schema, this.roleName, this.measureGroupInfos);
    }

    public Collection<MeasureGroupInfo> __getMeasureGroupInfos() {
        return this.measureGroupInfos.values();
    }

    @Override
    public S_FactPermsDef createClusterSchemaSecurityPermsDef() {
        HashSet<String> fullyAuthorized = new HashSet<String>();
        HashMap<String, S_FactSubCube> partiallyAuthorized = new HashMap<String, S_FactSubCube>();
        for (Map.Entry<IOlapBuilderBaseFactsDef, MeasureGroupInfo> entry : this.measureGroupInfos.entrySet()) {
            IOlapBuilderBaseFactsDef factsDef = entry.getKey();
            MeasureGroupInfo factsPerms = entry.getValue();
            if (factsPerms.isFullyAuthorized()) {
                fullyAuthorized.add(factsDef.getName());
                continue;
            }
            S_FactSubCube subCube = M_SchemaSubCubeFactory.createForPerms(factsPerms.allowedCells(), factsPerms.deniedCells());
            partiallyAuthorized.put(factsDef.getName(), subCube);
        }
        if (fullyAuthorized.isEmpty() && partiallyAuthorized.isEmpty()) {
            return new S_FactFullControlPermsDef();
        }
        return new S_FactMeasureGroupsPermsDef(fullyAuthorized, partiallyAuthorized);
    }

    public static class MeasureGroupInfo {
        private final IOlapBuilderBaseFactsDef factsDefinition;
        @Nullable
        private final List<OlapIterator<? extends OlapTuple>> allowedCells;
        @Nullable
        private final List<OlapIterator<? extends OlapTuple>> deniedCells;

        public MeasureGroupInfo(IOlapBuilderBaseFactsDef factsDefinition, @Nullable List<OlapIterator<? extends OlapTuple>> allowedCells, @Nullable List<OlapIterator<? extends OlapTuple>> deniedCells) {
            this.factsDefinition = factsDefinition;
            this.allowedCells = allowedCells;
            this.deniedCells = deniedCells;
        }

        public static MeasureGroupInfo fullyAuthorized(IOlapBuilderBaseFactsDef measureGroup) {
            return new MeasureGroupInfo(measureGroup, null, null);
        }

        public boolean isFullyAuthorized() {
            return this.allowedCells == null && this.deniedCells == null;
        }

        public boolean isAllowedCells() {
            return this.allowedCells != null;
        }

        public boolean isDeniedCells() {
            return this.deniedCells != null;
        }

        @Nullable
        public List<OlapIterator<? extends OlapTuple>> allowedCells() {
            if (this.allowedCells == null) {
                return null;
            }
            ArrayList<OlapIterator<? extends OlapTuple>> cells = new ArrayList<OlapIterator<? extends OlapTuple>>();
            for (OlapIterator<? extends OlapTuple> iterator : this.allowedCells) {
                cells.add(iterator.newInstance());
            }
            return cells;
        }

        @Nullable
        public List<OlapIterator<? extends OlapTuple>> deniedCells() {
            if (this.deniedCells == null) {
                return null;
            }
            ArrayList<OlapIterator<? extends OlapTuple>> cells = new ArrayList<OlapIterator<? extends OlapTuple>>();
            for (OlapIterator<? extends OlapTuple> iterator : this.deniedCells) {
                cells.add(iterator.newInstance());
            }
            return cells;
        }

        public String toString() {
            return this.factsDefinition.getMeasureGroupName();
        }
    }
}

