/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.permissions.filter.dimension;

import crazydev.iccube.authorization.permissions.filter.dimension.OlapRoleHierarchyFilter;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.olap.entity.cmember.OlapCalculatedMemberManager;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapMember;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class OlapRoleNegativeHierarchyFilter
extends OlapRoleHierarchyFilter {
    private final MutableRoaringBitmap deniedMembers;

    public OlapRoleNegativeHierarchyFilter(OlapCalculatedMemberManager calcMembers, OlapHierarchy hierarchy, @Nullable OlapMember defaultMember, OlapIterator<? extends OlapMember> selection) {
        super(hierarchy, defaultMember);
        this.deniedMembers = OlapRoleNegativeHierarchyFilter.setupDeniedMembers(calcMembers, hierarchy, defaultMember, OlapRoleNegativeHierarchyFilter.toList(selection));
    }

    private static MutableRoaringBitmap setupDeniedMembers(OlapCalculatedMemberManager calcMembers, OlapHierarchy hierarchy, @Nullable OlapMember defaultMember, List<? extends OlapMember> selection) {
        MutableRoaringBitmap denied = new MutableRoaringBitmap();
        for (OlapMember olapMember : selection) {
            OlapMember child;
            OlapIterator<OlapMember> children = olapMember.getChildrenR(null, null, true);
            children.reset();
            while ((child = children.next()) != null) {
                denied.add(child.getUniqueHierarchyMemberIndex());
            }
        }
        denied.runOptimize();
        return denied;
    }

    @Override
    public boolean isAccepting(OlapMember member) {
        return !this.deniedMembers.contains(member.getUniqueHierarchyMemberIndex());
    }
}

