/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.permissions.dimension;

import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationRuntimeException;
import crazydev.iccube.authorizationx.permissions.dimension.OlapRoleDimensionRegularPermissions;
import crazydev.iccube.authorizationx.permissions.hierarchy.OlapRoleHierarchyPermissions;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OlapRoleHierarchicalDimensionRegularPermissions
extends OlapRoleDimensionRegularPermissions {
    private final Map<OlapHierarchy, OlapRoleHierarchyPermissions> authorizedHierarchies = new HashMap<OlapHierarchy, OlapRoleHierarchyPermissions>();

    public OlapRoleHierarchicalDimensionRegularPermissions(OlapDimension dimension, OlapRoleHierarchyPermissions authorizedHierarchy) {
        this(dimension, Arrays.asList(authorizedHierarchy));
    }

    public OlapRoleHierarchicalDimensionRegularPermissions(OlapDimension dimension, List<OlapRoleHierarchyPermissions> authorizedHierarchies) {
        super(dimension);
        for (OlapRoleHierarchyPermissions authorizedHierarchy : authorizedHierarchies) {
            this.authorizedHierarchies.put(authorizedHierarchy.getHierarchy(), authorizedHierarchy);
        }
    }

    @Override
    public boolean isHierarchyAuthorized(OlapHierarchy hierarchy) {
        return this.authorizedHierarchies.containsKey(hierarchy);
    }

    @Override
    public Iterable<OlapRoleHierarchyPermissions> getHierarchyPermissions() {
        return this.authorizedHierarchies.values();
    }

    @Override
    public OlapRoleHierarchyPermissions getHierarchyPermission(OlapHierarchy hierarchy) {
        OlapRoleHierarchyPermissions permissions = this.authorizedHierarchies.get(hierarchy);
        if (permissions != null) {
            return permissions;
        }
        throw new OlapRoleAuthorizationRuntimeException("The hierarchy [" + ONames.name4Log(hierarchy) + "] in dimension [" + ONames.name4Log(this.dimension) + "] is not authorized");
    }
}

