/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.permissions.cube.builder;

import crazydev.iccube.authorization.definition.cube.OlapRoleCubeDefinition;
import crazydev.iccube.authorization.definition.cube.OlapRoleCubeEntityListDefinition;
import crazydev.iccube.authorization.definition.schema.OlapRoleSchemaDefinition;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorCode;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorManager;
import crazydev.iccube.authorization.permissions.common.OlapRoleAccess;
import crazydev.iccube.authorization.permissions.common.builder.OlapRoleAbstractPermissionsBuilder;
import crazydev.iccube.authorization.permissions.cube.OlapRoleHierarchicalCubeRegularPermissions;
import crazydev.iccube.authorization.permissions.measuregroup.builder.OlapRoleHierarchicalMeasureGroupPermissionsBuilder;
import crazydev.iccube.authorization.validation.common.OlapRoleDefinitionApplyValidationContext;
import crazydev.iccube.authorizationx.permissions.cube.OlapRoleCubeAllPermissions;
import crazydev.iccube.authorizationx.permissions.cube.OlapRoleCubePermissions;
import crazydev.iccube.authorizationx.permissions.measuregroup.OlapRoleMeasureGroupPermissions;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.component.schemas.OlapEngineSchemaDefFactoryHelper;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import crazydev.iccube.olap.util.OlapCaseInsensitiveNames;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapRoleHierarchicalCubePermissionsBuilder
extends OlapRoleAbstractPermissionsBuilder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OlapRoleCubePermissions> createAuthorizedCubesPermissions(OlapRoleDefinitionApplyValidationContext validationContext, OlapRoleSchemaDefinition validDefinition, OlapSchema schema) {
        OlapRoleDefinitionErrorManager errorManager = (OlapRoleDefinitionErrorManager)validationContext.getErrorManager();
        OlapNameContext nameContext = validationContext.getNameContext();
        errorManager.pushContext(validDefinition);
        try {
            OlapEngineSchemaDefFactoryHelper helper = validationContext.getSchemaDefFactoryHelper();
            OlapRoleCubeEntityListDefinition authorizedCubeNamesDefinition = validDefinition.getValidatedAuthorizedCubeNames();
            OlapCaseInsensitiveNames authorizedCubeNames = authorizedCubeNamesDefinition.resolveAuthorizedNames(helper.getAllCubeNames(schema.getName()));
            ArrayList<OlapRoleCubePermissions> allCubes = new ArrayList<OlapRoleCubePermissions>();
            for (String authorizedCubeName : authorizedCubeNames) {
                OlapCube cube = this.resolveCube(nameContext, schema.getCubes(), authorizedCubeName);
                if (cube == null) {
                    errorManager.addError(OlapRoleDefinitionErrorCode.CUBE_UNKNOWN, new Serializable[]{schema.getName(), authorizedCubeName});
                    continue;
                }
                OlapRoleCubeDefinition cubeDefinition = validDefinition.getCubePermission(authorizedCubeName);
                if (cubeDefinition != null) {
                    OlapRoleHierarchicalMeasureGroupPermissionsBuilder builder = new OlapRoleHierarchicalMeasureGroupPermissionsBuilder();
                    List<OlapRoleMeasureGroupPermissions> authorizedMeasureGroups = builder.createAuthorizedMeasureGroups(validationContext, cubeDefinition, schema, cube);
                    OlapRoleAccess access = OlapRoleAccess.fromAccessDefinition(cubeDefinition.getAccess());
                    allCubes.add(new OlapRoleHierarchicalCubeRegularPermissions(cube, access, authorizedMeasureGroups));
                    continue;
                }
                OlapRoleAccess access = OlapRoleAccess.fromAccessDefinition(validDefinition.getAccess());
                allCubes.add(new OlapRoleCubeAllPermissions(cube, access));
            }
            ArrayList<OlapRoleCubePermissions> arrayList = allCubes;
            return arrayList;
        }
        finally {
            errorManager.popContext();
        }
    }

    @Nullable
    private OlapCube resolveCube(OlapNameContext nameContext, Collection<? extends OlapCube> cubes, String cubeName) {
        for (OlapCube olapCube : cubes) {
            if (!OlapCaseInsensitiveName.equals(olapCube.getName(nameContext), cubeName)) continue;
            return olapCube;
        }
        return null;
    }
}

