/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.permissions.cube;

import crazydev.iccube.authorization.definition.common.OlapRoleEntityListTypeDefinition;
import crazydev.iccube.authorization.permissions.common.OlapRoleAccess;
import crazydev.iccube.authorization.permissions.dimension.OlapRoleHierarchicalDimensionRegularPermissions;
import crazydev.iccube.authorization.permissions.hierarchy.OlapRoleHierarchicalHierarchyRegularPermissions;
import crazydev.iccube.authorizationx.permissions.cube.OlapRoleCubeRegularPermissions;
import crazydev.iccube.authorizationx.permissions.dimension.OlapRoleDimensionPermissions;
import crazydev.iccube.authorizationx.permissions.measuregroup.OlapRoleMeasureGroupPermissions;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.dimension.OlapMeasuresDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OlapRoleHierarchicalCubeRegularPermissions
extends OlapRoleCubeRegularPermissions {
    private final Map<IOlapBuilderBaseFactsDef, OlapRoleMeasureGroupPermissions> authorizedMeasureGroups = new HashMap<IOlapBuilderBaseFactsDef, OlapRoleMeasureGroupPermissions>();
    private final OlapRoleDimensionPermissions asMeasuresDimensionPermissions;

    public OlapRoleHierarchicalCubeRegularPermissions(OlapCube cube, OlapRoleAccess access, List<OlapRoleMeasureGroupPermissions> authorizedMeasureGroups) {
        super(cube, access);
        for (OlapRoleMeasureGroupPermissions authorizedMeasureGroup : authorizedMeasureGroups) {
            this.authorizedMeasureGroups.put(authorizedMeasureGroup.getMeasureGroup(), authorizedMeasureGroup);
        }
        this.asMeasuresDimensionPermissions = this.setupAsMeasuresDimensionPermissions();
    }

    private OlapRoleDimensionPermissions setupAsMeasuresDimensionPermissions() {
        OlapMeasuresDimension dimension = this.cube.getMeasuresDimension();
        OlapHierarchy hierarchy = dimension.getMeasureHierarchy();
        List<OlapMember> authorizedMeasureMembers = this.getAuthorizedMeasureMembers();
        OlapMember defaultMember = authorizedMeasureMembers.get(0);
        OlapRoleHierarchicalHierarchyRegularPermissions hierarchyPermissions = new OlapRoleHierarchicalHierarchyRegularPermissions(this.cube.getCalcMemberManager(), hierarchy, OlapRoleEntityListTypeDefinition.SELECTION, OlapIteratorFactory.instance(authorizedMeasureMembers), defaultMember, false);
        return new OlapRoleHierarchicalDimensionRegularPermissions((OlapDimension)dimension, hierarchyPermissions);
    }

    private List<OlapMember> getAuthorizedMeasureMembers() {
        ArrayList<OlapMember> authorized = new ArrayList<OlapMember>();
        for (OlapMeasureMember measureMember : this.cube.getMeasuresDimension().getMeasureMembers(null)) {
            if (!this.isMeasureGroupAuthorized(measureMember.getMeasureGroupName())) continue;
            authorized.add(measureMember);
        }
        return authorized;
    }

    @Override
    public OlapRoleDimensionPermissions getMeasuresPermissions() {
        return this.asMeasuresDimensionPermissions;
    }

    @Override
    public boolean isMeasureGroupAuthorized(String measureGroupName) {
        for (IOlapBuilderBaseFactsDef authorizedMeasureGroup : this.authorizedMeasureGroups.keySet()) {
            if (!OlapCaseInsensitiveName.equals(measureGroupName, authorizedMeasureGroup.getMeasureGroupName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<OlapRoleMeasureGroupPermissions> getAuthorizedMeasureGroups() {
        return this.authorizedMeasureGroups.values();
    }
}

