/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.permissions.applications;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationFeaturePermissions;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationApplicationException;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationApplicationFeatureException;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationException;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.List;

public class OlapRoleApplicationPermissions {
    public static final OlapRoleApplicationPermissions FULL_CONTROL = new OlapRoleApplicationPermissions();
    private final boolean fullControl;
    private final List<OlapRoleApplicationFeaturePermissions> applications;
    private final String debug;

    protected OlapRoleApplicationPermissions() {
        this.debug = "full-control";
        this.fullControl = true;
        this.applications = null;
    }

    public OlapRoleApplicationPermissions(String debug, List<OlapRoleApplicationFeaturePermissions> applications) {
        this.debug = debug;
        this.fullControl = false;
        this.applications = applications;
    }

    public boolean isReportingEnabled() {
        return this.isApplicationEnabled("app.reportDashboard");
    }

    public boolean isMonitoringEnabled() {
        return this.isApplicationEnabled("app.monitoring");
    }

    public void assertMonitoringEnabled() throws OlapRoleAuthorizationException {
        this.assertApplicationEnabled("app.monitoring");
    }

    public boolean isMonitoringCountersEnabled() {
        return this.isApplicationFeatureEnabled("app.monitoring", "app.monitoring.counters");
    }

    public void assertMonitoringCountersEnabled() throws OlapRoleAuthorizationException {
        this.assertApplicationFeatureEnabled("app.monitoring", "app.monitoring.counters");
    }

    public boolean isMonitoringSchemasEnabled() {
        return this.isApplicationFeatureEnabled("app.monitoring", "app.monitoring.schemas");
    }

    public void assertMonitoringSchemasEnabled() throws OlapRoleAuthorizationException {
        this.assertApplicationFeatureEnabled("app.monitoring", "app.monitoring.schemas");
    }

    public boolean isMonitoringRequestsEnabled() {
        return this.isApplicationFeatureEnabled("app.monitoring", "app.monitoring.requests");
    }

    public void assertMonitoringRequestsEnabled() throws OlapRoleAuthorizationException {
        this.assertApplicationFeatureEnabled("app.monitoring", "app.monitoring.requests");
    }

    public boolean isMonitoringUsersEnabled() {
        return this.isApplicationFeatureEnabled("app.monitoring", "app.monitoring.users");
    }

    public void assertMonitoringUsersEnabled() throws OlapRoleAuthorizationException {
        this.assertApplicationFeatureEnabled("app.monitoring", "app.monitoring.users");
    }

    public boolean isMonitoringRolesEnabled() {
        return this.isApplicationFeatureEnabled("app.monitoring", "app.monitoring.roles");
    }

    public void assertMonitoringRolesEnabled() throws OlapRoleAuthorizationException {
        this.assertApplicationFeatureEnabled("app.monitoring", "app.monitoring.roles");
    }

    public boolean isMonitoringPluginsEnabled() {
        return this.isApplicationFeatureEnabled("app.monitoring", "app.monitoring.plugins");
    }

    public void assertMonitoringPluginsEnabled() throws OlapRoleAuthorizationException {
        this.assertApplicationFeatureEnabled("app.monitoring", "app.monitoring.plugins");
    }

    public boolean isMonitoringServicesEnabled() {
        return this.isApplicationFeatureEnabled("app.monitoring", "app.monitoring.services");
    }

    public void assertMonitoringServicesEnabled() throws OlapRoleAuthorizationException {
        this.assertApplicationFeatureEnabled("app.monitoring", "app.monitoring.services");
    }

    public boolean isMonitoringConfigurationEnabled() {
        return this.isApplicationFeatureEnabled("app.monitoring", "app.monitoring.configuration");
    }

    public void assertMonitoringConfigurationEnabled() throws OlapRoleAuthorizationException {
        this.assertApplicationFeatureEnabled("app.monitoring", "app.monitoring.configuration");
    }

    public boolean isAlertEnabled() {
        return this.isApplicationEnabled("app.alert");
    }

    public void assertAlertEnabled() throws OlapRoleAuthorizationException {
        this.assertApplicationEnabled("app.alert");
    }

    public boolean isBuilderEnabled() {
        return this.isApplicationEnabled("app.builder");
    }

    public void assertBuilderEnabled() throws OlapRoleAuthorizationException {
        this.assertApplicationEnabled("app.builder");
    }

    public boolean isMdxIdeEnabled() {
        return this.isApplicationEnabled("app.mdxIde");
    }

    public void assertMdxIdeEnabled() throws OlapRoleAuthorizationException {
        this.assertApplicationEnabled("app.mdxIde");
    }

    public boolean isReportDocManagementEnabled() {
        return this.isApplicationEnabled("app.reportDocManagement");
    }

    public void assertReportDocManagementEnabled() throws OlapRoleAuthorizationException {
        this.assertApplicationEnabled("app.reportDocManagement");
    }

    public boolean isReportDocManagementReaderEnabled() {
        return this.isReportDocManagementEditorEnabled() || this.isReportDocManagementAdministratorEnabled() || this.isApplicationFeatureEnabled("app.reportDocManagement", "app.reportDocManagement.reader");
    }

    public void assertReportDocManagementReaderEnabled() throws OlapRoleAuthorizationException {
        if (!this.isReportDocManagementReaderEnabled()) {
            throw new OlapRoleAuthorizationApplicationFeatureException("app.reportDocManagement", "app.reportDocManagement.reader");
        }
    }

    public boolean isReportDocManagementEditorEnabled() {
        return this.isReportDocManagementAdministratorEnabled() || this.isApplicationFeatureEnabled("app.reportDocManagement", "app.reportDocManagement.editor");
    }

    public void assertReportDocManagementEditorEnabled() throws OlapRoleAuthorizationException {
        if (!this.isReportDocManagementEditorEnabled()) {
            throw new OlapRoleAuthorizationApplicationFeatureException("app.reportDocManagement", "app.reportDocManagement.editor");
        }
    }

    public boolean isReportDocManagementAdministratorEnabled() {
        return this.isApplicationFeatureEnabled("app.reportDocManagement", "app.reportDocManagement.administrator");
    }

    public void assertReportDocManagementAdministratorEnabled() throws OlapRoleAuthorizationException {
        this.assertApplicationFeatureEnabled("app.reportDocManagement", "app.reportDocManagement.administrator");
    }

    public void assertReportDocManagementWriterEnabled() throws OlapRoleAuthorizationException {
        if (!(this.fullControl || this.isReportDocManagementEditorEnabled() || this.isReportDocManagementAdministratorEnabled())) {
            this.assertApplicationFeatureEnabled("app.reportDocManagement", "app.reportDocManagement.editor");
        }
    }

    public boolean isReportDashboardReaderEnabled() {
        if (this.fullControl) {
            return true;
        }
        String appName = "app.reportDashboard";
        OlapRoleApplicationFeaturePermissions app = this.getExistingApplication("app.reportDashboard");
        List<String> features = app.getAuthorizedFeatureNames();
        return !features.isEmpty();
    }

    public void assertReportDashboardReaderEnabled() throws OlapRoleAuthorizationException {
        String appName = "app.reportDashboard";
        if (!this.isReportDashboardReaderEnabled()) {
            throw new OlapRoleAuthorizationApplicationFeatureException("app.reportDashboard", "app.reportDashboard.reader");
        }
    }

    public void assertReportDashboardWriterEnabled() throws OlapRoleAuthorizationException {
        boolean enabled;
        String appName = "app.reportDashboard";
        boolean readerSave = this.isApplicationFeatureEnabled("app.reportDashboard", "app.reportDashboard.readerSave");
        boolean editor = this.isApplicationFeatureEnabled("app.reportDashboard", "app.reportDashboard.editor");
        boolean bl = enabled = this.fullControl || readerSave || editor;
        if (!enabled) {
            throw new OlapRoleAuthorizationApplicationFeatureException("app.reportDashboard", "app.reportDashboard.editor");
        }
    }

    public boolean isReportGadgetWriterEnabled(boolean isForRename) {
        String appName = "app.reportGadget";
        if (isForRename) {
            return false;
        }
        return this.fullControl || this.isApplicationFeatureEnabled("app.reportGadget", "app.reportGadget.writer");
    }

    public void assertReportGadgetWriterEnabled(boolean isForRename) throws OlapRoleAuthorizationException {
        String appName = "app.reportGadget";
        if (!this.isReportGadgetWriterEnabled(isForRename)) {
            throw new OlapRoleAuthorizationApplicationFeatureException("app.reportGadget", "app.reportGadget.writer");
        }
    }

    public boolean isReportDashboardApplicationWriterEnabled(boolean isForCreate) {
        String appName = "app.reportDashboardApplication";
        if (isForCreate) {
            return this.fullControl || this.isApplicationFeatureEnabled("app.reportDashboardApplication", "app.reportDashboardApplication.writer");
        }
        return this.fullControl || this.isApplicationFeatureEnabled("app.reportDashboardApplication", "app.reportDashboardApplication.writer") || this.isApplicationFeatureEnabled("app.reportDashboardApplication", "app.reportDashboardApplication.writer_limited");
    }

    public void assertReportDashboardApplicationWriterEnabled(boolean isForCreate) throws OlapRoleAuthorizationException {
        String appName = "app.reportDashboardApplication";
        if (!this.isReportDashboardApplicationWriterEnabled(isForCreate)) {
            throw new OlapRoleAuthorizationApplicationFeatureException("app.reportDashboardApplication", "app.reportDashboardApplication.writer");
        }
    }

    public boolean isReportDashboardApplicationCreateEnabled() {
        String appName = "app.reportDashboardApplication";
        return this.fullControl || this.isApplicationFeatureEnabled("app.reportDashboardApplication", "app.reportDashboardApplication.writer");
    }

    public void assertReportDashboardApplicationCreatedEnabled() throws OlapRoleAuthorizationException {
        String appName = "app.reportDashboardApplication";
        if (!this.isReportDashboardApplicationCreateEnabled()) {
            throw new OlapRoleAuthorizationApplicationFeatureException("app.reportDashboardApplication", "app.reportDashboardApplication.writer");
        }
    }

    public boolean isReportDashboardDataSourcesWriterEnabled() {
        String appName = "app.reportDashboardDataSources";
        return this.isApplicationEnabled("app.reportDashboardDataSources");
    }

    public boolean isXmlaEnabled() {
        return this.isApplicationEnabled("app.xmla");
    }

    public void assertXmlaEnabled() throws OlapRoleAuthorizationException {
        this.assertApplicationEnabled("app.xmla");
    }

    public boolean isGviEnabled() {
        return this.isApplicationEnabled("app.gvi");
    }

    public void assertGviEnabled() throws OlapRoleAuthorizationException {
        this.assertApplicationEnabled("app.gvi");
    }

    public boolean isUxEnabled() {
        return this.isApplicationEnabled("app.ux");
    }

    public void assertUxEnabled() throws OlapRoleAuthorizationException {
        this.assertApplicationEnabled("app.ux");
    }

    public String getDashboardJavascriptInfo() {
        if (this.fullControl) {
            return "editor";
        }
        OlapRoleApplicationFeaturePermissions perms = this.getExistingApplication("app.reportDashboard");
        List<String> features = perms.getAuthorizedFeatureNames();
        if (!features.isEmpty()) {
            String feature = features.get(0);
            if ("app.reportDashboard.reader".equals(feature)) {
                return "reader";
            }
            if ("app.reportDashboard.readerSave".equals(feature)) {
                return "readerSave";
            }
            if ("app.reportDashboard.editorReader".equals(feature)) {
                return "editorReader";
            }
            if ("app.reportDashboard.editor".equals(feature)) {
                return "editor";
            }
            throw new CdProgrammingException("internal error : unsupported dashboards feature [" + feature + "]");
        }
        return "";
    }

    public String getGadgetJavascriptInfo() {
        if (this.fullControl) {
            return "writer";
        }
        OlapRoleApplicationFeaturePermissions perms = this.getExistingApplication("app.reportGadget");
        List<String> features = perms.getAuthorizedFeatureNames();
        if (!features.isEmpty()) {
            String feature = features.get(0);
            if ("app.reportGadget.writer".equals(feature)) {
                return "writer";
            }
            throw new CdProgrammingException("internal error : unsupported gadget feature [" + feature + "]");
        }
        return "";
    }

    public String getDashboardApplicationJavascriptInfo() {
        if (this.fullControl) {
            return "writer";
        }
        OlapRoleApplicationFeaturePermissions perms = this.getExistingApplication("app.reportDashboardApplication");
        List<String> features = perms.getAuthorizedFeatureNames();
        if (!features.isEmpty()) {
            String feature = features.get(0);
            if ("app.reportDashboardApplication.writer_limited".equals(feature)) {
                return "writer_limited";
            }
            if ("app.reportDashboardApplication.writer".equals(feature)) {
                return "writer";
            }
            throw new CdProgrammingException("internal error : unsupported dashboards application feature [" + feature + "]");
        }
        return "";
    }

    public String getDashboardDataSourcesJavascriptInfo() {
        if (this.fullControl) {
            return "writer";
        }
        OlapRoleApplicationFeaturePermissions perms = this.getExistingApplication("app.reportDashboardDataSources");
        List<String> features = perms.getAuthorizedFeatureNames();
        if (!features.isEmpty()) {
            String feature = features.get(0);
            if ("app.reportDashboardDataSources.writer".equals(feature)) {
                return "writer";
            }
            throw new CdProgrammingException("internal error : unsupported dashboards data-sources feature [" + feature + "]");
        }
        return "";
    }

    private boolean isApplicationEnabled(String applicationName) {
        if (this.fullControl) {
            return true;
        }
        OlapRoleApplicationFeaturePermissions application = this.getExistingApplication(applicationName);
        return !application.getAuthorizedFeatureNames().isEmpty();
    }

    private void assertApplicationEnabled(String applicationName) throws OlapRoleAuthorizationException {
        if (!this.isApplicationEnabled(applicationName)) {
            throw new OlapRoleAuthorizationApplicationException(applicationName);
        }
    }

    private boolean isApplicationFeatureEnabled(String applicationName, String featureName) {
        if (this.fullControl) {
            return true;
        }
        OlapRoleApplicationFeaturePermissions application = this.getExistingApplication(applicationName);
        return application.getAuthorizedFeatureNames().contains(featureName);
    }

    private void assertApplicationFeatureEnabled(String applicationName, String featureName) throws OlapRoleAuthorizationException {
        if (!this.isApplicationFeatureEnabled(applicationName, featureName)) {
            throw new OlapRoleAuthorizationApplicationFeatureException(applicationName, featureName);
        }
    }

    private OlapRoleApplicationFeaturePermissions getExistingApplication(String applicationName) {
        for (OlapRoleApplicationFeaturePermissions application : this.applications) {
            if (!application.getAppName().equals(applicationName)) continue;
            return application;
        }
        OlapLoggers.AUTHORIZATION.error((Object)("application   dbg : " + this.debug));
        OlapLoggers.AUTHORIZATION.error((Object)("application count : " + this.applications.size()));
        for (OlapRoleApplicationFeaturePermissions application : this.applications) {
            OlapLoggers.AUTHORIZATION.error((Object)("application       : " + application.getAppName()));
        }
        throw new CdProgrammingException("missing application [" + applicationName + "] permission");
    }

    public boolean isBigBrotherEnabled() {
        return this.isMonitoringCountersEnabled();
    }
}

