/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.definition.schema;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.iccube.authorization.definition.common.IOlapRoleConstraintDefaultValueDefinition;
import crazydev.iccube.authorization.definition.common.IOlapRoleNamedDefinition;
import crazydev.iccube.authorization.definition.common.OlapRoleAccessDefinition;
import crazydev.iccube.authorization.definition.common.OlapRoleEntityListTypeDefinition;
import crazydev.iccube.authorization.definition.cube.OlapRoleCubeDefinition;
import crazydev.iccube.authorization.definition.cube.OlapRoleCubeEntityListDefinition;
import crazydev.iccube.authorization.definition.cube.OlapRolePerspectiveEntityListDefinition;
import crazydev.iccube.authorization.definition.dimension.OlapRoleDimensionDefinition;
import crazydev.iccube.authorization.definition.dimension.OlapRoleDimensionEntityListDefinition;
import crazydev.iccube.authorization.definition.schema.OlapRoleSchemasDefinition;
import crazydev.iccube.authorization.validation.common.IOlapRoleDefinitionValidationEnabled;
import crazydev.iccube.authorization.validation.common.OlapRoleDefinitionValidationContext;
import crazydev.iccube.authorization.validation.schema.OlapRoleSchemaDefinitionValidator;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import crazydev.iccube.validation.OlapValidator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="schema")
public class OlapRoleSchemaDefinition
implements IOlapRoleDefinitionValidationEnabled<OlapRoleSchemasDefinition, OlapRoleSchemaDefinition>,
IOlapRoleConstraintDefaultValueDefinition,
IOlapRoleNamedDefinition {
    public static final CdProperty NAME = new CdReadWriteProperty(OlapRoleSchemaDefinition.class, "name");
    public static final CdProperty ACCESS = new CdReadWriteProperty(OlapRoleSchemaDefinition.class, "access");
    public static final CdProperty AUTHORIZED_DATA_SOURCES = new CdReadWriteProperty(OlapRoleSchemaDefinition.class, "authorizedReportingDatasources", CdProperty.Access.METHOD);
    public static final CdProperty AUTHORIZED_DIMENSION_NAMES = new CdReadWriteProperty(OlapRoleSchemaDefinition.class, "authorizedDimensionNames");
    public static final CdProperty AUTHORIZED_CUBE_NAMES = new CdReadWriteProperty(OlapRoleSchemaDefinition.class, "authorizedCubeNames");
    public static final CdProperty AUTHORIZED_PERSPECTIVE_NAMES = new CdReadWriteProperty(OlapRoleSchemaDefinition.class, "authorizedPerspectiveNames");
    @XmlAttribute(name="name", required=true)
    @Nullable
    private String name;
    @XmlAttribute(name="access")
    @Nullable
    private OlapRoleAccessDefinition access;
    @XmlElement(name="authorizedReportingDatasources", required=false)
    private Boolean authorizedReportingDatasources;
    @XmlElement(name="authorizedDimensionNames", required=true)
    @Nullable
    private OlapRoleDimensionEntityListDefinition authorizedDimensionNames;
    @XmlElement(name="dimension", required=false)
    @Nullable
    private List<OlapRoleDimensionDefinition> dimensionPermissions;
    @XmlElement(name="authorizedCubeNames", required=true)
    @Nullable
    private OlapRoleCubeEntityListDefinition authorizedCubeNames;
    @XmlElement(name="cube", required=false)
    @Nullable
    private List<OlapRoleCubeDefinition> cubePermissions;
    @XmlElement(name="authorizedPerspectiveNames", required=false)
    @Nullable
    private OlapRolePerspectiveEntityListDefinition authorizedPerspectiveNames;

    public OlapRoleSchemaDefinition() {
    }

    public OlapRoleSchemaDefinition(String name) {
        this.name = name;
    }

    public OlapRoleSchemaDefinition(String name, @Nullable OlapRoleAccessDefinition access) {
        this.name = name;
        this.access = access;
        this.authorizedDimensionNames = new OlapRoleDimensionEntityListDefinition(OlapRoleEntityListTypeDefinition.ALL, new String[0]);
        this.authorizedCubeNames = new OlapRoleCubeEntityListDefinition(OlapRoleEntityListTypeDefinition.ALL, new String[0]);
        this.authorizedPerspectiveNames = new OlapRolePerspectiveEntityListDefinition(OlapRoleEntityListTypeDefinition.ALL, new String[0]);
    }

    public OlapRoleSchemaDefinition(String name, @Nullable OlapRoleAccessDefinition access, @Nullable Boolean authorizedReportingDatasources) {
        this.name = name;
        this.access = access;
        this.authorizedReportingDatasources = authorizedReportingDatasources;
        this.authorizedDimensionNames = new OlapRoleDimensionEntityListDefinition(OlapRoleEntityListTypeDefinition.ALL, new String[0]);
        this.authorizedCubeNames = new OlapRoleCubeEntityListDefinition(OlapRoleEntityListTypeDefinition.ALL, new String[0]);
        this.authorizedPerspectiveNames = new OlapRolePerspectiveEntityListDefinition(OlapRoleEntityListTypeDefinition.ALL, new String[0]);
    }

    public OlapRoleSchemaDefinition(String name, OlapRoleDimensionEntityListDefinition authorizedDimensionNames) {
        this.name = name;
        this.access = null;
        this.authorizedReportingDatasources = null;
        this.authorizedDimensionNames = authorizedDimensionNames;
        this.authorizedCubeNames = new OlapRoleCubeEntityListDefinition(OlapRoleEntityListTypeDefinition.ALL, new String[0]);
        this.authorizedPerspectiveNames = new OlapRolePerspectiveEntityListDefinition(OlapRoleEntityListTypeDefinition.ALL, new String[0]);
    }

    public OlapRoleSchemaDefinition(String name, OlapRoleDimensionEntityListDefinition authorizedDimensionNames, OlapRoleDimensionDefinition dimension) {
        this.name = name;
        this.access = null;
        this.authorizedReportingDatasources = null;
        this.authorizedDimensionNames = authorizedDimensionNames;
        this.authorizedCubeNames = new OlapRoleCubeEntityListDefinition(OlapRoleEntityListTypeDefinition.ALL, new String[0]);
        this.authorizedPerspectiveNames = new OlapRolePerspectiveEntityListDefinition(OlapRoleEntityListTypeDefinition.ALL, new String[0]);
        this.dimensionPermissions = new ArrayList<OlapRoleDimensionDefinition>();
        this.dimensionPermissions.add(dimension);
    }

    public OlapRoleSchemaDefinition(String name, OlapRoleCubeEntityListDefinition authorizedCubeNames) {
        this.name = name;
        this.access = null;
        this.authorizedReportingDatasources = null;
        this.authorizedDimensionNames = new OlapRoleDimensionEntityListDefinition(OlapRoleEntityListTypeDefinition.ALL, new String[0]);
        this.authorizedCubeNames = authorizedCubeNames;
        this.authorizedPerspectiveNames = new OlapRolePerspectiveEntityListDefinition(OlapRoleEntityListTypeDefinition.ALL, new String[0]);
    }

    public OlapRoleSchemaDefinition(String name, OlapRoleCubeEntityListDefinition authorizedCubeNames, OlapRoleCubeDefinition cube) {
        this.name = name;
        this.access = null;
        this.authorizedReportingDatasources = null;
        this.authorizedDimensionNames = new OlapRoleDimensionEntityListDefinition(OlapRoleEntityListTypeDefinition.ALL, new String[0]);
        this.authorizedCubeNames = authorizedCubeNames;
        this.authorizedPerspectiveNames = new OlapRolePerspectiveEntityListDefinition(OlapRoleEntityListTypeDefinition.ALL, new String[0]);
        this.cubePermissions = new ArrayList<OlapRoleCubeDefinition>();
        this.cubePermissions.add(cube);
    }

    public OlapRoleSchemaDefinition(@Nullable String name, @Nullable OlapRolePerspectiveEntityListDefinition authorizedPerspectiveNames) {
        this.name = name;
        this.access = null;
        this.authorizedReportingDatasources = null;
        this.authorizedDimensionNames = new OlapRoleDimensionEntityListDefinition(OlapRoleEntityListTypeDefinition.ALL, new String[0]);
        this.authorizedCubeNames = new OlapRoleCubeEntityListDefinition(OlapRoleEntityListTypeDefinition.ALL, new String[0]);
        this.authorizedPerspectiveNames = authorizedPerspectiveNames;
    }

    @Override
    public void setupConstrainedDefaultValues(@Nullable Object owner) {
        if (owner instanceof OlapRoleSchemasDefinition) {
            OlapRoleSchemasDefinition schemas = (OlapRoleSchemasDefinition)owner;
            OlapRoleAccessDefinition ownerAccess = schemas.getDefaultAccess();
            if (ownerAccess == null) {
                this.access = OlapRoleAccessDefinition.READ;
            } else {
                switch (ownerAccess) {
                    case READ: {
                        this.access = OlapRoleAccessDefinition.READ;
                        break;
                    }
                    case WRITE: {
                        this.access = OlapRoleAccessDefinition.WRITE;
                    }
                }
            }
        }
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public OlapRoleAccessDefinition getAccess() {
        return this.access;
    }

    public void setAccess(OlapRoleAccessDefinition access) {
        this.access = access;
    }

    public boolean isAuthorizedReportingDatasources() {
        return this.authorizedReportingDatasources != null ? this.authorizedReportingDatasources : true;
    }

    public void setAuthorizedReportingDatasources(boolean authorizedReportingDatasources) {
        this.authorizedReportingDatasources = authorizedReportingDatasources;
    }

    @Nullable
    public OlapRoleDimensionEntityListDefinition getAuthorizedDimensionNames() {
        return this.authorizedDimensionNames;
    }

    public void setAuthorizedDimensionNames(OlapRoleDimensionEntityListDefinition authorizedDimensionNames) {
        this.authorizedDimensionNames = authorizedDimensionNames;
    }

    public OlapRoleDimensionEntityListDefinition getValidatedAuthorizedDimensionNames() {
        if (this.authorizedDimensionNames == null) {
            throw new CdProgrammingException("internal error: missing authorized dimension names");
        }
        return this.authorizedDimensionNames;
    }

    @Nullable
    public List<OlapRoleDimensionDefinition> getDimensionPermissions() {
        return this.dimensionPermissions;
    }

    public void addDimensionPermission(OlapRoleDimensionDefinition permission) {
        if (this.dimensionPermissions == null) {
            this.dimensionPermissions = new ArrayList<OlapRoleDimensionDefinition>();
        }
        this.dimensionPermissions.add(permission);
    }

    public boolean removeDimensionPermission(OlapRoleDimensionDefinition definition) {
        return this.dimensionPermissions != null && this.dimensionPermissions.remove(definition);
    }

    @Nullable
    public OlapRoleDimensionDefinition getDimensionPermission(String dimensionName) {
        if (this.dimensionPermissions != null) {
            for (OlapRoleDimensionDefinition dimensionPermission : this.dimensionPermissions) {
                String dimensionPermissionName = dimensionPermission.getName();
                if (dimensionPermissionName == null || !OlapCaseInsensitiveName.equals(dimensionPermissionName, dimensionName)) continue;
                return dimensionPermission;
            }
        }
        return null;
    }

    @Nullable
    public OlapRoleCubeEntityListDefinition getAuthorizedCubeNames() {
        return this.authorizedCubeNames;
    }

    public void setAuthorizedCubeNames(OlapRoleCubeEntityListDefinition authorizedCubeNames) {
        this.authorizedCubeNames = authorizedCubeNames;
    }

    public OlapRoleCubeEntityListDefinition getValidatedAuthorizedCubeNames() {
        if (this.authorizedCubeNames == null) {
            throw new CdProgrammingException("internal error: missing authorized cube names");
        }
        return this.authorizedCubeNames;
    }

    @Nullable
    public List<OlapRoleCubeDefinition> getCubePermissions() {
        return this.cubePermissions;
    }

    public void addCubePermission(OlapRoleCubeDefinition definition) {
        if (this.cubePermissions == null) {
            this.cubePermissions = new ArrayList<OlapRoleCubeDefinition>();
        }
        this.cubePermissions.add(definition);
    }

    public boolean removeCubePermission(OlapRoleCubeDefinition definition) {
        return this.cubePermissions != null && this.cubePermissions.remove(definition);
    }

    @Nullable
    public OlapRoleCubeDefinition getCubePermission(String cubeName) {
        if (this.cubePermissions != null) {
            for (OlapRoleCubeDefinition cubePermission : this.cubePermissions) {
                String cubePermissionName = cubePermission.getName();
                if (cubePermissionName == null || !OlapCaseInsensitiveName.equals(cubePermissionName, cubeName)) continue;
                return cubePermission;
            }
        }
        return null;
    }

    public OlapRolePerspectiveEntityListDefinition getAuthorizedPerspectiveNames() {
        if (this.authorizedPerspectiveNames == null) {
            return new OlapRolePerspectiveEntityListDefinition(OlapRoleEntityListTypeDefinition.ALL, new String[0]);
        }
        return this.authorizedPerspectiveNames;
    }

    public void setAuthorizedPerspectiveNames(OlapRolePerspectiveEntityListDefinition authorizedPerspectiveNames) {
        this.authorizedPerspectiveNames = authorizedPerspectiveNames;
    }

    public OlapRolePerspectiveEntityListDefinition getValidatedAuthorizedPerspectivesNames() {
        if (this.authorizedPerspectiveNames == null) {
            return new OlapRolePerspectiveEntityListDefinition(OlapRoleEntityListTypeDefinition.ALL, new String[0]);
        }
        return this.authorizedPerspectiveNames;
    }

    @Override
    public OlapValidator<OlapRoleDefinitionValidationContext, OlapRoleSchemasDefinition, OlapRoleSchemaDefinition> getValidator() {
        return new OlapRoleSchemaDefinitionValidator();
    }

    @Override
    public String getContextVisualId() {
        return String.valueOf(this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlapRoleSchemaDefinition that = (OlapRoleSchemaDefinition)o;
        if (this.access != that.access) {
            return false;
        }
        if (this.authorizedPerspectiveNames != null ? !this.authorizedPerspectiveNames.equals(that.authorizedPerspectiveNames) : that.authorizedPerspectiveNames != null) {
            return false;
        }
        if (this.authorizedCubeNames != null ? !this.authorizedCubeNames.equals(that.authorizedCubeNames) : that.authorizedCubeNames != null) {
            return false;
        }
        if (this.authorizedDimensionNames != null ? !this.authorizedDimensionNames.equals(that.authorizedDimensionNames) : that.authorizedDimensionNames != null) {
            return false;
        }
        if (this.cubePermissions != null ? !this.cubePermissions.equals(that.cubePermissions) : that.cubePermissions != null) {
            return false;
        }
        if (this.dimensionPermissions != null ? !this.dimensionPermissions.equals(that.dimensionPermissions) : that.dimensionPermissions != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.access != null ? this.access.hashCode() : 0);
        result = 31 * result + (this.authorizedDimensionNames != null ? this.authorizedDimensionNames.hashCode() : 0);
        result = 31 * result + (this.dimensionPermissions != null ? this.dimensionPermissions.hashCode() : 0);
        result = 31 * result + (this.authorizedCubeNames != null ? this.authorizedCubeNames.hashCode() : 0);
        result = 31 * result + (this.cubePermissions != null ? this.cubePermissions.hashCode() : 0);
        result = 31 * result + (this.authorizedPerspectiveNames != null ? this.authorizedPerspectiveNames.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.name == null ? "<null>" : this.name;
    }
}

