/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.definition.role;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.repository.CdXmlBean;
import crazydev.iccube.authorization.definition.role.OlapRoleDefinition;
import crazydev.iccube.authorization.validation.common.IOlapRoleDefinitionValidationEnabled;
import crazydev.iccube.authorization.validation.common.OlapRoleDefinitionValidationContext;
import crazydev.iccube.authorization.validation.role.OlapRoleDefinitionsValidator;
import crazydev.iccube.validation.OlapValidator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="roles")
public class OlapRoleDefinitions
implements Iterable<OlapRoleDefinition>,
IOlapRoleDefinitionValidationEnabled<IOlapRoleDefinitionValidationEnabled, OlapRoleDefinitions>,
CdXmlBean {
    public static final String FILE_ENCODING = "UTF-8";
    public static final String FILE_EXTENSION = "icc-roles";
    public static final String FILE_EXTENSION_X = ".icc-roles";
    public static final String FILE_NAME = "icCubeRoles";
    public static final String FULL_FILE_NAME = "icCubeRoles.icc-roles";
    @XmlTransient
    @Nullable
    protected File xmlFile;
    @XmlAttribute(name="revisionNumber", required=true)
    private int revisionNumber;
    @XmlAttribute(name="version", required=false)
    @Nullable
    private Integer version;
    @XmlElement(name="role", required=false)
    @Nullable
    private List<OlapRoleDefinition> roleDefinitions;

    @Nullable
    public File getXmlFile() {
        return this.xmlFile;
    }

    @XmlTransient
    public void setXmlFile(File xmlFile) {
        this.xmlFile = xmlFile;
    }

    public String getName() {
        return FILE_NAME;
    }

    @Nullable
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(@Nullable Integer version) {
        this.version = version;
    }

    public void clear() {
        this.roleDefinitions = null;
    }

    public boolean isEmpty() {
        return this.roleDefinitions == null || this.roleDefinitions.isEmpty();
    }

    @Override
    public Iterator<OlapRoleDefinition> iterator() {
        return this.roleDefinitions == null ? Collections.emptyList().iterator() : this.roleDefinitions.iterator();
    }

    @Nullable
    public OlapRoleDefinition getRoleDefinition(String roleName) {
        if (this.roleDefinitions == null) {
            return null;
        }
        for (OlapRoleDefinition roleDefinition : this.roleDefinitions) {
            String name = roleDefinition.getName();
            if (name == null || !name.equals(roleName)) continue;
            return roleDefinition;
        }
        return null;
    }

    @Nullable
    public List<OlapRoleDefinition> getRoleDefinitions() {
        return this.roleDefinitions;
    }

    public void setRoleDefinitions(@Nullable List<OlapRoleDefinition> roleDefinitions) {
        this.roleDefinitions = roleDefinitions;
    }

    public List<OlapRoleDefinition> getValidatedRoleDefinitions() {
        if (this.roleDefinitions == null) {
            throw new CdProgrammingException("internal error: missing role permissions");
        }
        return this.roleDefinitions;
    }

    public void addRoleDefinition(OlapRoleDefinition roleDefinition) {
        if (this.roleDefinitions == null) {
            this.roleDefinitions = new ArrayList<OlapRoleDefinition>();
        }
        this.roleDefinitions.add(roleDefinition);
    }

    public void replaceRoleDefinition(OlapRoleDefinition role) {
        if (this.roleDefinitions == null) {
            this.roleDefinitions = new ArrayList<OlapRoleDefinition>();
            this.roleDefinitions.add(role);
            return;
        }
        int pos = -1;
        for (int ii = 0; ii < this.roleDefinitions.size(); ++ii) {
            OlapRoleDefinition roleDefinition = this.roleDefinitions.get(ii);
            String uuid = roleDefinition.getUUID();
            if (uuid == null || !uuid.equals(role.getUUID())) continue;
            pos = ii;
            break;
        }
        if (pos == -1) {
            this.roleDefinitions.add(role);
        } else {
            this.roleDefinitions.set(pos, role);
        }
    }

    public boolean deleteRoleDefinition(OlapRoleDefinition roleDefinition) {
        if (this.roleDefinitions == null) {
            return false;
        }
        return this.roleDefinitions.remove(roleDefinition);
    }

    @Override
    public OlapValidator<OlapRoleDefinitionValidationContext, IOlapRoleDefinitionValidationEnabled, OlapRoleDefinitions> getValidator() {
        return new OlapRoleDefinitionsValidator();
    }

    @Override
    public String getContextVisualId() {
        return this.xmlFile == null ? "null" : this.xmlFile.getName();
    }

    public OlapRoleDefinitions fixForPredefinedRoles() {
        if (this.roleDefinitions != null && !this.roleDefinitions.isEmpty()) {
            ArrayList<OlapRoleDefinition> newRoleDefinitions = new ArrayList<OlapRoleDefinition>();
            for (OlapRoleDefinition roleDefinition : this.roleDefinitions) {
                if (roleDefinition == null || "administrator".equals(roleDefinition.getName()) || "administrator-print".equals(roleDefinition.getName())) continue;
                newRoleDefinitions.add(roleDefinition);
            }
            this.roleDefinitions = newRoleDefinitions;
        }
        return this;
    }
}

