/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.definition.dimension;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.iccube.authorization.definition.common.IOlapRoleNamedDefinition;
import crazydev.iccube.authorization.definition.common.OlapRoleEntityListTypeDefinition;
import crazydev.iccube.authorization.definition.hierarchy.OlapRoleHierarchyDefinition;
import crazydev.iccube.authorization.definition.hierarchy.OlapRoleHierarchyEntityListDefinition;
import crazydev.iccube.authorization.definition.schema.OlapRoleSchemaDefinition;
import crazydev.iccube.authorization.validation.common.IOlapRoleDefinitionValidationEnabled;
import crazydev.iccube.authorization.validation.common.OlapRoleDefinitionValidationContext;
import crazydev.iccube.authorization.validation.dimension.OlapRoleDimensionDefinitionValidator;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import crazydev.iccube.validation.OlapValidator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="dimension")
public class OlapRoleDimensionDefinition
implements IOlapRoleDefinitionValidationEnabled<OlapRoleSchemaDefinition, OlapRoleDimensionDefinition>,
IOlapRoleNamedDefinition {
    public static final CdProperty NAME = new CdReadWriteProperty(OlapRoleDimensionDefinition.class, "name");
    public static final CdProperty AUTHORIZED_HIERARCHY_NAMES = new CdReadWriteProperty(OlapRoleDimensionDefinition.class, "authorizedHierarchyNames");
    @XmlAttribute(name="name", required=true)
    @Nullable
    private String name;
    @XmlElement(name="authorizedHierarchyNames", required=true)
    @Nullable
    private OlapRoleHierarchyEntityListDefinition authorizedHierarchyNames;
    @XmlElement(name="hierarchy", required=false)
    @Nullable
    private List<OlapRoleHierarchyDefinition> hierarchyPermissions;

    public OlapRoleDimensionDefinition() {
    }

    public OlapRoleDimensionDefinition(String name) {
        this.name = name;
        this.authorizedHierarchyNames = new OlapRoleHierarchyEntityListDefinition(OlapRoleEntityListTypeDefinition.ALL, new String[0]);
    }

    public OlapRoleDimensionDefinition(@Nullable String name, @Nullable OlapRoleHierarchyEntityListDefinition authorizedHierarchyNames) {
        this.name = name;
        this.authorizedHierarchyNames = authorizedHierarchyNames;
    }

    public OlapRoleDimensionDefinition(@Nullable String name, @Nullable OlapRoleHierarchyEntityListDefinition authorizedHierarchyNames, OlapRoleHierarchyDefinition hierarchy) {
        this.name = name;
        this.authorizedHierarchyNames = authorizedHierarchyNames;
        this.hierarchyPermissions = new ArrayList<OlapRoleHierarchyDefinition>();
        this.hierarchyPermissions.add(hierarchy);
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public OlapRoleHierarchyEntityListDefinition getAuthorizedHierarchyNames() {
        return this.authorizedHierarchyNames;
    }

    public OlapRoleHierarchyEntityListDefinition getValidatedAuthorizedHierarchyNames() {
        if (this.authorizedHierarchyNames == null) {
            throw new CdProgrammingException("internal error: missing authorized hierarchy names");
        }
        return this.authorizedHierarchyNames;
    }

    public void setAuthorizedHierarchyNames(OlapRoleHierarchyEntityListDefinition authorizedHierarchyNames) {
        this.authorizedHierarchyNames = authorizedHierarchyNames;
    }

    @Nullable
    public List<OlapRoleHierarchyDefinition> getHierarchyPermissions() {
        return this.hierarchyPermissions;
    }

    @Nullable
    public OlapRoleHierarchyDefinition getHierarchyPermission(String hierarchyName) {
        if (this.hierarchyPermissions != null) {
            for (OlapRoleHierarchyDefinition hierarchyPermission : this.hierarchyPermissions) {
                String hierarchyPermissionName = hierarchyPermission.getName();
                if (hierarchyPermissionName == null || !OlapCaseInsensitiveName.equals(hierarchyPermissionName, hierarchyName)) continue;
                return hierarchyPermission;
            }
        }
        return null;
    }

    public void addHierarchyPermission(OlapRoleHierarchyDefinition definition) {
        if (this.hierarchyPermissions == null) {
            this.hierarchyPermissions = new ArrayList<OlapRoleHierarchyDefinition>();
        }
        this.hierarchyPermissions.add(definition);
    }

    public boolean removeHierarchyPermission(OlapRoleHierarchyDefinition definition) {
        return this.hierarchyPermissions != null && this.hierarchyPermissions.remove(definition);
    }

    @Override
    public OlapValidator<OlapRoleDefinitionValidationContext, OlapRoleSchemaDefinition, OlapRoleDimensionDefinition> getValidator() {
        return new OlapRoleDimensionDefinitionValidator();
    }

    @Override
    public String getContextVisualId() {
        return String.valueOf(this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlapRoleDimensionDefinition that = (OlapRoleDimensionDefinition)o;
        if (this.authorizedHierarchyNames != null ? !this.authorizedHierarchyNames.equals(that.authorizedHierarchyNames) : that.authorizedHierarchyNames != null) {
            return false;
        }
        if (this.hierarchyPermissions != null ? !this.hierarchyPermissions.equals(that.hierarchyPermissions) : that.hierarchyPermissions != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.authorizedHierarchyNames != null ? this.authorizedHierarchyNames.hashCode() : 0);
        result = 31 * result + (this.hierarchyPermissions != null ? this.hierarchyPermissions.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.name == null ? "<null>" : this.name;
    }
}

