/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.definition.application;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="feature")
public class OlapRoleApplicationFeatureDefinition {
    @XmlAttribute(name="name", required=true)
    @Nullable
    private String name;
    @XmlAttribute(name="enabled", required=true)
    private boolean enabled;

    public OlapRoleApplicationFeatureDefinition() {
    }

    public OlapRoleApplicationFeatureDefinition(String name, boolean enabled) {
        this.name = name;
        this.enabled = enabled;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void disable() {
        this.enabled = false;
    }

    public void fixForEdition(List<OlapRoleApplicationFeatureDefinition> persistentFeatures) {
        if (persistentFeatures != null) {
            for (OlapRoleApplicationFeatureDefinition persistentFeature : persistentFeatures) {
                String myName = this.name;
                if (myName == null || !myName.equals(persistentFeature.getName())) continue;
                this.enabled = persistentFeature.enabled;
                return;
            }
        }
        this.enabled = false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlapRoleApplicationFeatureDefinition that = (OlapRoleApplicationFeatureDefinition)o;
        if (this.enabled != that.enabled) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public OlapRoleApplicationFeatureDefinition copy() {
        return new OlapRoleApplicationFeatureDefinition(this.name, this.enabled);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.enabled ? 1 : 0);
        return result;
    }

    public String toString() {
        return (this.name == null ? "<null>" : this.name) + "(" + this.enabled + ")";
    }
}

