/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.definition.application;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.authorization.definition.application.OlapRoleApplicationFeatureDefinition;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class OlapRoleApplicationDefinition {
    @XmlElement(name="feature", required=true)
    @Nullable
    private List<OlapRoleApplicationFeatureDefinition> features;

    public OlapRoleApplicationDefinition() {
    }

    public OlapRoleApplicationDefinition(List<OlapRoleApplicationFeatureDefinition> features) {
        this.features = features;
    }

    public OlapRoleApplicationDefinition(OlapRoleApplicationFeatureDefinition ... features) {
        if (features != null) {
            ArrayList<OlapRoleApplicationFeatureDefinition> myFeatures = new ArrayList<OlapRoleApplicationFeatureDefinition>();
            for (OlapRoleApplicationFeatureDefinition feature : features) {
                myFeatures.add(feature);
            }
            this.features = myFeatures;
        }
    }

    public boolean isV7() {
        return false;
    }

    public String getGroupLocalizationTag() {
        return "app.ui";
    }

    public boolean isSingleSelectionFeature() {
        return false;
    }

    public abstract String getName();

    @Nullable
    public List<OlapRoleApplicationFeatureDefinition> getFeatures() {
        return this.features;
    }

    @Nullable
    public OlapRoleApplicationFeatureDefinition getFeature(String name) {
        if (this.features != null) {
            for (OlapRoleApplicationFeatureDefinition feature : this.features) {
                if (!name.equals(feature.getName())) continue;
                return feature;
            }
        }
        return null;
    }

    public List<OlapRoleApplicationFeatureDefinition> getValidatedFeatures() {
        if (this.features == null) {
            throw new CdProgrammingException("internal error: missing application features permissions");
        }
        return this.features;
    }

    public void setFeatures(@Nullable List<OlapRoleApplicationFeatureDefinition> features) {
        this.features = features;
    }

    public final OlapRoleApplicationDefinition createAsDisabled() {
        return this.create(this.createAllFeatures(false));
    }

    public final OlapRoleApplicationDefinition createAsEnabled() {
        return this.create(this.createAllFeatures(true));
    }

    protected abstract List<OlapRoleApplicationFeatureDefinition> createAllFeatures(boolean var1);

    public void fixForEdition(List<OlapRoleApplicationDefinition> persistentApplications) {
        if (persistentApplications != null) {
            for (OlapRoleApplicationDefinition persistentApplication : persistentApplications) {
                if (!this.getName().equals(persistentApplication.getName())) continue;
                List<OlapRoleApplicationFeatureDefinition> fixedFeatures = this.createAllFeatures(true);
                for (OlapRoleApplicationFeatureDefinition feature : fixedFeatures) {
                    feature.fixForEdition(persistentApplication.getFeatures());
                }
                this.features = fixedFeatures;
                return;
            }
        }
        this.features = this.createAllFeatures(true);
    }

    protected abstract OlapRoleApplicationDefinition create(List<OlapRoleApplicationFeatureDefinition> var1);

    public OlapRoleApplicationDefinition copy() {
        ArrayList<OlapRoleApplicationFeatureDefinition> clone = new ArrayList<OlapRoleApplicationFeatureDefinition>();
        if (this.features != null) {
            for (OlapRoleApplicationFeatureDefinition feature : this.features) {
                clone.add(feature.copy());
            }
        }
        return this.create(clone);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlapRoleApplicationDefinition that = (OlapRoleApplicationDefinition)o;
        return !(this.features != null ? !this.features.equals(that.features) : that.features != null);
    }

    public int hashCode() {
        return this.features != null ? this.features.hashCode() : 0;
    }

    public String toString() {
        return (this.getName() == null ? "<null>" : this.getName()) + " : " + String.valueOf(this.features == null ? "<null>" : this.features);
    }
}

