/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authentication.validation.user;

import crazydev.iccube.authentication.definition.OlapUserDefinition;
import crazydev.iccube.authentication.definition.OlapUserDefinitions;
import crazydev.iccube.authentication.errors.OlapUserDefinitionErrorCode;
import crazydev.iccube.authentication.validation.common.IOlapUserDefinitionValidationEnabled;
import crazydev.iccube.authentication.validation.common.OlapUserAbstractDefinitionValidator;
import crazydev.iccube.authentication.validation.common.OlapUserDefinitionValidationContext;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapUserDefinitionsValidator
extends OlapUserAbstractDefinitionValidator<IOlapUserDefinitionValidationEnabled, OlapUserDefinitions> {
    @Override
    protected void doValidate(OlapUserDefinitionValidationContext context, @Nullable IOlapUserDefinitionValidationEnabled owner, OlapUserDefinitions me) {
        List<OlapUserDefinition> users = me.getUserDefinitions();
        this.validateUniqueChildrenNames(context, me, users);
        this.validateChildren(context, me, users);
    }

    protected void validateUniqueChildrenNames(OlapUserDefinitionValidationContext context, IOlapUserDefinitionValidationEnabled parent, @Nullable List<? extends OlapUserDefinition> children) {
        if (children != null) {
            HashSet<String> existingChildNames = new HashSet<String>();
            for (OlapUserDefinition olapUserDefinition : children) {
                String childName = olapUserDefinition.getName();
                if (childName == null) continue;
                if (existingChildNames.contains(childName)) {
                    context.addError(OlapUserDefinitionErrorCode.USER_DUPLICATED_NAME, new Serializable[]{childName});
                    continue;
                }
                existingChildNames.add(childName);
            }
        }
    }
}

