/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authentication.definition;

import crazydev.common.bean.IEmptyable;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.security.CdPasswordHash;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.xml.CdHashablePasswordXmlAdapter;
import crazydev.common.xml.CdLocaleXmlAdapter;
import crazydev.iccube.authentication.definition.OlapUserDefinitions;
import crazydev.iccube.authentication.validation.common.IOlapUserDefinitionValidationEnabled;
import crazydev.iccube.authentication.validation.common.OlapUserDefinitionValidationContext;
import crazydev.iccube.authentication.validation.user.OlapUserDefinitionValidator;
import crazydev.iccube.builder.factory.schema.IOlapBuilderJaxbListener;
import crazydev.iccube.pub.authentication.IOlapUserDefinition;
import crazydev.iccube.pub.principal.OlapPrincipalPhoto;
import crazydev.iccube.validation.OlapValidator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="user")
public class OlapUserDefinition
implements IOlapUserDefinitionValidationEnabled<OlapUserDefinitions, OlapUserDefinition>,
IEmptyable<OlapUserDefinition>,
IOlapUserDefinition,
IOlapBuilderJaxbListener {
    public static final CdProperty UUID = new CdReadWriteProperty(OlapUserDefinition.class, "uuid");
    public static final CdProperty PHOTO = new CdReadWriteProperty(OlapUserDefinition.class, "photo"){

        public Object get(Object bean) throws InvocationTargetException, IllegalAccessException, IllegalArgumentException {
            Object photo = super.get(bean);
            if (photo != null) {
                return photo;
            }
            return OlapPrincipalPhoto.BLANK.getContentBase64();
        }
    };
    public static final CdProperty AVATAR = new CdReadWriteProperty(OlapUserDefinition.class, "avatar"){

        public Object get(Object bean) {
            return ((OlapUserDefinition)bean).name;
        }
    };
    public static final CdProperty NAME = new CdReadWriteProperty(OlapUserDefinition.class, "name");
    public static final CdProperty PASSWORD = new CdReadWriteProperty(OlapUserDefinition.class, "password");
    public static final CdProperty PASSWORD_CONFIRM = new CdReadWriteProperty(OlapUserDefinition.class, "passwordConfirm");
    public static final CdProperty ROLES = new CdReadWriteProperty(OlapUserDefinition.class, "roles");
    public static final CdProperty LOCALE = new CdReadWriteProperty(OlapUserDefinition.class, "locale");
    public static final CdProperty TENANT = new CdReadWriteProperty(OlapUserDefinition.class, "tenant");
    @XmlAttribute(name="uuid", required=false)
    @Nullable
    private String uuid;
    @XmlAttribute(name="name", required=true)
    @Nullable
    private String name;
    @XmlJavaTypeAdapter(value=CdHashablePasswordXmlAdapter.class)
    @XmlAttribute(name="password", required=true)
    @Nullable
    private String password;
    @XmlTransient
    @Nullable
    private String passwordConfirm;
    @XmlAttribute(name="hash", required=true)
    @Nullable
    private String hash;
    @XmlElement(name="role", required=true)
    @Nullable
    private List<String> roles;
    @XmlJavaTypeAdapter(value=CdLocaleXmlAdapter.class)
    @XmlElement(name="locale", required=false)
    @Nullable
    private Locale locale;
    @XmlElement(name="tenant", required=false)
    @Nullable
    private String tenant;
    @XmlElement(name="photo", required=false)
    @Nullable
    private String photo;
    @XmlTransient
    private String avatar;
    @XmlTransient
    private boolean updated;

    public OlapUserDefinition() {
        this.uuid = java.util.UUID.randomUUID().toString();
    }

    public OlapUserDefinition(String name, String password, @Nullable Locale locale, String ... roles) {
        this.uuid = java.util.UUID.randomUUID().toString();
        this.name = name;
        this.locale = locale;
        ArrayList<String> myRoles = new ArrayList<String>();
        if (roles != null) {
            for (String role : roles) {
                myRoles.add(role);
            }
        }
        this.roles = myRoles;
        this.hash = CdPasswordHash.encode((String)password);
    }

    public OlapUserDefinition(OlapUserDefinition user) {
        this.uuid = user.uuid;
        this.name = user.name;
        this.locale = user.locale;
        this.roles = user.roles;
        this.password = null;
        this.hash = user.hash;
        this.photo = user.photo;
        this.tenant = user.tenant;
    }

    public OlapUserDefinition copyForUX() {
        OlapUserDefinition user = new OlapUserDefinition();
        user.uuid = this.uuid;
        user.name = this.name;
        user.locale = this.locale;
        user.roles = new ArrayList<String>();
        if (this.roles != null) {
            user.roles.addAll(this.roles);
        }
        user.password = this.password;
        user.hash = this.hash;
        user.photo = this.photo;
        user.tenant = this.tenant;
        return user;
    }

    public OlapUserDefinition setupForEmptyModel() {
        return this;
    }

    public void refreshForUX(OlapUserDefinition other) {
        if (this.uuid == null || !this.uuid.equals(other.uuid)) {
            throw new RuntimeException("internal error: unexpected or missing user UUID [" + this.uuid + "][" + other.uuid + "]");
        }
        this.name = other.name;
        this.locale = other.locale;
        this.roles = new ArrayList<String>();
        if (other.roles != null) {
            this.roles.addAll(other.roles);
        }
        if (other.hash != null) {
            this.hash = other.hash;
        }
        this.password = null;
        this.tenant = other.tenant;
    }

    public void clearRolesForCommunity() {
        if (this.roles == null || this.roles.isEmpty()) {
            return;
        }
        ArrayList<String> roles_ = new ArrayList<String>();
        for (String role : this.roles) {
            if (!"anonymous".equals(role) && !"administrator".equals(role) && !"administrator-print".equals(role)) continue;
            roles_.add(role);
        }
        if (roles_.isEmpty()) {
            roles_.add("administrator");
        }
        this.roles = roles_;
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getTenant() {
        return this.tenant;
    }

    public boolean validatePassword(String lookupPassword) {
        return CdPasswordHash.check((String)lookupPassword, (String)this.hash);
    }

    @Override
    public void beforeMarshal() {
    }

    @Override
    public void afterUnmarshal() {
        if (this.uuid == null) {
            this.uuid = java.util.UUID.randomUUID().toString();
        }
        if (this.hash == null) {
            this.hash = CdPasswordHash.encode((String)this.password);
            this.password = null;
        }
    }

    @Override
    @Nullable
    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(@Nullable List<String> roles) {
        this.roles = roles;
    }

    public String getRoleNames() {
        StringBuilder names = new StringBuilder();
        if (this.roles != null) {
            for (int ii = 0; ii < this.roles.size(); ++ii) {
                String role = this.roles.get(ii);
                if (ii > 0) {
                    names.append(", ");
                }
                names.append(role);
            }
        }
        return names.toString();
    }

    @Override
    @Nullable
    public Locale getLocale() {
        return this.locale;
    }

    @Nullable
    public OlapPrincipalPhoto getUserPhoto() {
        if (CdStringUtils.isNullOrBlank((String)this.photo)) {
            return null;
        }
        return new OlapPrincipalPhoto("image/png", Base64.decodeBase64((String)this.photo));
    }

    @Override
    public List<String> getValidatedRoles() {
        List<String> myRoles = this.roles;
        if (myRoles == null || myRoles.isEmpty()) {
            throw new CdProgrammingException("internal error: missing roles");
        }
        return myRoles;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    @Nullable
    public String getPasswordConfirm() {
        return this.passwordConfirm;
    }

    @Override
    public boolean hasPassword() {
        return this.hash != null && !this.hash.isEmpty();
    }

    public void hashPassword() {
        if (this.password != null && !this.password.isEmpty()) {
            this.hash = CdPasswordHash.encode((String)this.password);
        }
        this.password = null;
    }

    public void setPhoto(@Nullable String photo) {
        this.photo = photo;
    }

    @Override
    public OlapValidator<OlapUserDefinitionValidationContext, OlapUserDefinitions, OlapUserDefinition> getValidator() {
        return new OlapUserDefinitionValidator();
    }

    @Override
    public String getContextVisualId() {
        return String.valueOf(this.getName());
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public void setUpdated(boolean updated) {
        this.updated = updated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlapUserDefinition that = (OlapUserDefinition)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.hash != null ? !this.hash.equals(that.hash) : that.hash != null) {
            return false;
        }
        if (this.roles != null ? !this.roles.equals(that.roles) : that.roles != null) {
            return false;
        }
        if (this.photo != null ? !this.photo.equals(that.photo) : that.photo != null) {
            return false;
        }
        return !(this.tenant != null ? !this.tenant.equals(that.tenant) : that.tenant != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.hash != null ? this.hash.hashCode() : 0);
        result = 31 * result + (this.roles != null ? this.roles.hashCode() : 0);
        result = 31 * result + (this.photo != null ? this.photo.hashCode() : 0);
        result = 31 * result + (this.tenant != null ? this.tenant.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.valueOf(this.name);
    }
}

