/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.session;

import io.webfolder.cdp.logger.CdpLogggerLevel;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class VideoRecorderOptions {
    private static final Integer DEFAULT_IMAGE_QUALITY = 80;
    private static final String DEFAULT_VIDEO_FILE_NAME = "video.webm";
    private static final Integer DEFAULT_ENCODING_TIMEOUT = Long.valueOf(TimeUnit.SECONDS.toMillis(30L)).intValue();
    private static final CdpLogggerLevel DEFAULT_ENCODER_LOG_LEVEL = CdpLogggerLevel.Info;
    private String ffmpegExecutable;
    private Integer imageQuality;
    private String videoFileName;
    private Integer encodingTimeout;
    private CdpLogggerLevel encoderLogLevel;
    private Executor encoderThreadPool;
    private List<String> ffmpegArgs = Collections.emptyList();

    public static Builder builder() {
        return new Builder();
    }

    public String ffmpegExecutable() {
        return this.ffmpegExecutable;
    }

    public List<String> ffmpegArgs() {
        return this.ffmpegArgs;
    }

    public int imageQuality() {
        return this.imageQuality;
    }

    public String videoFileName() {
        return this.videoFileName;
    }

    public int encodingTimeout() {
        return this.encodingTimeout;
    }

    public CdpLogggerLevel encoderLogLevel() {
        return this.encoderLogLevel;
    }

    public Executor encoderThreadPool() {
        return this.encoderThreadPool;
    }

    public String toString() {
        return "VideoRecorderOptions [ffmpegExecutable=" + this.ffmpegExecutable + ", imageQuality=" + this.imageQuality + ", videoFileName=" + this.videoFileName + ", encodingTimeout=" + this.encodingTimeout + ", encoderLogLevel=" + (Object)((Object)this.encoderLogLevel) + ", encoderThreadPool=" + this.encoderThreadPool + ", ffmpegArgs=" + this.ffmpegArgs + "]";
    }

    public static class Builder {
        private VideoRecorderOptions options = new VideoRecorderOptions();

        private Builder() {
        }

        public Builder ffmpegExecutable(String ffmpegExecutable) {
            if (ffmpegExecutable == null || ffmpegExecutable.trim().isEmpty()) {
                throw new IllegalArgumentException();
            }
            this.options.ffmpegExecutable = ffmpegExecutable;
            return this;
        }

        public Builder ffmpegArgs(List<String> ffmpegArgs) {
            if (ffmpegArgs == null) {
                throw new IllegalArgumentException();
            }
            this.options.ffmpegArgs = Collections.unmodifiableList(ffmpegArgs);
            return this;
        }

        public Builder imageQuality(int imageQuality) {
            this.options.imageQuality = imageQuality;
            return this;
        }

        public Builder videoFileName(String videoFileName) {
            if (videoFileName != null) {
                if (videoFileName.contains("\"") || videoFileName.contains("/")) {
                    throw new IllegalArgumentException("Absolute or relative path is not supported");
                }
                if (videoFileName.indexOf(".") <= 0) {
                    throw new IllegalArgumentException("missing file extension");
                }
            }
            this.options.videoFileName = videoFileName;
            return this;
        }

        public Builder encodingTimeout(int timeout, TimeUnit timeUnit) {
            this.options.encodingTimeout = Long.valueOf(timeUnit.toMillis(timeout)).intValue();
            return this;
        }

        public Builder encoderLogLevel(CdpLogggerLevel encoderLogLevel) {
            this.options.encoderLogLevel = encoderLogLevel;
            return this;
        }

        public Builder encoderThreadPool(Executor encoderThreadPool) {
            this.options.encoderThreadPool = encoderThreadPool;
            return this;
        }

        public VideoRecorderOptions build() {
            if (this.options.imageQuality == null) {
                this.options.imageQuality = DEFAULT_IMAGE_QUALITY;
            }
            if (this.options.videoFileName == null) {
                this.options.videoFileName = VideoRecorderOptions.DEFAULT_VIDEO_FILE_NAME;
            }
            if (this.options.encodingTimeout == null) {
                this.options.encodingTimeout = DEFAULT_ENCODING_TIMEOUT;
            }
            if (this.options.encoderLogLevel == null) {
                this.options.encoderLogLevel = DEFAULT_ENCODER_LOG_LEVEL;
            }
            if (this.options.ffmpegExecutable == null) {
                this.options.ffmpegExecutable = "ffmpeg";
            }
            return this.options;
        }
    }
}

