/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.session;

import io.webfolder.cdp.JsObjectReleaseMode;
import io.webfolder.cdp.SelectorEngine;
import io.webfolder.cdp.command.DOM;
import io.webfolder.cdp.command.Runtime;
import io.webfolder.cdp.exception.CdpException;
import io.webfolder.cdp.exception.ElementNotFoundException;
import io.webfolder.cdp.session.Constant;
import io.webfolder.cdp.session.Session;
import io.webfolder.cdp.type.dom.Node;
import io.webfolder.cdp.type.runtime.CallArgument;
import io.webfolder.cdp.type.runtime.CallFunctionOnResult;
import io.webfolder.cdp.type.runtime.EvaluateResult;
import io.webfolder.cdp.type.runtime.ExceptionDetails;
import io.webfolder.cdp.type.runtime.GetPropertiesResult;
import io.webfolder.cdp.type.runtime.PropertyDescriptor;
import io.webfolder.cdp.type.runtime.RemoteObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public interface Selector {
    default public boolean matches(String selector) {
        return this.matches(selector, Constant.EMPTY_ARGS);
    }

    default public boolean matches(String selector, Object ... args) {
        return this.matches(null, selector, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public boolean matches(Integer contextId, String selector, Object ... args) {
        String objectId = null;
        try {
            objectId = this.getObjectIdWithContext(contextId, selector, args);
        }
        catch (Throwable throwable) {
        }
        finally {
            if (objectId != null) {
                this.releaseObject(objectId);
            }
        }
        boolean retValue = objectId != null;
        this.getThis().logExit("matches", String.format(selector, args), retValue);
        return retValue;
    }

    default public Object getProperty(String selector, String propertyName) {
        return this.getProperty(selector, propertyName, Constant.EMPTY_ARGS);
    }

    default public Object getProperty(String selector, String propertyName, Object ... args) {
        String objectId = this.getObjectId(selector, args);
        if (objectId == null) {
            throw new ElementNotFoundException(String.format(selector, args));
        }
        Object value = this.getPropertyByObjectId(objectId, propertyName);
        this.releaseObject(objectId);
        if (!Constant.DOM_PROPERTIES.contains(propertyName)) {
            this.getThis().logExit("getProperty", String.format(selector, args) + "\", \"" + propertyName, String.valueOf(value).replace("\n", "").replace("\r", ""));
        }
        return value;
    }

    default public void setProperty(String selector, String propertyName, Object value) {
        this.setProperty(selector, propertyName, value, Constant.EMPTY_ARGS);
    }

    default public void setProperty(String selector, String propertyName, Object value, Object ... args) {
        String objectId;
        if (!Constant.DOM_PROPERTIES.contains(propertyName)) {
            this.getThis().logEntry("setProperty", String.format(selector, new Object[0]) + "\", \"" + propertyName + "\", \"" + value);
        }
        if ((objectId = this.getObjectId(selector, args)) == null) {
            throw new ElementNotFoundException(String.format(selector, args));
        }
        ArrayList<CallArgument> arguments = new ArrayList<CallArgument>(2);
        CallArgument prp = new CallArgument();
        prp.setValue(propertyName);
        CallArgument val = new CallArgument();
        val.setValue(value);
        arguments.add(prp);
        arguments.add(val);
        CallFunctionOnResult callFunctionOn = this.getThis().getCommand().getRuntime().callFunctionOn("function(property, value) { function index(obj, property, value) { if (typeof property == 'string') return index(obj, property.split('.'), value); else if (property.length == 1 && value !== undefined) return obj[property[0]] = value; else if (property.length == 0) return obj; else return index(obj[property[0]], property.slice(1), value); }return index(this, property, value); }", objectId, arguments, Boolean.FALSE, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, null, null, null);
        String error = null;
        if (callFunctionOn != null) {
            RemoteObject exception;
            RemoteObject result = callFunctionOn.getResult();
            if (result != null) {
                this.getThis().releaseObject(result.getObjectId());
            }
            if (callFunctionOn.getExceptionDetails() != null && (exception = callFunctionOn.getExceptionDetails().getException()) != null) {
                error = exception.getDescription();
            }
        }
        this.getThis().releaseObject(objectId);
        if (error != null) {
            throw new CdpException(error);
        }
    }

    default public PropertyDescriptor getPropertyDescriptor(String objectId, String name) {
        Runtime runtime = this.getThis().getCommand().getRuntime();
        GetPropertiesResult properties = runtime.getProperties(objectId);
        if (properties == null) {
            return null;
        }
        if (properties.getResult() == null || properties.getResult().isEmpty()) {
            return null;
        }
        for (PropertyDescriptor next : properties.getResult()) {
            if (!name.equals(next.getName())) continue;
            return next;
        }
        return null;
    }

    default public Object getPropertyByObjectId(String objectId, String propertyName) {
        if (propertyName == null || propertyName.trim().isEmpty()) {
            return null;
        }
        if (objectId == null || propertyName == null) {
            return null;
        }
        ArrayList<CallArgument> arguments = new ArrayList<CallArgument>(1);
        CallArgument argProperty = new CallArgument();
        argProperty.setValue(propertyName);
        arguments.add(argProperty);
        CallFunctionOnResult callFunctionOn = this.getThis().getCommand().getRuntime().callFunctionOn("function(property) { return property.split('.').reduce((o, i) => o[i], this); }", objectId, arguments, Boolean.FALSE, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, null, null, null);
        Object value = null;
        String error = null;
        if (callFunctionOn != null) {
            RemoteObject exception;
            RemoteObject result = callFunctionOn.getResult();
            if (result != null) {
                value = callFunctionOn.getResult().getValue();
                if (result != null) {
                    this.getThis().releaseObject(result.getObjectId());
                }
            }
            if (callFunctionOn.getExceptionDetails() != null && (exception = callFunctionOn.getExceptionDetails().getException()) != null) {
                error = exception.getDescription();
            }
        }
        if (error != null) {
            throw new CdpException(error);
        }
        return value;
    }

    default public List<String> getObjectIds(String selector, Object ... args) {
        ArrayList<String> objectIds;
        block7: {
            DOM dom;
            block6: {
                Boolean includeCmdApi;
                dom = this.getThis().getCommand().getDOM();
                boolean xpath = Selector.isXPath(selector);
                objectIds = new ArrayList<String>();
                if (!xpath) break block6;
                Runtime runtime = this.getThis().getCommand().getRuntime();
                String func = "$x(\"%s\")";
                String expression = String.format("$x(\"%s\")", String.format(selector.replace("\"", "\\\""), args));
                EvaluateResult result = runtime.evaluate(expression, null, includeCmdApi = Boolean.TRUE, null, this.getThis().getExecutionContextId(), null, null, null, null, null, null, null, null, null, null, null);
                if (result == null) {
                    return null;
                }
                GetPropertiesResult properties = runtime.getProperties(result.getResult().getObjectId(), true, false, false, null);
                if (properties == null) break block7;
                for (PropertyDescriptor next : properties.getResult()) {
                    if (!next.isEnumerable().booleanValue()) continue;
                    int index = Integer.parseInt(next.getName());
                    RemoteObject remoteObject = next.getValue();
                    objectIds.add(index, remoteObject.getObjectId());
                }
                break block7;
            }
            Integer rootNodeId = dom.getDocument().getNodeId();
            if (rootNodeId == null) {
                return null;
            }
            List<Integer> nodeIds = dom.querySelectorAll(rootNodeId, String.format(selector, args));
            if (nodeIds == null || nodeIds.isEmpty()) {
                return Collections.emptyList();
            }
            for (Integer next : nodeIds) {
                RemoteObject remoteObject = dom.resolveNode(next, null, null, this.getThis().getExecutionContextId());
                if (remoteObject == null) {
                    return null;
                }
                String objectId = remoteObject.getObjectId();
                if (objectId == null) continue;
                objectIds.add(objectId);
            }
        }
        return objectIds;
    }

    default public List<String> getObjectIds(String selector) {
        return this.getObjectIds(selector, Constant.EMPTY_ARGS);
    }

    default public String getObjectId(Integer contextId, String selector, Object ... args) {
        return this.getObjectIdWithContext(contextId, selector, args);
    }

    default public String getObjectId(String selector, Object ... args) {
        return this.getObjectIdWithContext(null, selector, args);
    }

    default public String getObjectIdWithContext(Integer contextId, String selector, Object ... args) {
        String func;
        boolean xpath = Selector.isXPath(selector);
        boolean playwright = SelectorEngine.Playwright == this.getThis().getSelectorEngine();
        boolean nativeSelector = !xpath && !playwright;
        ArrayList<CallArgument> arguments = new ArrayList<CallArgument>(1);
        CallArgument argExpression = new CallArgument();
        argExpression.setValue(String.format(selector, args));
        arguments.add(argExpression);
        Runtime runtime = this.getThis().getCommand().getRuntime();
        if (nativeSelector) {
            func = "(expression) => { return document.querySelector(expression); }";
        } else if (xpath) {
            func = "(expression) => { return document.evaluate(expression, document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null).singleNodeValue; }";
        } else if (playwright) {
            func = "(expression) => { return cdp4j.querySelector(document, expression); }";
        } else {
            throw new IllegalStateException();
        }
        CallFunctionOnResult result = runtime.callFunctionOn(func, null, arguments, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, contextId != null ? contextId : this.getThis().getExecutionContextId(), null, null, null);
        if (result == null) {
            return null;
        }
        ExceptionDetails ex = result.getExceptionDetails();
        if (ex != null && ex.getException() != null) {
            if (result.getResult() != null && result.getResult().getObjectId() != null) {
                this.releaseObject(result.getResult().getObjectId());
            }
            if (ex.getException().getObjectId() != null) {
                this.releaseObject(ex.getException().getObjectId());
            }
            throw new CdpException(ex.getException().getDescription());
        }
        RemoteObject remoteObject = result.getResult();
        if (remoteObject == null) {
            return null;
        }
        if (result.getResult() == null) {
            return null;
        }
        String objectId = result.getResult().getObjectId();
        return ex == null ? objectId : null;
    }

    default public String getObjectId(String selector) {
        return this.getObjectId(selector, Constant.EMPTY_ARGS);
    }

    default public Integer getNodeId(Integer context, String selector, Object ... args) {
        if (!this.getThis().isRootFrame()) {
            throw new CdpException("This method does not support multi-frame mode");
        }
        if (selector == null || selector.trim().isEmpty()) {
            return Constant.EMPTY_NODE_ID;
        }
        Integer nodeId = Constant.EMPTY_NODE_ID;
        DOM dom = this.getThis().getCommand().getDOM();
        boolean xpath = Selector.isXPath(selector);
        if (xpath || SelectorEngine.Playwright.equals((Object)this.getThis().getSelectorEngine())) {
            String objectId = this.getThis().getObjectId(context, String.format(selector, args), new Object[0]);
            if (objectId != null) {
                nodeId = dom.requestNode(objectId);
                this.getThis().releaseObject(objectId);
            }
        } else {
            Integer documentNodeId;
            Node document = dom.getDocument();
            if (document != null && (documentNodeId = document.getNodeId()) != null) {
                try {
                    nodeId = dom.querySelector(documentNodeId, String.format(selector, args));
                }
                catch (CdpException e) {
                    throw new CdpException(String.format("Method invoke error: querySelector(%s). %s", String.format(selector, args), e.getMessage()));
                }
            }
        }
        return nodeId;
    }

    default public Integer getNodeId(String selector) {
        return this.getNodeId(null, selector, Constant.EMPTY_ARGS);
    }

    default public Session releaseObject(String objectId) {
        if (objectId != null) {
            if (JsObjectReleaseMode.sync == this.getThis().jsObjectReleaseMode()) {
                this.getThis().getCommand().getRuntime().releaseObject(objectId);
            } else {
                this.getThis().getAsyncCommand().getRuntime().releaseObject(objectId);
            }
        }
        return this.getThis();
    }

    public static boolean isXPath(String selector) {
        return selector.charAt(0) == '/' || selector.charAt(0) == '(';
    }

    public Session getThis();
}

