/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.session;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.filter.FilteringParserDelegate;
import com.fasterxml.jackson.core.filter.TokenFilter;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.webfolder.cdp.TypeReference;
import io.webfolder.cdp.channel.InputStreamExtension;
import io.webfolder.cdp.event.Events;
import io.webfolder.cdp.exception.CdpException;
import io.webfolder.cdp.exception.CommandException;
import io.webfolder.cdp.listener.EventListener;
import io.webfolder.cdp.logger.CdpLogger;
import io.webfolder.cdp.serialization.JsonMapper;
import io.webfolder.cdp.serialization.LoggingInputStream;
import io.webfolder.cdp.session.CommandReturnType;
import io.webfolder.cdp.session.Context;
import io.webfolder.cdp.session.MessageHandler;
import io.webfolder.cdp.session.Session;
import io.webfolder.cdp.session.SessionFactory;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;

class JacksonMessageHandler
implements MessageHandler {
    private static final int RESPONSE_WITH_SESSION_ID_MIN_LEN = 60;
    private static final Map<String, Events> EVENTS = JacksonMessageHandler.listEvents();
    private final ObjectReader reader;
    private final JsonFactory jsonFactory;
    private final TypeFactory typeFactory;
    private final Executor workerThreadPool;
    private final Executor eventHandlerThreadPool;
    private final CdpLogger log;
    private final SessionFactory factory;
    private final boolean useSimpleFilter;
    private static final TokenFilter SESSION_ID_FILTER = new SessionIdFilter();

    JacksonMessageHandler(JsonMapper mapper, SessionFactory factory, Executor workerThreadPool, Executor eventHandlerThreadPool, CdpLogger log) {
        this.reader = (ObjectReader)mapper.getReader();
        this.jsonFactory = ((JsonFactoryBuilder)((JsonFactoryBuilder)((JsonFactoryBuilder)new JsonFactoryBuilder().disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES)).disable(JsonFactory.Feature.INTERN_FIELD_NAMES)).disable(StreamReadFeature.AUTO_CLOSE_SOURCE)).build();
        this.typeFactory = this.reader.getTypeFactory();
        this.factory = factory;
        this.workerThreadPool = workerThreadPool;
        this.eventHandlerThreadPool = eventHandlerThreadPool;
        this.useSimpleFilter = factory == null || io.webfolder.cdp.SessionIdFilter.SimpleParser == factory.getOptions().jsonIdFilter();
        this.log = log;
    }

    @Override
    public void process(String content) {
        this.process(content, InputType.String);
    }

    @Override
    public void process(byte[] content) {
        this.process(content, InputType.ByteArray);
    }

    @Override
    public void process(InputStream content) {
        this.process(content, InputType.InputStream);
    }

    protected String filterSessionId(Object content, InputType it) throws IOException {
        switch (it) {
            default: {
                return this.filterSessionId((String)content);
            }
            case ByteArray: {
                return this.filterSessionId((byte[])content);
            }
            case InputStream: 
        }
        return this.filterSessionId((InputStream)content);
    }

    protected String parseSessionId(Object content, InputType it) {
        String sessionId = null;
        JsonParser parser = null;
        try {
            switch (it) {
                case ByteArray: {
                    parser = this.jsonFactory.createParser((byte[])content);
                    break;
                }
                case String: {
                    parser = this.jsonFactory.createParser((String)content);
                    break;
                }
                case InputStream: {
                    parser = this.jsonFactory.createParser((InputStream)content);
                }
            }
        }
        catch (IOException e) {
            throw new CdpException(e);
        }
        try (FilteringParserDelegate jsonParser = new FilteringParserDelegate(parser, SESSION_ID_FILTER, TokenFilter.Inclusion.ONLY_INCLUDE_ALL, true);){
            JsonToken token = null;
            while ((token = jsonParser.nextToken()) != null) {
                if (!token.isScalarValue()) continue;
                sessionId = jsonParser.getValueAsString();
            }
        }
        catch (IOException e) {
            throw new CdpException(e);
        }
        finally {
            if (InputType.InputStream == it) {
                try {
                    ((InputStream)content).reset();
                }
                catch (IOException e) {
                    throw new CdpException(e);
                }
            }
        }
        return sessionId;
    }

    protected String filterSessionId(String content) {
        if (content.length() <= 2) {
            return null;
        }
        if (content.charAt(content.length() - 2) == '}' && content.charAt(content.length() - 1) == '}') {
            return null;
        }
        int[] offsets = new int[]{0, 0, 0, 0};
        int cursor = offsets.length;
        for (int i = content.length() - 1; i > 0 && cursor > 0; --i) {
            if (content.charAt(i) != '\"') continue;
            offsets[--cursor] = i;
        }
        if (cursor != 0) {
            return null;
        }
        return content.charAt(offsets[0] + 1) == "sessionId".charAt(0) && content.charAt(offsets[0] + 2) == "sessionId".charAt(1) && content.charAt(offsets[0] + 3) == "sessionId".charAt(2) && content.charAt(offsets[0] + 4) == "sessionId".charAt(3) && content.charAt(offsets[0] + 5) == "sessionId".charAt(4) && content.charAt(offsets[0] + 6) == "sessionId".charAt(5) && content.charAt(offsets[0] + 7) == "sessionId".charAt(6) && content.charAt(offsets[0] + 8) == "sessionId".charAt(7) && content.charAt(offsets[0] + 9) == "sessionId".charAt(8) ? content.substring(offsets[2] + 1, offsets[3]) : null;
    }

    protected String filterSessionId(byte[] content) {
        if (content.length <= 2) {
            return null;
        }
        if (content[content.length - 2] == 125 && content[content.length - 1] == 125) {
            return null;
        }
        int[] offsets = new int[]{0, 0, 0, 0};
        int cursor = offsets.length;
        for (int i = content.length - 1; i > 0 && cursor > 0; --i) {
            if (content[i] != 34) continue;
            offsets[--cursor] = i;
        }
        if (cursor != 0) {
            return null;
        }
        if (content[offsets[0] + 1] == "sessionId".charAt(0) && content[offsets[0] + 2] == "sessionId".charAt(1) && content[offsets[0] + 3] == "sessionId".charAt(2) && content[offsets[0] + 4] == "sessionId".charAt(3) && content[offsets[0] + 5] == "sessionId".charAt(4) && content[offsets[0] + 6] == "sessionId".charAt(5) && content[offsets[0] + 7] == "sessionId".charAt(6) && content[offsets[0] + 8] == "sessionId".charAt(7) && content[offsets[0] + 9] == "sessionId".charAt(8)) {
            StringBuilder builder = new StringBuilder(offsets[3] - offsets[2]);
            for (int i = offsets[2] + 1; i < offsets[3]; ++i) {
                builder.append((char)content[i]);
            }
            return builder.toString();
        }
        return null;
    }

    protected String filterSessionId(InputStream content) throws IOException {
        String sessionId = null;
        if (content instanceof InputStreamExtension) {
            int length = content.available();
            if (length <= 60) {
                return null;
            }
            InputStreamExtension ise = (InputStreamExtension)((Object)content);
            byte[] chunk = ise.readLastNBytes(60);
            sessionId = this.filterSessionId(chunk);
        } else {
            int length = content.available();
            if (length <= 60) {
                return null;
            }
            int skip = (int)content.skip(length - 60);
            byte[] chunk = new byte[length - skip];
            content.read(chunk, 0, length - skip);
            sessionId = this.filterSessionId(chunk);
        }
        content.reset();
        return sessionId;
    }

    protected void process(Object content, InputType it) {
        Runnable runnable = () -> {
            String sessionId;
            JsonParser parser = null;
            Context context = null;
            Integer id = 0;
            Object result = null;
            Events event = null;
            Object eventValue = null;
            Throwable parseException = null;
            Integer errorCode = null;
            String errorMessage = null;
            String errorData = null;
            try {
                sessionId = this.useSimpleFilter ? this.filterSessionId(content, it) : this.parseSessionId(content, it);
            }
            catch (IOException e) {
                this.log.error(e.getMessage(), e);
                return;
            }
            Session session = sessionId == null ? this.factory.getBrowserSession() : this.factory.getSession(sessionId);
            try {
                switch (it) {
                    case ByteArray: {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("<-- {}", new String((byte[])content, StandardCharsets.UTF_8));
                        }
                        parser = this.jsonFactory.createParser((byte[])content);
                        break;
                    }
                    case InputStream: {
                        InputStream inputStream = (InputStream)content;
                        if (this.log.isDebugEnabled()) {
                            inputStream = new LoggingInputStream(inputStream, this.log, "<-- {}");
                        }
                        parser = this.jsonFactory.createParser(inputStream);
                        break;
                    }
                    default: {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("<-- {}", content);
                        }
                        parser = this.jsonFactory.createParser((String)content);
                    }
                }
                JsonToken token = null;
                while ((token = parser.nextToken()) != null) {
                    String name = parser.currentName();
                    int idx = parser.getParsingContext().getCurrentIndex();
                    if (idx == 0) {
                        if (JsonToken.VALUE_NUMBER_INT == token && "id".equals(name)) {
                            id = parser.getValueAsInt();
                            context = session.pullContext(id);
                            continue;
                        }
                        if (JsonToken.START_OBJECT == token && "result".equals(name)) {
                            CommandReturnType crt = context != null ? context.getCommandReturnType() : null;
                            if (crt == null) continue;
                            if (context.getResponseParser() == null) {
                                result = this.fromJson(crt.returns, crt.returnType, crt.typeReference, parser);
                                continue;
                            }
                            result = context.getResponseParser().parse(session, parser);
                            continue;
                        }
                        if (JsonToken.VALUE_STRING == token && "method".equals(name)) {
                            String eventName = parser.getValueAsString();
                            event = EVENTS.get(eventName);
                            if (session == null || MANDATORY_EVENT_LISTENERS.contains((Object)event) || session.getRegisteredEventListeners().contains((Object)event)) continue;
                            event = null;
                            continue;
                        }
                        if (JsonToken.START_OBJECT == token && "params".equals(name) && event != null) {
                            eventValue = session.getEventParser().parse(event, session, parser, this.reader);
                            continue;
                        }
                        if (JsonToken.START_OBJECT != token || !"error".equals(name)) continue;
                        while ((token = parser.nextToken()) != JsonToken.END_OBJECT) {
                            String currentName = parser.currentName();
                            if (JsonToken.VALUE_NUMBER_INT == token && "code".equals(currentName)) {
                                errorCode = parser.getIntValue();
                                continue;
                            }
                            if (JsonToken.VALUE_STRING == token && "message".equals(currentName)) {
                                errorMessage = parser.getValueAsString();
                                continue;
                            }
                            if (JsonToken.VALUE_STRING != token || !"data".equals(currentName)) continue;
                            errorData = parser.getValueAsString();
                        }
                        continue;
                    }
                    if (idx != 1 || errorCode == null || JsonToken.VALUE_NUMBER_INT != token || !"id".equals(name)) continue;
                    id = parser.getValueAsInt();
                    context = session.pullContext(id);
                }
            }
            catch (Throwable e) {
                parseException = e;
            }
            finally {
                if (parser != null && parseException != null) {
                    try {
                        parser.close();
                    }
                    catch (IOException token) {}
                }
                if (it == InputType.InputStream) {
                    try {
                        ((InputStream)content).close();
                    }
                    catch (IOException e) {
                        this.log.warn(e.getMessage(), new Object[0]);
                    }
                }
            }
            if (session == null) {
                return;
            }
            if (context != null) {
                try {
                    if (parseException != null) {
                        context.setError(new CommandException(parseException));
                        return;
                    }
                    if (errorCode != null) {
                        int code = errorCode;
                        String message = String.format("Command [%s.%s] failed. %s%s", context.getDomainCommand().domain.name(), context.getDomainCommand().command, errorMessage, errorData != null ? ". " + errorData : "");
                        context.setError(new CommandException(code, message));
                        if (context.getPromise() == null) return;
                        this.log.error(errorMessage, new Object[0]);
                        context.getPromise().completeExceptionally(context.getError());
                        return;
                    }
                    if (context.getPromise() != null) {
                        context.getPromise().complete(result);
                        return;
                    }
                    context.setData(result);
                    return;
                }
                finally {
                    context.release();
                }
            } else if (eventValue != null) {
                for (EventListener next : session.getSyncListeners()) {
                    next.onEvent(event, eventValue);
                }
                Object fEventValue = eventValue;
                Events fEvent = event;
                this.eventHandlerThreadPool.execute(() -> {
                    for (EventListener next : session.getListeners()) {
                        next.onEvent(fEvent, fEventValue);
                    }
                });
                return;
            } else {
                if (parseException == null) return;
                throw new CdpException(parseException);
            }
        };
        this.workerThreadPool.execute(runnable);
    }

    Object fromJson(String returns, Type returnType, TypeReference<?> typeArgument, JsonParser parser) throws IOException {
        if (returns != null) {
            if (typeArgument != null) {
                JsonToken token = null;
                while ((token = parser.nextToken()) != null) {
                    if (!token.isStructStart() || !returns.equals(parser.currentName())) continue;
                    JavaType javaType = this.typeFactory.constructType(typeArgument.getType());
                    Object value = this.reader.readValue(parser, javaType);
                    return value;
                }
            } else if (returnType != null) {
                JsonToken token = null;
                while ((token = parser.nextToken()) != null) {
                    if (!returns.equals(parser.currentName())) continue;
                    if (token.isScalarValue()) {
                        switch (token) {
                            case VALUE_NULL: {
                                return null;
                            }
                            case VALUE_STRING: {
                                if (byte[].class.equals((Object)returnType)) {
                                    return Base64.getDecoder().decode(parser.getValueAsString());
                                }
                                return parser.getValueAsString();
                            }
                            case VALUE_FALSE: {
                                return Boolean.FALSE;
                            }
                            case VALUE_TRUE: {
                                return Boolean.TRUE;
                            }
                            case VALUE_NUMBER_INT: {
                                return parser.getValueAsInt();
                            }
                            case VALUE_NUMBER_FLOAT: {
                                return parser.getValueAsDouble();
                            }
                        }
                        return parser.getValueAsString();
                    }
                    if (token != JsonToken.START_OBJECT) continue;
                    JavaType javaType = this.typeFactory.constructType((Type)((Class)returnType));
                    Object value = this.reader.readValue(parser, javaType);
                    return value;
                }
            }
        } else if (returnType != null) {
            return this.reader.readValue(parser, (Class)returnType);
        }
        throw new IllegalStateException();
    }

    private static Map<String, Events> listEvents() {
        Events[] values = Events.values();
        HashMap<String, Events> map = new HashMap<String, Events>(values.length);
        for (Events next : values) {
            map.put(next.domain + "." + next.name, next);
        }
        return Collections.unmodifiableMap(map);
    }

    static enum InputType {
        String,
        ByteArray,
        InputStream;

    }

    private static class SessionIdFilter
    extends TokenFilter {
        private SessionIdFilter() {
        }

        public TokenFilter filterStartArray() {
            return null;
        }

        public TokenFilter includeProperty(String name) {
            return "sessionId".equals(name) ? INCLUDE_ALL : null;
        }
    }
}

