/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.session;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.webfolder.cdp.event.Events;
import io.webfolder.cdp.exception.CdpException;
import io.webfolder.cdp.exception.CommandException;
import io.webfolder.cdp.listener.EventListener;
import io.webfolder.cdp.logger.CdpLogger;
import io.webfolder.cdp.serialization.JsonMapper;
import io.webfolder.cdp.serialization.LoggingInputStream;
import io.webfolder.cdp.session.CommandReturnType;
import io.webfolder.cdp.session.Context;
import io.webfolder.cdp.session.MessageHandler;
import io.webfolder.cdp.session.Session;
import io.webfolder.cdp.session.SessionFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

final class GsonMessageHandler
implements MessageHandler {
    private static final Map<String, Events> EVENTS = GsonMessageHandler.listEvents();
    private final Gson gson;
    private final Executor workerThreadPool;
    private final Executor eventHandlerThreadPool;
    private final CdpLogger log;
    private final SessionFactory factory;

    GsonMessageHandler(JsonMapper mapper, SessionFactory factory, Executor workerThreadPool, Executor eventHandlerThreadPool, CdpLogger log) {
        this.gson = (Gson)mapper.getMapper();
        this.factory = factory;
        this.workerThreadPool = workerThreadPool;
        this.eventHandlerThreadPool = eventHandlerThreadPool;
        this.log = log;
    }

    @Override
    public void process(String content) {
        this.process(content, InputType.String);
    }

    @Override
    public void process(byte[] content) {
        this.process(content, InputType.ByteArray);
    }

    @Override
    public void process(InputStream is) {
        this.process(is, InputType.InputStream);
    }

    protected void process(Object content, InputType it) {
        Runnable runnable = () -> {
            Session session;
            JsonObject object;
            JsonElement idElement;
            JsonElement json = null;
            switch (it) {
                case ByteArray: {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("<-- {}", new String((byte[])content, StandardCharsets.UTF_8));
                    }
                    try (InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream((byte[])content), StandardCharsets.UTF_8);){
                        json = (JsonElement)this.gson.fromJson((Reader)reader, JsonElement.class);
                        break;
                    }
                    catch (IOException e) {
                        throw new CdpException(e);
                    }
                }
                case InputStream: {
                    InputStream inputStream = (InputStream)content;
                    if (this.log.isDebugEnabled()) {
                        inputStream = new LoggingInputStream(inputStream, this.log, "<-- {}");
                    }
                    try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                        json = (JsonElement)this.gson.fromJson((Reader)reader, JsonElement.class);
                        break;
                    }
                    catch (IOException e) {
                        throw new CdpException(e);
                    }
                }
                default: {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("<-- {}", (String)content);
                    }
                    json = (JsonElement)this.gson.fromJson((String)content, JsonElement.class);
                }
            }
            if ((idElement = (object = json.getAsJsonObject()).get("id")) != null) {
                Session session2;
                Integer valId = idElement.getAsInt();
                String sessionId = object.has("sessionId") ? object.get("sessionId").getAsString() : null;
                Session session3 = session2 = sessionId == null ? this.factory.getBrowserSession() : this.factory.getSession(sessionId);
                if (session2 == null) {
                    return;
                }
                Context context = session2.pullContext(valId);
                if (context == null) {
                    return;
                }
                try {
                    JsonObject error = object.getAsJsonObject("error");
                    if (error == null) {
                        Object result = this.toJavaObject(context.getCommandReturnType(), json);
                        if (context.getPromise() != null) {
                            context.getPromise().complete(result);
                            return;
                        }
                        context.setData(result);
                        return;
                    }
                    int code = error.getAsJsonPrimitive("code").getAsInt();
                    String message = error.getAsJsonPrimitive("message").getAsString();
                    JsonElement messageData = error.get("data");
                    String errorMessage = context.getDomainCommand().domain.name() + "." + context.getDomainCommand().command + " " + message + (messageData != null && messageData.isJsonPrimitive() ? ". " + messageData.getAsString() : "");
                    context.setError(new CommandException(code, errorMessage));
                    if (context.getPromise() == null) return;
                    this.log.error(errorMessage, new Object[0]);
                    context.getPromise().completeExceptionally(context.getError());
                    return;
                }
                finally {
                    if (context != null) {
                        context.release();
                    }
                    if (it == InputType.InputStream) {
                        try {
                            ((InputStream)content).close();
                        }
                        catch (IOException e) {
                            this.log.warn(e.getMessage(), new Object[0]);
                        }
                    }
                }
            }
            JsonElement method = object.get("method");
            if (method == null) return;
            if (!method.isJsonPrimitive()) {
                return;
            }
            String eventName = method.getAsString();
            Events event = EVENTS.get(eventName);
            String sessionId = object.has("sessionId") ? object.get("sessionId").getAsString() : null;
            Session session4 = session = sessionId == null ? this.factory.getBrowserSession() : this.factory.getSession(sessionId);
            if (session != null && !MANDATORY_EVENT_LISTENERS.contains((Object)event) && !session.getRegisteredEventListeners().contains((Object)event)) {
                return;
            }
            if (event == null) {
                return;
            }
            JsonElement params = object.get("params");
            Object value = this.gson.fromJson(params, event.klass);
            if (session == null) {
                return;
            }
            for (EventListener next : session.getSyncListeners()) {
                next.onEvent(event, value);
            }
            Events fEvent = event;
            this.eventHandlerThreadPool.execute(() -> {
                for (EventListener next : session.getListeners()) {
                    next.onEvent(fEvent, value);
                }
            });
        };
        this.workerThreadPool.execute(runnable);
    }

    Object toJavaObject(CommandReturnType crt, JsonElement data) {
        Type returnType = crt.returnType;
        if (Void.TYPE.equals(returnType)) {
            return null;
        }
        if (!data.isJsonObject()) {
            throw new CdpException("Invalid JSON response");
        }
        JsonObject object = data.getAsJsonObject();
        JsonElement result = object.get("result");
        if (result == null || !result.isJsonObject()) {
            throw new CdpException("Invalid result value");
        }
        JsonObject resultObject = result.getAsJsonObject();
        String returns = crt.returns;
        if (returns != null) {
            JsonElement jsonElement = resultObject.get(returns);
            if (jsonElement != null) {
                if (jsonElement.isJsonPrimitive()) {
                    if (String.class.equals((Object)returnType)) {
                        return resultObject.get(returns).getAsString();
                    }
                    if (Boolean.class.equals((Object)returnType)) {
                        return resultObject.get(returns).getAsBoolean() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    if (Integer.class.equals((Object)returnType)) {
                        return resultObject.get(returns).getAsInt();
                    }
                    if (Double.class.equals((Object)returnType)) {
                        return resultObject.get(returns).getAsDouble();
                    }
                }
                if (byte[].class.equals((Object)returnType)) {
                    String encoded = (String)this.gson.fromJson(jsonElement, String.class);
                    if (encoded == null || encoded.trim().isEmpty()) {
                        return null;
                    }
                    return Base64.getDecoder().decode(encoded);
                }
            }
            if (List.class.equals((Object)returnType)) {
                JsonArray jsonArray = jsonElement.getAsJsonArray();
                return this.gson.fromJson((JsonElement)jsonArray, crt.typeReference.getType());
            }
            return this.gson.fromJson(jsonElement, returnType);
        }
        return this.gson.fromJson((JsonElement)resultObject, returnType);
    }

    private static Map<String, Events> listEvents() {
        Events[] values = Events.values();
        HashMap<String, Events> map = new HashMap<String, Events>(values.length);
        for (Events next : values) {
            map.put(next.domain + "." + next.name, next);
        }
        return Collections.unmodifiableMap(map);
    }

    static enum InputType {
        String,
        ByteArray,
        InputStream;

    }
}

