/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.session;

import io.webfolder.cdp.command.PageAsync;
import io.webfolder.cdp.event.Events;
import io.webfolder.cdp.event.page.ScreencastFrame;
import io.webfolder.cdp.exception.CdpException;
import io.webfolder.cdp.listener.EventListener;
import io.webfolder.cdp.logger.CdpLogger;
import io.webfolder.cdp.session.CloseListener;
import io.webfolder.cdp.session.Session;
import io.webfolder.cdp.session.VideoRecorder;
import io.webfolder.cdp.session.VideoRecorderOptions;
import io.webfolder.cdp.session.VideoRecorderResult;
import io.webfolder.cdp.type.constant.ImageFormat;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;

class FFmpegVideoRecorder
implements VideoRecorder,
EventListener {
    private static final String LINE_SEPERATOR = System.lineSeparator();
    private static final String TEMP_PATH_PREFIX = "screencast-";
    private static final String INPUT_FILE_NAME = "input.txt";
    private static final String DEFAULT_FPS = "25";
    private static final int DEFAULT_NTH_FRAME = 1;
    private final Session session;
    private final VideoRecorderOptions options;
    private final CdpLogger log;
    private final PageAsync page;
    private final DeleteTempFileTask deleteTempFileTask;
    private final CloseListener sessionCloseListener;
    private final Path videoFile;
    private Path tempPath;
    private Path inputFile;
    private volatile String lastFrame;
    private volatile String lastFrameFileName;
    private volatile VideoRecorder.VideoRecorderState state;
    private volatile long lastFrameTimestamp;
    private final Object encoderLock = new Object();
    private final AtomicInteger frameCounter = new AtomicInteger();

    FFmpegVideoRecorder(Session session, VideoRecorderOptions options, CdpLogger log) {
        this.session = session;
        this.options = options;
        this.log = log;
        this.page = session.getAsyncCommand().getPage();
        session.addEventListener(this);
        try {
            this.tempPath = Files.createTempDirectory(TEMP_PATH_PREFIX, new FileAttribute[0]);
            if (log.isDebugEnabled()) {
                log.debug("Temporary directory created: [{}]", this.tempPath.toAbsolutePath().toString());
            }
            this.inputFile = this.tempPath.resolve(INPUT_FILE_NAME);
            Files.createFile(this.inputFile, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new CdpException(e);
        }
        this.videoFile = this.tempPath.resolve(options.videoFileName());
        this.deleteTempFileTask = new DeleteTempFileTask(this);
        this.sessionCloseListener = () -> this.deleteTempFileTask.run();
        session.addCloseListener(this.sessionCloseListener);
    }

    @Override
    public void start() {
        boolean startable;
        boolean bl = startable = this.state == null || this.state == VideoRecorder.VideoRecorderState.InvokedStopped;
        if (!startable) {
            throw new IllegalArgumentException("state=[" + (Object)((Object)this.state) + "]");
        }
        ((CompletableFuture)this.page.enable().thenAccept(rE -> {
            this.state = VideoRecorder.VideoRecorderState.InvokedPageEnabled;
            ((CompletableFuture)this.page.startScreencast(ImageFormat.Jpeg, this.options.imageQuality(), null, null, 1).thenAccept(rC -> {
                this.state = VideoRecorder.VideoRecorderState.InvokedScreencast;
            })).exceptionally(t -> {
                this.state = VideoRecorder.VideoRecorderState.ErrorStartScreencast;
                this.log.error(t.getMessage(), (Throwable)t);
                this.session.removeEventEventListener(this);
                this.session.removeCloseListener(this.sessionCloseListener);
                return null;
            });
        })).exceptionally(t -> {
            this.state = VideoRecorder.VideoRecorderState.ErrorPageEnable;
            this.log.error(t.getMessage(), (Throwable)t);
            this.session.removeEventEventListener(this);
            this.session.removeCloseListener(this.sessionCloseListener);
            return null;
        });
    }

    @Override
    public void stop() {
        this.state = VideoRecorder.VideoRecorderState.InvokedStopped;
        this.page.stopScreencast().exceptionally(e -> {
            this.log.warn(e.getMessage(), e);
            return null;
        });
    }

    public VideoRecorder.VideoRecorderState getState() {
        return this.state;
    }

    @Override
    public void onEvent(Events event, Object value) {
        if (Events.PageScreencastFrame != event) {
            return;
        }
        if (this.state == VideoRecorder.VideoRecorderState.InvokedStopped || this.state == VideoRecorder.VideoRecorderState.InvokedEncoding) {
            return;
        }
        int count = this.frameCounter.incrementAndGet();
        ScreencastFrame sc = (ScreencastFrame)value;
        long frameTimestamp = (long)(sc.getMetadata().getTimestamp() * 1000.0);
        this.page.screencastFrameAck(sc.getSessionId()).exceptionally(t -> {
            this.log.warn(t.getMessage(), t);
            return null;
        });
        this.processFrame(sc.getData(), frameTimestamp, count, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processFrame(String frame, long frameTimestamp, int count, boolean done) {
        Object object = this.encoderLock;
        synchronized (object) {
            double frameDuration = (double)(frameTimestamp - this.lastFrameTimestamp) / 1000.0;
            if (this.lastFrame != null) {
                byte[] decoded = null;
                try {
                    decoded = Base64.getDecoder().decode(this.lastFrame);
                }
                catch (IllegalArgumentException e) {
                    this.log.error(e.getMessage(), e);
                    return;
                }
                Path imageFile = this.tempPath.resolve(this.lastFrameFileName);
                try {
                    String line;
                    Files.write(imageFile, decoded, new OpenOption[0]);
                    String lineFileName = "file '" + this.lastFrameFileName + "'";
                    String durationLine = "duration " + frameDuration;
                    String string = line = frameDuration > 0.0 ? lineFileName + LINE_SEPERATOR + durationLine + LINE_SEPERATOR : lineFileName + LINE_SEPERATOR;
                    if (done) {
                        line = line + lineFileName;
                    }
                    Files.write(this.inputFile, line.getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
                }
                catch (IOException e) {
                    this.log.error(e.getMessage(), e);
                }
            }
            if (!done) {
                this.lastFrame = frame;
                this.lastFrameTimestamp = frameTimestamp;
                this.lastFrameFileName = "image-" + count + ".jpg";
            } else {
                this.lastFrame = null;
                this.lastFrameFileName = null;
            }
        }
    }

    @Override
    public CompletableFuture<VideoRecorderResult> encodeAsync() {
        this.state = VideoRecorder.VideoRecorderState.InvokedEncoding;
        if (this.options.encoderThreadPool() == null) {
            return CompletableFuture.supplyAsync(() -> this.encode());
        }
        return CompletableFuture.supplyAsync(() -> this.encode(), this.options.encoderThreadPool());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public VideoRecorderResult encode() {
        if (this.state == null) {
            throw new IllegalStateException("Invoke VideoRecorder.start() before video encoding");
        }
        this.state = VideoRecorder.VideoRecorderState.InvokedEncoding;
        if (this.lastFrame != null) {
            this.processFrame(this.lastFrame, System.currentTimeMillis(), 0, true);
        }
        Process process = null;
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("FFmpeg executable path: [{}]", this.options.ffmpegExecutable());
            }
            if (this.options.ffmpegExecutable() == null) {
                throw new CdpException("ffmpeg executable not found");
            }
            List<String> encodingArgs = this.options.ffmpegArgs().isEmpty() ? Arrays.asList("-avioflags", "direct", "-fpsprobesize", "0", "-probesize", "32", "-analyzeduration", "0", "-y", "-an", "-r", DEFAULT_FPS, "-c:v", "vp8", "-qmin", "0", "-qmax", "50", "-crf", "8", "-deadline", "realtime", "-speed", "8", "-b:v", "1M", "-threads", "1") : this.options.ffmpegArgs();
            ArrayList<String> args = new ArrayList<String>(Arrays.asList(this.options.ffmpegExecutable(), "-f", "concat", "-c:v", "mjpeg", "-i", INPUT_FILE_NAME, "-loglevel", this.options.encoderLogLevel().name().toLowerCase(Locale.ENGLISH)));
            args.addAll(encodingArgs);
            args.add(this.options.videoFileName());
            ProcessBuilder builder = new ProcessBuilder(args);
            builder.directory(this.tempPath.toFile());
            process = builder.start();
            try (Scanner scanner = new Scanner(process.getErrorStream());){
                block25: while (scanner.hasNext()) {
                    String line = scanner.nextLine();
                    switch (this.options.encoderLogLevel()) {
                        case Debug: {
                            this.log.debug("{}", line);
                            break;
                        }
                        case Error: {
                            this.log.error("{}", line);
                            break;
                        }
                        case Info: {
                            this.log.info("{}", line);
                            break;
                        }
                        case Warn: {
                            this.log.warn("{}", line);
                            continue block25;
                        }
                    }
                }
            }
            process.waitFor();
            boolean done = process.exitValue() == 0;
            this.state = done ? VideoRecorder.VideoRecorderState.EncodingDone : VideoRecorder.VideoRecorderState.EncodingError;
            VideoRecorderResult videoRecorderResult = new VideoRecorderResult(done, this.tempPath.resolve(this.options.videoFileName()).toAbsolutePath());
            return videoRecorderResult;
        }
        catch (Throwable e) {
            this.state = VideoRecorder.VideoRecorderState.EncodingError;
            throw new CdpException(e);
        }
        finally {
            if (process != null) {
                try {
                    if (process.isAlive()) {
                        process.destroy();
                    }
                }
                catch (Throwable t) {
                    this.log.error(t.getMessage(), t);
                }
                finally {
                    this.deleteTempFileTask.run();
                }
            }
            if (this.session.isConnected()) {
                this.session.removeCloseListener(this.sessionCloseListener);
                this.session.removeEventEventListener(this);
            }
        }
    }

    private static class DeleteTempFileTask
    implements Runnable {
        private final FFmpegVideoRecorder recorder;
        private AtomicBoolean executed = new AtomicBoolean(false);

        public DeleteTempFileTask(FFmpegVideoRecorder recorder) {
            this.recorder = recorder;
        }

        @Override
        public void run() {
            if (this.executed.get()) {
                return;
            }
            if (this.recorder.state == VideoRecorder.VideoRecorderState.InvokedEncoding) {
                return;
            }
            if (!Files.isDirectory(this.recorder.tempPath, new LinkOption[0]) && Files.exists(this.recorder.tempPath, new LinkOption[0])) {
                return;
            }
            this.executed.set(true);
            try (Stream<Path> stream = Files.walk(this.recorder.tempPath, new FileVisitOption[0]);){
                Iterator iter = stream.iterator();
                while (iter.hasNext()) {
                    Path path = (Path)iter.next();
                    String fileName = path.getFileName().toString();
                    if (!Files.isRegularFile(path, new LinkOption[0]) || fileName.equals(this.recorder.options.videoFileName())) continue;
                    try {
                        Files.deleteIfExists(path);
                    }
                    catch (Throwable t) {
                        this.recorder.log.warn(t.getMessage(), t);
                    }
                }
            }
            catch (IOException e) {
                this.recorder.log.warn(e.getMessage(), e);
            }
            if (this.recorder.state != VideoRecorder.VideoRecorderState.InvokedEncoding && Files.isDirectory(this.recorder.tempPath, new LinkOption[0]) && Files.exists(this.recorder.tempPath, new LinkOption[0]) && !Files.exists(this.recorder.videoFile, new LinkOption[0])) {
                try {
                    Files.deleteIfExists(this.recorder.tempPath);
                }
                catch (IOException e) {
                    this.recorder.log.warn(e.getMessage(), e);
                }
            }
        }
    }
}

