/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.session;

import io.webfolder.cdp.session.DocumentSnapshot;
import io.webfolder.cdp.type.domsnapshot.DOMNode;
import io.webfolder.cdp.type.domsnapshot.NameValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DomSnapshotIterator {
    private static final short ELEMENT_NODE = 1;
    private static final short TEXT_NODE = 3;
    private static final short DOCUMENT_NODE = 9;
    private static final Set<String> VOID_ELEMENTS = new HashSet<String>(Arrays.asList("AREA", "BASE", "BASEFONT", "BGSOUND", "BR", "COL", "COMMAND", "EMBED", "FRAME", "HR", "IMAGE", "IMG", "INPUT", "ISINDEX", "KEYGEN", "LINK", "MENUITEM", "META", "NEXTID", "PARAM", "SOURCE", "TRACK", "WBR"));

    public static List<DocumentSnapshot> toHtml(List<DOMNode> nodes) {
        if (nodes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DocumentSnapshot> documents = new ArrayList<DocumentSnapshot>();
        for (int i = 0; i < nodes.size(); ++i) {
            DOMNode node = nodes.get(i);
            if (node.getNodeType() != 9) continue;
            StringBuilder builder = new StringBuilder(2048);
            DomSnapshotIterator.iterate(nodes, node, builder);
            DocumentSnapshot snapshot = new DocumentSnapshot(builder.toString(), node.getBaseURL(), node.getDocumentURL(), node.getFrameId());
            documents.add(snapshot);
        }
        return documents;
    }

    private static void iterate(List<DOMNode> nodes, DOMNode next, StringBuilder builder) {
        String nodeName = next.getNodeName();
        Integer nodeType = next.getNodeType();
        if (nodeType == 1 || next.getNodeType() == 9) {
            if (next.getNodeType() == 1 && !nodeName.startsWith("::")) {
                builder.append("<" + nodeName);
                List<NameValue> attributes = next.getAttributes();
                if (attributes.isEmpty()) {
                    builder.append(">");
                } else {
                    for (NameValue nv : attributes) {
                        builder.append(" " + nv.getName());
                        if (nv.getValue() == null || nv.getValue().isEmpty()) continue;
                        builder.append("=\"" + nv.getValue() + "\"");
                    }
                    builder.append(">");
                }
            }
            for (Integer childIndex : next.getChildNodeIndexes()) {
                DOMNode child = nodes.get(childIndex);
                DomSnapshotIterator.iterate(nodes, child, builder);
            }
            if (1 == nodeType && !VOID_ELEMENTS.contains(nodeName) && !nodeName.startsWith("::")) {
                builder.append("</" + nodeName + ">");
            }
        } else if (next.getNodeType() == 3) {
            builder.append(next.getNodeValue());
        }
    }
}

