/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.serialization;

import io.webfolder.cdp.logger.CdpLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class LoggingInputStream
extends InputStream {
    private final InputStream wrappedStream;
    private final CdpLogger log;
    private final ByteArrayOutputStream buffer;
    private final String message;
    private boolean didLog = false;

    public LoggingInputStream(InputStream wrappedStream, CdpLogger log, String message) {
        this.wrappedStream = wrappedStream;
        this.log = log;
        this.buffer = new ByteArrayOutputStream();
        this.message = message;
    }

    @Override
    public int read() throws IOException {
        try {
            int res = this.wrappedStream.read();
            if (res < 0) {
                this.doLog();
            } else {
                this.buffer.write(res);
            }
            return res;
        }
        catch (IOException ex) {
            this.doLog();
            throw ex;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        try {
            int res = this.wrappedStream.read(b);
            if (res < 0) {
                this.doLog();
            } else {
                this.buffer.write(b);
            }
            return res;
        }
        catch (IOException ex) {
            this.doLog();
            throw ex;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            int res = this.wrappedStream.read(b, off, len);
            if (res < 0) {
                this.doLog();
            } else {
                this.buffer.write(b, off, res);
            }
            return res;
        }
        catch (IOException ex) {
            this.doLog();
            throw ex;
        }
    }

    @Override
    public byte[] readNBytes(int len) throws IOException {
        try {
            return this.wrappedStream.readNBytes(len);
        }
        catch (IOException ex) {
            this.doLog();
            throw ex;
        }
    }

    @Override
    public int readNBytes(byte[] b, int off, int len) throws IOException {
        try {
            return this.wrappedStream.readNBytes(b, off, len);
        }
        catch (IOException ex) {
            this.doLog();
            throw ex;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        try {
            return this.wrappedStream.skip(n);
        }
        catch (IOException ex) {
            this.doLog();
            throw ex;
        }
    }

    @Override
    public int available() throws IOException {
        try {
            return this.wrappedStream.available();
        }
        catch (IOException ex) {
            this.doLog();
            throw ex;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.wrappedStream.close();
            super.close();
            this.doLog();
        }
        catch (IOException ex) {
            this.doLog();
            throw ex;
        }
    }

    private void doLog() {
        String content;
        if (this.didLog) {
            return;
        }
        try {
            content = this.buffer.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            content = this.buffer.toString();
        }
        if (this.message != null) {
            this.log.debug(this.message, content);
        } else {
            this.log.debug(content, new Object[0]);
        }
        this.didLog = true;
    }
}

