/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.serialization;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.webfolder.cdp.logger.CdpLogger;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

class GsonEnumTypeAdapter<T extends Enum<T>>
extends TypeAdapter<T> {
    private final CdpLogger log;
    private final Class<T> enumClass;
    private final Map<String, T> nameToConstant;
    private final Map<T, String> constantToName;
    private static final String ENUM_UNKNOWN_CONSTANT = "_UNKNOWN_";

    GsonEnumTypeAdapter(Class<T> enumClass, CdpLogger log) {
        this.log = log;
        this.enumClass = enumClass;
        try {
            Enum[] constants = (Enum[])enumClass.getEnumConstants();
            this.nameToConstant = new HashMap<String, T>(constants.length);
            this.constantToName = new HashMap<T, String>(constants.length);
            for (Enum constant : constants) {
                String name = constant.name();
                SerializedName annotation = enumClass.getField(name).getAnnotation(SerializedName.class);
                if (annotation != null) {
                    name = annotation.value();
                    for (String alternate : annotation.alternate()) {
                        this.nameToConstant.put(alternate, constant);
                    }
                }
                this.nameToConstant.put(name, constant);
                this.constantToName.put(constant, name);
            }
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void write(JsonWriter out, T value) throws IOException {
        out.value(value == null ? null : this.constantToName.get(value));
    }

    public T read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        String valueStr = in.nextString();
        Enum value = (Enum)this.nameToConstant.get(valueStr);
        if (value == null) {
            if (this.log != null) {
                this.log.warn("Missing enum constant [{}.{}]. [{}] mapped to [_UNKNOWN_].", this.enumClass.getSimpleName(), valueStr, valueStr);
            }
            value = (Enum)this.nameToConstant.get(ENUM_UNKNOWN_CONSTANT);
        }
        return (T)value;
    }
}

