/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.logger;

import io.webfolder.cdp.Options;
import io.webfolder.cdp.logger.CdpConsoleLogger;
import io.webfolder.cdp.logger.CdpJulLogger;
import io.webfolder.cdp.logger.CdpLog4j2Logger;
import io.webfolder.cdp.logger.CdpLog4jLogger;
import io.webfolder.cdp.logger.CdpLogger;
import io.webfolder.cdp.logger.CdpLoggerType;
import io.webfolder.cdp.logger.CdpLogggerLevel;
import io.webfolder.cdp.logger.CdpSlf4jLogger;
import io.webfolder.cdp.logger.LoggerFactory;

public class CdpLoggerFactory
implements LoggerFactory {
    private final CdpLoggerType loggerType;
    private final CdpLogggerLevel consoleLoggerLevel;
    private final String loggerNamePrefix;
    private static CdpLogger NULL_LOGGER = new CdpLogger(){

        @Override
        public void info(String message, Object ... args) {
        }

        @Override
        public void debug(String message, Object ... args) {
        }

        @Override
        public void error(String message, Object ... args) {
        }

        @Override
        public void warn(String message, Object ... args) {
        }

        @Override
        public void error(String message, Throwable t) {
        }

        @Override
        public boolean isDebugEnabled() {
            return false;
        }
    };

    public CdpLoggerFactory(Options options) {
        this.loggerType = options.loggerType();
        this.consoleLoggerLevel = options.consoleLoggerLevel();
        this.loggerNamePrefix = options.loggerNamePrefix();
    }

    public CdpLoggerFactory(CdpLoggerType loggerType, CdpLogggerLevel consoleLogggerLevel, String loggerNamePrefix) {
        this.loggerType = loggerType;
        this.consoleLoggerLevel = consoleLogggerLevel;
        this.loggerNamePrefix = loggerNamePrefix;
    }

    @Override
    public CdpLogger getLogger(String name) {
        if (this.loggerNamePrefix != null) {
            name = this.loggerNamePrefix + name;
        }
        switch (this.loggerType) {
            case Slf4j: {
                return new CdpSlf4jLogger(name);
            }
            case Console: {
                return new CdpConsoleLogger(this.consoleLoggerLevel);
            }
            case Log4j: {
                return new CdpLog4jLogger(name);
            }
            case Log4j2: {
                return new CdpLog4j2Logger(name);
            }
            case Jul: {
                return new CdpJulLogger(name);
            }
        }
        return NULL_LOGGER;
    }
}

