/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.command;

import io.webfolder.cdp.TypeReference;
import io.webfolder.cdp.command.Storage;
import io.webfolder.cdp.session.CommandReturnType;
import io.webfolder.cdp.session.DomainCommand;
import io.webfolder.cdp.session.SessionInvocationHandler;
import io.webfolder.cdp.type.network.Cookie;
import io.webfolder.cdp.type.network.CookieParam;
import io.webfolder.cdp.type.storage.GetUsageAndQuotaResult;
import io.webfolder.cdp.type.storage.InterestGroupDetails;
import io.webfolder.cdp.type.storage.TrustTokens;
import java.lang.reflect.Type;
import java.util.List;

class StorageImpl
implements Storage {
    private static final TypeReference<List<Cookie>> LIST_COOKIE = new TypeReference<List<Cookie>>(){};
    private static final TypeReference<List<TrustTokens>> LIST_TRUSTTOKENS = new TypeReference<List<TrustTokens>>(){};
    private static final CommandReturnType CRT_CLEAR_COOKIES = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_CLEAR_DATA_FOR_ORIGIN = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_CLEAR_TRUST_TOKENS = new CommandReturnType("didDeleteTokens", (Type)((Object)Boolean.class), null);
    private static final CommandReturnType CRT_GET_COOKIES = new CommandReturnType("cookies", (Type)((Object)List.class), LIST_COOKIE);
    private static final CommandReturnType CRT_GET_INTEREST_GROUP_DETAILS = new CommandReturnType("details", (Type)((Object)InterestGroupDetails.class), null);
    private static final CommandReturnType CRT_GET_STORAGE_KEY_FOR_FRAME = new CommandReturnType("storageKey", (Type)((Object)String.class), null);
    private static final CommandReturnType CRT_GET_TRUST_TOKENS = new CommandReturnType("tokens", (Type)((Object)List.class), LIST_TRUSTTOKENS);
    private static final CommandReturnType CRT_GET_USAGE_AND_QUOTA = new CommandReturnType(null, (Type)((Object)GetUsageAndQuotaResult.class), null);
    private static final CommandReturnType CRT_OVERRIDE_QUOTA_FOR_ORIGIN = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SET_COOKIES = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SET_INTEREST_GROUP_TRACKING = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_TRACK_CACHE_STORAGE_FOR_ORIGIN = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_TRACK_INDEXED_DB_FOR_ORIGIN = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_UNTRACK_CACHE_STORAGE_FOR_ORIGIN = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_UNTRACK_INDEXED_DB_FOR_ORIGIN = new CommandReturnType(null, Void.TYPE, null);
    private static final String[] EMPTY_ARGS = new String[0];
    private static final Object[] EMPTY_VALUES = new Object[0];
    private static final String[] PARAMS_CLEAR_COOKIES_2 = new String[]{"browserContextId"};
    private static final String[] PARAMS_CLEAR_DATA_FOR_ORIGIN_1 = new String[]{"origin", "storageTypes"};
    private static final String[] PARAMS_CLEAR_TRUST_TOKENS_1 = new String[]{"issuerOrigin"};
    private static final String[] PARAMS_GET_COOKIES_2 = new String[]{"browserContextId"};
    private static final String[] PARAMS_GET_INTEREST_GROUP_DETAILS_1 = new String[]{"ownerOrigin", "name"};
    private static final String[] PARAMS_GET_STORAGE_KEY_FOR_FRAME_1 = new String[]{"frameId"};
    private static final String[] PARAMS_GET_USAGE_AND_QUOTA_1 = new String[]{"origin"};
    private static final String[] PARAMS_OVERRIDE_QUOTA_FOR_ORIGIN_1 = new String[]{"origin"};
    private static final String[] PARAMS_OVERRIDE_QUOTA_FOR_ORIGIN_2 = new String[]{"origin", "quotaSize"};
    private static final String[] PARAMS_SET_COOKIES_1 = new String[]{"cookies"};
    private static final String[] PARAMS_SET_COOKIES_2 = new String[]{"cookies", "browserContextId"};
    private static final String[] PARAMS_SET_INTEREST_GROUP_TRACKING_1 = new String[]{"enable"};
    private static final String[] PARAMS_TRACK_CACHE_STORAGE_FOR_ORIGIN_1 = new String[]{"origin"};
    private static final String[] PARAMS_TRACK_INDEXED_DB_FOR_ORIGIN_1 = new String[]{"origin"};
    private static final String[] PARAMS_UNTRACK_CACHE_STORAGE_FOR_ORIGIN_1 = new String[]{"origin"};
    private static final String[] PARAMS_UNTRACK_INDEXED_DB_FOR_ORIGIN_1 = new String[]{"origin"};
    private final SessionInvocationHandler handler;

    public StorageImpl(SessionInvocationHandler handler) {
        this.handler = handler;
    }

    @Override
    public void clearCookies() {
        this.handler.invoke(DomainCommand.Storage_clearCookies, CRT_CLEAR_COOKIES, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public void clearCookies(String browserContextId) {
        this.handler.invoke(DomainCommand.Storage_clearCookies, CRT_CLEAR_COOKIES, PARAMS_CLEAR_COOKIES_2, new Object[]{browserContextId}, true);
    }

    @Override
    public void clearDataForOrigin(String origin, String storageTypes) {
        this.handler.invoke(DomainCommand.Storage_clearDataForOrigin, CRT_CLEAR_DATA_FOR_ORIGIN, PARAMS_CLEAR_DATA_FOR_ORIGIN_1, new Object[]{origin, storageTypes}, true);
    }

    @Override
    public Boolean clearTrustTokens(String issuerOrigin) {
        return (Boolean)this.handler.invoke(DomainCommand.Storage_clearTrustTokens, CRT_CLEAR_TRUST_TOKENS, PARAMS_CLEAR_TRUST_TOKENS_1, new Object[]{issuerOrigin}, true);
    }

    @Override
    public List<Cookie> getCookies() {
        return (List)this.handler.invoke(DomainCommand.Storage_getCookies, CRT_GET_COOKIES, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public List<Cookie> getCookies(String browserContextId) {
        return (List)this.handler.invoke(DomainCommand.Storage_getCookies, CRT_GET_COOKIES, PARAMS_GET_COOKIES_2, new Object[]{browserContextId}, true);
    }

    @Override
    public InterestGroupDetails getInterestGroupDetails(String ownerOrigin, String name) {
        return (InterestGroupDetails)this.handler.invoke(DomainCommand.Storage_getInterestGroupDetails, CRT_GET_INTEREST_GROUP_DETAILS, PARAMS_GET_INTEREST_GROUP_DETAILS_1, new Object[]{ownerOrigin, name}, true);
    }

    @Override
    public String getStorageKeyForFrame(String frameId) {
        return (String)this.handler.invoke(DomainCommand.Storage_getStorageKeyForFrame, CRT_GET_STORAGE_KEY_FOR_FRAME, PARAMS_GET_STORAGE_KEY_FOR_FRAME_1, new Object[]{frameId}, true);
    }

    @Override
    public List<TrustTokens> getTrustTokens() {
        return (List)this.handler.invoke(DomainCommand.Storage_getTrustTokens, CRT_GET_TRUST_TOKENS, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public GetUsageAndQuotaResult getUsageAndQuota(String origin) {
        return (GetUsageAndQuotaResult)this.handler.invoke(DomainCommand.Storage_getUsageAndQuota, CRT_GET_USAGE_AND_QUOTA, PARAMS_GET_USAGE_AND_QUOTA_1, new Object[]{origin}, true);
    }

    @Override
    public void overrideQuotaForOrigin(String origin) {
        this.handler.invoke(DomainCommand.Storage_overrideQuotaForOrigin, CRT_OVERRIDE_QUOTA_FOR_ORIGIN, PARAMS_OVERRIDE_QUOTA_FOR_ORIGIN_1, new Object[]{origin}, true);
    }

    @Override
    public void overrideQuotaForOrigin(String origin, Double quotaSize) {
        this.handler.invoke(DomainCommand.Storage_overrideQuotaForOrigin, CRT_OVERRIDE_QUOTA_FOR_ORIGIN, PARAMS_OVERRIDE_QUOTA_FOR_ORIGIN_2, new Object[]{origin, quotaSize}, true);
    }

    @Override
    public void setCookies(List<CookieParam> cookies) {
        this.handler.invoke(DomainCommand.Storage_setCookies, CRT_SET_COOKIES, PARAMS_SET_COOKIES_1, new Object[]{cookies}, true);
    }

    @Override
    public void setCookies(List<CookieParam> cookies, String browserContextId) {
        this.handler.invoke(DomainCommand.Storage_setCookies, CRT_SET_COOKIES, PARAMS_SET_COOKIES_2, new Object[]{cookies, browserContextId}, true);
    }

    @Override
    public void setInterestGroupTracking(Boolean enable) {
        this.handler.invoke(DomainCommand.Storage_setInterestGroupTracking, CRT_SET_INTEREST_GROUP_TRACKING, PARAMS_SET_INTEREST_GROUP_TRACKING_1, new Object[]{enable}, true);
    }

    @Override
    public void trackCacheStorageForOrigin(String origin) {
        this.handler.invoke(DomainCommand.Storage_trackCacheStorageForOrigin, CRT_TRACK_CACHE_STORAGE_FOR_ORIGIN, PARAMS_TRACK_CACHE_STORAGE_FOR_ORIGIN_1, new Object[]{origin}, true);
    }

    @Override
    public void trackIndexedDBForOrigin(String origin) {
        this.handler.invoke(DomainCommand.Storage_trackIndexedDBForOrigin, CRT_TRACK_INDEXED_DB_FOR_ORIGIN, PARAMS_TRACK_INDEXED_DB_FOR_ORIGIN_1, new Object[]{origin}, true);
    }

    @Override
    public void untrackCacheStorageForOrigin(String origin) {
        this.handler.invoke(DomainCommand.Storage_untrackCacheStorageForOrigin, CRT_UNTRACK_CACHE_STORAGE_FOR_ORIGIN, PARAMS_UNTRACK_CACHE_STORAGE_FOR_ORIGIN_1, new Object[]{origin}, true);
    }

    @Override
    public void untrackIndexedDBForOrigin(String origin) {
        this.handler.invoke(DomainCommand.Storage_untrackIndexedDBForOrigin, CRT_UNTRACK_INDEXED_DB_FOR_ORIGIN, PARAMS_UNTRACK_INDEXED_DB_FOR_ORIGIN_1, new Object[]{origin}, true);
    }
}

