/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.command;

import io.webfolder.cdp.TypeReference;
import io.webfolder.cdp.command.StorageAsync;
import io.webfolder.cdp.session.CommandReturnType;
import io.webfolder.cdp.session.DomainCommand;
import io.webfolder.cdp.session.SessionInvocationHandler;
import io.webfolder.cdp.type.network.Cookie;
import io.webfolder.cdp.type.network.CookieParam;
import io.webfolder.cdp.type.storage.GetUsageAndQuotaResult;
import io.webfolder.cdp.type.storage.InterestGroupDetails;
import io.webfolder.cdp.type.storage.TrustTokens;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.CompletableFuture;

class StorageAsyncImpl
implements StorageAsync {
    private static final TypeReference<List<Cookie>> LIST_COOKIE = new TypeReference<List<Cookie>>(){};
    private static final TypeReference<List<TrustTokens>> LIST_TRUSTTOKENS = new TypeReference<List<TrustTokens>>(){};
    private static final CommandReturnType CRT_CLEAR_COOKIES = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_CLEAR_DATA_FOR_ORIGIN = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_CLEAR_TRUST_TOKENS = new CommandReturnType("didDeleteTokens", (Type)((Object)Boolean.class), null);
    private static final CommandReturnType CRT_GET_COOKIES = new CommandReturnType("cookies", (Type)((Object)List.class), LIST_COOKIE);
    private static final CommandReturnType CRT_GET_INTEREST_GROUP_DETAILS = new CommandReturnType("details", (Type)((Object)InterestGroupDetails.class), null);
    private static final CommandReturnType CRT_GET_STORAGE_KEY_FOR_FRAME = new CommandReturnType("storageKey", (Type)((Object)String.class), null);
    private static final CommandReturnType CRT_GET_TRUST_TOKENS = new CommandReturnType("tokens", (Type)((Object)List.class), LIST_TRUSTTOKENS);
    private static final CommandReturnType CRT_GET_USAGE_AND_QUOTA = new CommandReturnType(null, (Type)((Object)GetUsageAndQuotaResult.class), null);
    private static final CommandReturnType CRT_OVERRIDE_QUOTA_FOR_ORIGIN = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SET_COOKIES = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SET_INTEREST_GROUP_TRACKING = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_TRACK_CACHE_STORAGE_FOR_ORIGIN = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_TRACK_INDEXED_DB_FOR_ORIGIN = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_UNTRACK_CACHE_STORAGE_FOR_ORIGIN = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_UNTRACK_INDEXED_DB_FOR_ORIGIN = new CommandReturnType(null, Void.TYPE, null);
    private static final String[] EMPTY_ARGS = new String[0];
    private static final Object[] EMPTY_VALUES = new Object[0];
    private static final String[] PARAMS_CLEAR_COOKIES_2 = new String[]{"browserContextId"};
    private static final String[] PARAMS_CLEAR_DATA_FOR_ORIGIN_1 = new String[]{"origin", "storageTypes"};
    private static final String[] PARAMS_CLEAR_TRUST_TOKENS_1 = new String[]{"issuerOrigin"};
    private static final String[] PARAMS_GET_COOKIES_2 = new String[]{"browserContextId"};
    private static final String[] PARAMS_GET_INTEREST_GROUP_DETAILS_1 = new String[]{"ownerOrigin", "name"};
    private static final String[] PARAMS_GET_STORAGE_KEY_FOR_FRAME_1 = new String[]{"frameId"};
    private static final String[] PARAMS_GET_USAGE_AND_QUOTA_1 = new String[]{"origin"};
    private static final String[] PARAMS_OVERRIDE_QUOTA_FOR_ORIGIN_1 = new String[]{"origin"};
    private static final String[] PARAMS_OVERRIDE_QUOTA_FOR_ORIGIN_2 = new String[]{"origin", "quotaSize"};
    private static final String[] PARAMS_SET_COOKIES_1 = new String[]{"cookies"};
    private static final String[] PARAMS_SET_COOKIES_2 = new String[]{"cookies", "browserContextId"};
    private static final String[] PARAMS_SET_INTEREST_GROUP_TRACKING_1 = new String[]{"enable"};
    private static final String[] PARAMS_TRACK_CACHE_STORAGE_FOR_ORIGIN_1 = new String[]{"origin"};
    private static final String[] PARAMS_TRACK_INDEXED_DB_FOR_ORIGIN_1 = new String[]{"origin"};
    private static final String[] PARAMS_UNTRACK_CACHE_STORAGE_FOR_ORIGIN_1 = new String[]{"origin"};
    private static final String[] PARAMS_UNTRACK_INDEXED_DB_FOR_ORIGIN_1 = new String[]{"origin"};
    private final SessionInvocationHandler handler;

    public StorageAsyncImpl(SessionInvocationHandler handler) {
        this.handler = handler;
    }

    @Override
    public CompletableFuture<Void> clearCookies() {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Storage_clearCookies, CRT_CLEAR_COOKIES, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<Void> clearCookies(String browserContextId) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Storage_clearCookies, CRT_CLEAR_COOKIES, PARAMS_CLEAR_COOKIES_2, new Object[]{browserContextId}, false);
    }

    @Override
    public CompletableFuture<Void> clearDataForOrigin(String origin, String storageTypes) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Storage_clearDataForOrigin, CRT_CLEAR_DATA_FOR_ORIGIN, PARAMS_CLEAR_DATA_FOR_ORIGIN_1, new Object[]{origin, storageTypes}, false);
    }

    @Override
    public CompletableFuture<Boolean> clearTrustTokens(String issuerOrigin) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Storage_clearTrustTokens, CRT_CLEAR_TRUST_TOKENS, PARAMS_CLEAR_TRUST_TOKENS_1, new Object[]{issuerOrigin}, false);
    }

    @Override
    public CompletableFuture<List<Cookie>> getCookies() {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Storage_getCookies, CRT_GET_COOKIES, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<List<Cookie>> getCookies(String browserContextId) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Storage_getCookies, CRT_GET_COOKIES, PARAMS_GET_COOKIES_2, new Object[]{browserContextId}, false);
    }

    @Override
    public CompletableFuture<InterestGroupDetails> getInterestGroupDetails(String ownerOrigin, String name) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Storage_getInterestGroupDetails, CRT_GET_INTEREST_GROUP_DETAILS, PARAMS_GET_INTEREST_GROUP_DETAILS_1, new Object[]{ownerOrigin, name}, false);
    }

    @Override
    public CompletableFuture<String> getStorageKeyForFrame(String frameId) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Storage_getStorageKeyForFrame, CRT_GET_STORAGE_KEY_FOR_FRAME, PARAMS_GET_STORAGE_KEY_FOR_FRAME_1, new Object[]{frameId}, false);
    }

    @Override
    public CompletableFuture<List<TrustTokens>> getTrustTokens() {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Storage_getTrustTokens, CRT_GET_TRUST_TOKENS, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<GetUsageAndQuotaResult> getUsageAndQuota(String origin) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Storage_getUsageAndQuota, CRT_GET_USAGE_AND_QUOTA, PARAMS_GET_USAGE_AND_QUOTA_1, new Object[]{origin}, false);
    }

    @Override
    public CompletableFuture<Void> overrideQuotaForOrigin(String origin) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Storage_overrideQuotaForOrigin, CRT_OVERRIDE_QUOTA_FOR_ORIGIN, PARAMS_OVERRIDE_QUOTA_FOR_ORIGIN_1, new Object[]{origin}, false);
    }

    @Override
    public CompletableFuture<Void> overrideQuotaForOrigin(String origin, Double quotaSize) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Storage_overrideQuotaForOrigin, CRT_OVERRIDE_QUOTA_FOR_ORIGIN, PARAMS_OVERRIDE_QUOTA_FOR_ORIGIN_2, new Object[]{origin, quotaSize}, false);
    }

    @Override
    public CompletableFuture<Void> setCookies(List<CookieParam> cookies) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Storage_setCookies, CRT_SET_COOKIES, PARAMS_SET_COOKIES_1, new Object[]{cookies}, false);
    }

    @Override
    public CompletableFuture<Void> setCookies(List<CookieParam> cookies, String browserContextId) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Storage_setCookies, CRT_SET_COOKIES, PARAMS_SET_COOKIES_2, new Object[]{cookies, browserContextId}, false);
    }

    @Override
    public CompletableFuture<Void> setInterestGroupTracking(Boolean enable) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Storage_setInterestGroupTracking, CRT_SET_INTEREST_GROUP_TRACKING, PARAMS_SET_INTEREST_GROUP_TRACKING_1, new Object[]{enable}, false);
    }

    @Override
    public CompletableFuture<Void> trackCacheStorageForOrigin(String origin) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Storage_trackCacheStorageForOrigin, CRT_TRACK_CACHE_STORAGE_FOR_ORIGIN, PARAMS_TRACK_CACHE_STORAGE_FOR_ORIGIN_1, new Object[]{origin}, false);
    }

    @Override
    public CompletableFuture<Void> trackIndexedDBForOrigin(String origin) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Storage_trackIndexedDBForOrigin, CRT_TRACK_INDEXED_DB_FOR_ORIGIN, PARAMS_TRACK_INDEXED_DB_FOR_ORIGIN_1, new Object[]{origin}, false);
    }

    @Override
    public CompletableFuture<Void> untrackCacheStorageForOrigin(String origin) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Storage_untrackCacheStorageForOrigin, CRT_UNTRACK_CACHE_STORAGE_FOR_ORIGIN, PARAMS_UNTRACK_CACHE_STORAGE_FOR_ORIGIN_1, new Object[]{origin}, false);
    }

    @Override
    public CompletableFuture<Void> untrackIndexedDBForOrigin(String origin) {
        return (CompletableFuture)this.handler.invoke(DomainCommand.Storage_untrackIndexedDBForOrigin, CRT_UNTRACK_INDEXED_DB_FOR_ORIGIN, PARAMS_UNTRACK_INDEXED_DB_FOR_ORIGIN_1, new Object[]{origin}, false);
    }
}

