/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.cdp.command;

import io.webfolder.cdp.command.Memory;
import io.webfolder.cdp.session.CommandReturnType;
import io.webfolder.cdp.session.DomainCommand;
import io.webfolder.cdp.session.SessionInvocationHandler;
import io.webfolder.cdp.type.memory.GetDOMCountersResult;
import io.webfolder.cdp.type.memory.PressureLevel;
import io.webfolder.cdp.type.memory.SamplingProfile;
import java.lang.reflect.Type;

class MemoryImpl
implements Memory {
    private static final CommandReturnType CRT_FORCIBLY_PURGE_JAVA_SCRIPT_MEMORY = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_GET_ALL_TIME_SAMPLING_PROFILE = new CommandReturnType("profile", (Type)((Object)SamplingProfile.class), null);
    private static final CommandReturnType CRT_GET_BROWSER_SAMPLING_PROFILE = new CommandReturnType("profile", (Type)((Object)SamplingProfile.class), null);
    private static final CommandReturnType CRT_GET_DO_MCOUNTERS = new CommandReturnType(null, (Type)((Object)GetDOMCountersResult.class), null);
    private static final CommandReturnType CRT_GET_SAMPLING_PROFILE = new CommandReturnType("profile", (Type)((Object)SamplingProfile.class), null);
    private static final CommandReturnType CRT_PREPARE_FOR_LEAK_DETECTION = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SET_PRESSURE_NOTIFICATIONS_SUPPRESSED = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SIMULATE_PRESSURE_NOTIFICATION = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_START_SAMPLING = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_STOP_SAMPLING = new CommandReturnType(null, Void.TYPE, null);
    private static final String[] EMPTY_ARGS = new String[0];
    private static final Object[] EMPTY_VALUES = new Object[0];
    private static final String[] PARAMS_SET_PRESSURE_NOTIFICATIONS_SUPPRESSED_1 = new String[]{"suppressed"};
    private static final String[] PARAMS_SIMULATE_PRESSURE_NOTIFICATION_1 = new String[]{"level"};
    private static final String[] PARAMS_START_SAMPLING_2 = new String[]{"samplingInterval", "suppressRandomness"};
    private final SessionInvocationHandler handler;

    public MemoryImpl(SessionInvocationHandler handler) {
        this.handler = handler;
    }

    @Override
    public void forciblyPurgeJavaScriptMemory() {
        this.handler.invoke(DomainCommand.Memory_forciblyPurgeJavaScriptMemory, CRT_FORCIBLY_PURGE_JAVA_SCRIPT_MEMORY, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public SamplingProfile getAllTimeSamplingProfile() {
        return (SamplingProfile)this.handler.invoke(DomainCommand.Memory_getAllTimeSamplingProfile, CRT_GET_ALL_TIME_SAMPLING_PROFILE, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public SamplingProfile getBrowserSamplingProfile() {
        return (SamplingProfile)this.handler.invoke(DomainCommand.Memory_getBrowserSamplingProfile, CRT_GET_BROWSER_SAMPLING_PROFILE, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public GetDOMCountersResult getDOMCounters() {
        return (GetDOMCountersResult)this.handler.invoke(DomainCommand.Memory_getDOMCounters, CRT_GET_DO_MCOUNTERS, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public SamplingProfile getSamplingProfile() {
        return (SamplingProfile)this.handler.invoke(DomainCommand.Memory_getSamplingProfile, CRT_GET_SAMPLING_PROFILE, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public void prepareForLeakDetection() {
        this.handler.invoke(DomainCommand.Memory_prepareForLeakDetection, CRT_PREPARE_FOR_LEAK_DETECTION, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public void setPressureNotificationsSuppressed(Boolean suppressed) {
        this.handler.invoke(DomainCommand.Memory_setPressureNotificationsSuppressed, CRT_SET_PRESSURE_NOTIFICATIONS_SUPPRESSED, PARAMS_SET_PRESSURE_NOTIFICATIONS_SUPPRESSED_1, new Object[]{suppressed}, true);
    }

    @Override
    public void simulatePressureNotification(PressureLevel level) {
        this.handler.invoke(DomainCommand.Memory_simulatePressureNotification, CRT_SIMULATE_PRESSURE_NOTIFICATION, PARAMS_SIMULATE_PRESSURE_NOTIFICATION_1, new Object[]{level}, true);
    }

    @Override
    public void startSampling() {
        this.handler.invoke(DomainCommand.Memory_startSampling, CRT_START_SAMPLING, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public void startSampling(Integer samplingInterval, Boolean suppressRandomness) {
        this.handler.invoke(DomainCommand.Memory_startSampling, CRT_START_SAMPLING, PARAMS_START_SAMPLING_2, new Object[]{samplingInterval, suppressRandomness}, true);
    }

    @Override
    public void stopSampling() {
        this.handler.invoke(DomainCommand.Memory_stopSampling, CRT_STOP_SAMPLING, EMPTY_ARGS, EMPTY_VALUES, true);
    }
}

